/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.fleetappsmanagement.model.UpdatePatchDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePatchRequest
extends BmcRequest<UpdatePatchDetails> {
    private String patchId;
    private UpdatePatchDetails updatePatchDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getPatchId() {
        return this.patchId;
    }

    public UpdatePatchDetails getUpdatePatchDetails() {
        return this.updatePatchDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePatchDetails getBody$() {
        return this.updatePatchDetails;
    }

    public Builder toBuilder() {
        return new Builder().patchId(this.patchId).updatePatchDetails(this.updatePatchDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",patchId=").append(String.valueOf(this.patchId));
        sb.append(",updatePatchDetails=").append(String.valueOf((Object)this.updatePatchDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePatchRequest)) {
            return false;
        }
        UpdatePatchRequest other = (UpdatePatchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.patchId, other.patchId) && Objects.equals((Object)this.updatePatchDetails, (Object)other.updatePatchDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.updatePatchDetails == null ? 43 : this.updatePatchDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePatchRequest, UpdatePatchDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String patchId = null;
        private UpdatePatchDetails updatePatchDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public Builder updatePatchDetails(UpdatePatchDetails updatePatchDetails) {
            this.updatePatchDetails = updatePatchDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePatchRequest o) {
            this.patchId(o.getPatchId());
            this.updatePatchDetails(o.getUpdatePatchDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePatchRequest build() {
            UpdatePatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePatchDetails body) {
            this.updatePatchDetails(body);
            return this;
        }

        public UpdatePatchRequest buildWithoutInvocationCallback() {
            UpdatePatchRequest request = new UpdatePatchRequest();
            request.patchId = this.patchId;
            request.updatePatchDetails = this.updatePatchDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

