/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.fleetappsmanagement.model.UpdatePropertyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePropertyRequest
extends BmcRequest<UpdatePropertyDetails> {
    private String propertyId;
    private UpdatePropertyDetails updatePropertyDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getPropertyId() {
        return this.propertyId;
    }

    public UpdatePropertyDetails getUpdatePropertyDetails() {
        return this.updatePropertyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePropertyDetails getBody$() {
        return this.updatePropertyDetails;
    }

    public Builder toBuilder() {
        return new Builder().propertyId(this.propertyId).updatePropertyDetails(this.updatePropertyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",propertyId=").append(String.valueOf(this.propertyId));
        sb.append(",updatePropertyDetails=").append(String.valueOf((Object)this.updatePropertyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePropertyRequest)) {
            return false;
        }
        UpdatePropertyRequest other = (UpdatePropertyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.propertyId, other.propertyId) && Objects.equals((Object)this.updatePropertyDetails, (Object)other.updatePropertyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.propertyId == null ? 43 : this.propertyId.hashCode());
        result = result * 59 + (this.updatePropertyDetails == null ? 43 : this.updatePropertyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePropertyRequest, UpdatePropertyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String propertyId = null;
        private UpdatePropertyDetails updatePropertyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public Builder updatePropertyDetails(UpdatePropertyDetails updatePropertyDetails) {
            this.updatePropertyDetails = updatePropertyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePropertyRequest o) {
            this.propertyId(o.getPropertyId());
            this.updatePropertyDetails(o.getUpdatePropertyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePropertyRequest build() {
            UpdatePropertyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePropertyDetails body) {
            this.updatePropertyDetails(body);
            return this;
        }

        public UpdatePropertyRequest buildWithoutInvocationCallback() {
            UpdatePropertyRequest request = new UpdatePropertyRequest();
            request.propertyId = this.propertyId;
            request.updatePropertyDetails = this.updatePropertyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

