/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetsoftwareupdate.FleetSoftwareUpdateAsync;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuAction;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuActionSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCollectionSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCycle;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCycleSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuDiscovery;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuDiscoverySummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJob;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJobCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJobOutputSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.TargetSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequest;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestErrorCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.requests.AbortFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.AddFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CancelFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuActionCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuCollectionCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuCycleCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuDiscoveryCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CloneFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuActionOutputContentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuJobOutputContentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuActionsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCollectionsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCyclesRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuDiscoveriesRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuDiscoveryTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuJobOutputsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuJobsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.RemoveFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ResumeFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.RetryFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.responses.AbortFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.AddFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CancelFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuActionCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuCollectionCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuCycleCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuDiscoveryCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CloneFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuActionOutputContentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuJobOutputContentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetWorkRequestResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuActionsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCollectionsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCyclesResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuDiscoveriesResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuDiscoveryTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuJobOutputsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuJobsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.RemoveFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ResumeFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.RetryFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetSoftwareUpdateAsyncClient
extends BaseAsyncClient
implements FleetSoftwareUpdateAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETSOFTWAREUPDATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://fleet-software-update.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetSoftwareUpdateAsyncClient.class);

    FleetSoftwareUpdateAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    FleetSoftwareUpdateAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"FleetSoftwareUpdateAsyncClient", (String)"getFsuActionOutputContent,getFsuJobOutputContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AbortFsuDiscoveryResponse> abortFsuDiscovery(AbortFsuDiscoveryRequest request, AsyncHandler<AbortFsuDiscoveryRequest, AbortFsuDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, AbortFsuDiscoveryResponse::builder).logger(LOG, "abortFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "AbortFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/AbortFsuDiscovery").method(Method.POST).requestBuilder(AbortFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("actions").appendPathParam("abort").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", AbortFsuDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AddFsuCollectionTargetsResponse> addFsuCollectionTargets(AddFsuCollectionTargetsRequest request, AsyncHandler<AddFsuCollectionTargetsRequest, AddFsuCollectionTargetsResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddFsuCollectionTargetsDetails(), "addFsuCollectionTargetsDetails is required");
        return this.clientCall(request, AddFsuCollectionTargetsResponse::builder).logger(LOG, "addFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "AddFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/AddFsuCollectionTargets").method(Method.POST).requestBuilder(AddFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", AddFsuCollectionTargetsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddFsuCollectionTargetsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelFsuActionResponse> cancelFsuAction(CancelFsuActionRequest request, AsyncHandler<CancelFsuActionRequest, CancelFsuActionResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelFsuActionResponse::builder).logger(LOG, "cancelFsuAction").serviceDetails("FleetSoftwareUpdate", "CancelFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/CancelFsuAction").method(Method.POST).requestBuilder(CancelFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", CancelFsuActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeFsuActionCompartmentResponse> changeFsuActionCompartment(ChangeFsuActionCompartmentRequest request, AsyncHandler<ChangeFsuActionCompartmentRequest, ChangeFsuActionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuActionCompartmentDetails(), "changeFsuActionCompartmentDetails is required");
        return this.clientCall(request, ChangeFsuActionCompartmentResponse::builder).logger(LOG, "changeFsuActionCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuActionCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/ChangeFsuActionCompartment").method(Method.POST).requestBuilder(ChangeFsuActionCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuActionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuActionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeFsuCollectionCompartmentResponse> changeFsuCollectionCompartment(ChangeFsuCollectionCompartmentRequest request, AsyncHandler<ChangeFsuCollectionCompartmentRequest, ChangeFsuCollectionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuCollectionCompartmentDetails(), "changeFsuCollectionCompartmentDetails is required");
        return this.clientCall(request, ChangeFsuCollectionCompartmentResponse::builder).logger(LOG, "changeFsuCollectionCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuCollectionCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/ChangeFsuCollectionCompartment").method(Method.POST).requestBuilder(ChangeFsuCollectionCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuCollectionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuCollectionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeFsuCycleCompartmentResponse> changeFsuCycleCompartment(ChangeFsuCycleCompartmentRequest request, AsyncHandler<ChangeFsuCycleCompartmentRequest, ChangeFsuCycleCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuCycleCompartmentDetails(), "changeFsuCycleCompartmentDetails is required");
        return this.clientCall(request, ChangeFsuCycleCompartmentResponse::builder).logger(LOG, "changeFsuCycleCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuCycleCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/ChangeFsuCycleCompartment").method(Method.POST).requestBuilder(ChangeFsuCycleCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuCycleCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuCycleCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeFsuDiscoveryCompartmentResponse> changeFsuDiscoveryCompartment(ChangeFsuDiscoveryCompartmentRequest request, AsyncHandler<ChangeFsuDiscoveryCompartmentRequest, ChangeFsuDiscoveryCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuDiscoveryCompartmentDetails(), "changeFsuDiscoveryCompartmentDetails is required");
        return this.clientCall(request, ChangeFsuDiscoveryCompartmentResponse::builder).logger(LOG, "changeFsuDiscoveryCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuDiscoveryCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/ChangeFsuDiscoveryCompartment").method(Method.POST).requestBuilder(ChangeFsuDiscoveryCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeFsuDiscoveryCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CloneFsuCycleResponse> cloneFsuCycle(CloneFsuCycleRequest request, AsyncHandler<CloneFsuCycleRequest, CloneFsuCycleResponse> handler) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneFsuCycleDetails(), "cloneFsuCycleDetails is required");
        return this.clientCall(request, CloneFsuCycleResponse::builder).logger(LOG, "cloneFsuCycle").serviceDetails("FleetSoftwareUpdate", "CloneFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/CloneFsuCycle").method(Method.POST).requestBuilder(CloneFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).appendPathParam("actions").appendPathParam("clone").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(FsuCycle.class, CloneFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("opc-work-request-id", CloneFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CloneFsuCycleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CloneFsuCycleResponse.Builder::etag).handleResponseHeaderString("Location", CloneFsuCycleResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateFsuActionResponse> createFsuAction(CreateFsuActionRequest request, AsyncHandler<CreateFsuActionRequest, CreateFsuActionResponse> handler) {
        Objects.requireNonNull(request.getCreateFsuActionDetails(), "createFsuActionDetails is required");
        return this.clientCall(request, CreateFsuActionResponse::builder).logger(LOG, "createFsuAction").serviceDetails("FleetSoftwareUpdate", "CreateFsuAction", "").method(Method.POST).requestBuilder(CreateFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FsuAction.class, CreateFsuActionResponse.Builder::fsuAction).handleResponseHeaderString("opc-work-request-id", CreateFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuActionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuActionResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuActionResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateFsuCollectionResponse> createFsuCollection(CreateFsuCollectionRequest request, AsyncHandler<CreateFsuCollectionRequest, CreateFsuCollectionResponse> handler) {
        Objects.requireNonNull(request.getCreateFsuCollectionDetails(), "createFsuCollectionDetails is required");
        return this.clientCall(request, CreateFsuCollectionResponse::builder).logger(LOG, "createFsuCollection").serviceDetails("FleetSoftwareUpdate", "CreateFsuCollection", "").method(Method.POST).requestBuilder(CreateFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FsuCollection.class, CreateFsuCollectionResponse.Builder::fsuCollection).handleResponseHeaderString("opc-work-request-id", CreateFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuCollectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuCollectionResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuCollectionResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateFsuCycleResponse> createFsuCycle(CreateFsuCycleRequest request, AsyncHandler<CreateFsuCycleRequest, CreateFsuCycleResponse> handler) {
        Objects.requireNonNull(request.getCreateFsuCycleDetails(), "createFsuCycleDetails is required");
        return this.clientCall(request, CreateFsuCycleResponse::builder).logger(LOG, "createFsuCycle").serviceDetails("FleetSoftwareUpdate", "CreateFsuCycle", "").method(Method.POST).requestBuilder(CreateFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FsuCycle.class, CreateFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("opc-work-request-id", CreateFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuCycleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuCycleResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuCycleResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateFsuDiscoveryResponse> createFsuDiscovery(CreateFsuDiscoveryRequest request, AsyncHandler<CreateFsuDiscoveryRequest, CreateFsuDiscoveryResponse> handler) {
        Objects.requireNonNull(request.getCreateFsuDiscoveryDetails(), "createFsuDiscoveryDetails is required");
        return this.clientCall(request, CreateFsuDiscoveryResponse::builder).logger(LOG, "createFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "CreateFsuDiscovery", "").method(Method.POST).requestBuilder(CreateFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FsuDiscovery.class, CreateFsuDiscoveryResponse.Builder::fsuDiscovery).handleResponseHeaderString("opc-work-request-id", CreateFsuDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuDiscoveryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuDiscoveryResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuDiscoveryResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteFsuActionResponse> deleteFsuAction(DeleteFsuActionRequest request, AsyncHandler<DeleteFsuActionRequest, DeleteFsuActionResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFsuActionResponse::builder).logger(LOG, "deleteFsuAction").serviceDetails("FleetSoftwareUpdate", "DeleteFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/DeleteFsuAction").method(Method.DELETE).requestBuilder(DeleteFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFsuCollectionResponse> deleteFsuCollection(DeleteFsuCollectionRequest request, AsyncHandler<DeleteFsuCollectionRequest, DeleteFsuCollectionResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFsuCollectionResponse::builder).logger(LOG, "deleteFsuCollection").serviceDetails("FleetSoftwareUpdate", "DeleteFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/DeleteFsuCollection").method(Method.DELETE).requestBuilder(DeleteFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuCollectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFsuCycleResponse> deleteFsuCycle(DeleteFsuCycleRequest request, AsyncHandler<DeleteFsuCycleRequest, DeleteFsuCycleResponse> handler) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFsuCycleResponse::builder).logger(LOG, "deleteFsuCycle").serviceDetails("FleetSoftwareUpdate", "DeleteFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/DeleteFsuCycle").method(Method.DELETE).requestBuilder(DeleteFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuCycleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFsuDiscoveryResponse> deleteFsuDiscovery(DeleteFsuDiscoveryRequest request, AsyncHandler<DeleteFsuDiscoveryRequest, DeleteFsuDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFsuDiscoveryResponse::builder).logger(LOG, "deleteFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "DeleteFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/DeleteFsuDiscovery").method(Method.DELETE).requestBuilder(DeleteFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFsuDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFsuJobResponse> deleteFsuJob(DeleteFsuJobRequest request, AsyncHandler<DeleteFsuJobRequest, DeleteFsuJobResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFsuJobResponse::builder).logger(LOG, "deleteFsuJob").serviceDetails("FleetSoftwareUpdate", "DeleteFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/DeleteFsuJob").method(Method.DELETE).requestBuilder(DeleteFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteFsuJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuActionResponse> getFsuAction(GetFsuActionRequest request, AsyncHandler<GetFsuActionRequest, GetFsuActionResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuActionResponse::builder).logger(LOG, "getFsuAction").serviceDetails("FleetSoftwareUpdate", "GetFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/GetFsuAction").method(Method.GET).requestBuilder(GetFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuAction.class, GetFsuActionResponse.Builder::fsuAction).handleResponseHeaderString("etag", GetFsuActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuActionOutputContentResponse> getFsuActionOutputContent(GetFsuActionOutputContentRequest request, AsyncHandler<GetFsuActionOutputContentRequest, GetFsuActionOutputContentResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuActionOutputContentResponse::builder).logger(LOG, "getFsuActionOutputContent").serviceDetails("FleetSoftwareUpdate", "GetFsuActionOutputContent", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/GetFsuActionOutputContent").method(Method.GET).requestBuilder(GetFsuActionOutputContentRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetFsuActionOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetFsuActionOutputContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuCollectionResponse> getFsuCollection(GetFsuCollectionRequest request, AsyncHandler<GetFsuCollectionRequest, GetFsuCollectionResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuCollectionResponse::builder).logger(LOG, "getFsuCollection").serviceDetails("FleetSoftwareUpdate", "GetFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/GetFsuCollection").method(Method.GET).requestBuilder(GetFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuCollection.class, GetFsuCollectionResponse.Builder::fsuCollection).handleResponseHeaderString("etag", GetFsuCollectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuCollectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuCycleResponse> getFsuCycle(GetFsuCycleRequest request, AsyncHandler<GetFsuCycleRequest, GetFsuCycleResponse> handler) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuCycleResponse::builder).logger(LOG, "getFsuCycle").serviceDetails("FleetSoftwareUpdate", "GetFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/GetFsuCycle").method(Method.GET).requestBuilder(GetFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuCycle.class, GetFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("etag", GetFsuCycleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuCycleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuDiscoveryResponse> getFsuDiscovery(GetFsuDiscoveryRequest request, AsyncHandler<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuDiscoveryResponse::builder).logger(LOG, "getFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "GetFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/GetFsuDiscovery").method(Method.GET).requestBuilder(GetFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuDiscovery.class, GetFsuDiscoveryResponse.Builder::fsuDiscovery).handleResponseHeaderString("etag", GetFsuDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFsuJobResponse> getFsuJob(GetFsuJobRequest request, AsyncHandler<GetFsuJobRequest, GetFsuJobResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuJobResponse::builder).logger(LOG, "getFsuJob").serviceDetails("FleetSoftwareUpdate", "GetFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/GetFsuJob").method(Method.GET).requestBuilder(GetFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuJob.class, GetFsuJobResponse.Builder::fsuJob).handleResponseHeaderString("opc-request-id", GetFsuJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetFsuJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetFsuJobOutputContentResponse> getFsuJobOutputContent(GetFsuJobOutputContentRequest request, AsyncHandler<GetFsuJobOutputContentRequest, GetFsuJobOutputContentResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFsuJobOutputContentResponse::builder).logger(LOG, "getFsuJobOutputContent").serviceDetails("FleetSoftwareUpdate", "GetFsuJobOutputContent", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/GetFsuJobOutputContent").method(Method.GET).requestBuilder(GetFsuJobOutputContentRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetFsuJobOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetFsuJobOutputContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("FleetSoftwareUpdate", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListFsuActionsResponse> listFsuActions(ListFsuActionsRequest request, AsyncHandler<ListFsuActionsRequest, ListFsuActionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFsuActionsResponse::builder).logger(LOG, "listFsuActions").serviceDetails("FleetSoftwareUpdate", "ListFsuActions", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuActionSummaryCollection/ListFsuActions").method(Method.GET).requestBuilder(ListFsuActionsRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fsuCycleId", (Object)request.getFsuCycleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuActionSummaryCollection.class, ListFsuActionsResponse.Builder::fsuActionSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuActionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuActionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuCollectionTargetsResponse> listFsuCollectionTargets(ListFsuCollectionTargetsRequest request, AsyncHandler<ListFsuCollectionTargetsRequest, ListFsuCollectionTargetsResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFsuCollectionTargetsResponse::builder).logger(LOG, "listFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "ListFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/TargetSummaryCollection/ListFsuCollectionTargets").method(Method.GET).requestBuilder(ListFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("targetId", (Object)request.getTargetId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetSummaryCollection.class, ListFsuCollectionTargetsResponse.Builder::targetSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCollectionTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCollectionTargetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuCollectionsResponse> listFsuCollections(ListFsuCollectionsRequest request, AsyncHandler<ListFsuCollectionsRequest, ListFsuCollectionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFsuCollectionsResponse::builder).logger(LOG, "listFsuCollections").serviceDetails("FleetSoftwareUpdate", "ListFsuCollections", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollectionSummaryCollection/ListFsuCollections").method(Method.GET).requestBuilder(ListFsuCollectionsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuCollectionSummaryCollection.class, ListFsuCollectionsResponse.Builder::fsuCollectionSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCollectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCollectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuCyclesResponse> listFsuCycles(ListFsuCyclesRequest request, AsyncHandler<ListFsuCyclesRequest, ListFsuCyclesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFsuCyclesResponse::builder).logger(LOG, "listFsuCycles").serviceDetails("FleetSoftwareUpdate", "ListFsuCycles", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycleSummary/ListFsuCycles").method(Method.GET).requestBuilder(ListFsuCyclesRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fsuCollectionId", (Object)request.getFsuCollectionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("collectionType", (BmcEnum)request.getCollectionType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuCycleSummaryCollection.class, ListFsuCyclesResponse.Builder::fsuCycleSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCyclesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCyclesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuDiscoveriesResponse> listFsuDiscoveries(ListFsuDiscoveriesRequest request, AsyncHandler<ListFsuDiscoveriesRequest, ListFsuDiscoveriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFsuDiscoveriesResponse::builder).logger(LOG, "listFsuDiscoveries").serviceDetails("FleetSoftwareUpdate", "ListFsuDiscoveries", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscoverySummary/ListFsuDiscoveries").method(Method.GET).requestBuilder(ListFsuDiscoveriesRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuDiscoverySummaryCollection.class, ListFsuDiscoveriesResponse.Builder::fsuDiscoverySummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuDiscoveriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuDiscoveriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuDiscoveryTargetsResponse> listFsuDiscoveryTargets(ListFsuDiscoveryTargetsRequest request, AsyncHandler<ListFsuDiscoveryTargetsRequest, ListFsuDiscoveryTargetsResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFsuDiscoveryTargetsResponse::builder).logger(LOG, "listFsuDiscoveryTargets").serviceDetails("FleetSoftwareUpdate", "ListFsuDiscoveryTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/TargetSummaryCollection/ListFsuDiscoveryTargets").method(Method.GET).requestBuilder(ListFsuDiscoveryTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("targets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("targetId", (Object)request.getTargetId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetSummaryCollection.class, ListFsuDiscoveryTargetsResponse.Builder::targetSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuDiscoveryTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuDiscoveryTargetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuJobOutputsResponse> listFsuJobOutputs(ListFsuJobOutputsRequest request, AsyncHandler<ListFsuJobOutputsRequest, ListFsuJobOutputsResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFsuJobOutputsResponse::builder).logger(LOG, "listFsuJobOutputs").serviceDetails("FleetSoftwareUpdate", "ListFsuJobOutputs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJobOutputSummary/ListFsuJobOutputs").method(Method.GET).requestBuilder(ListFsuJobOutputsRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("output").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuJobOutputSummaryCollection.class, ListFsuJobOutputsResponse.Builder::fsuJobOutputSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuJobOutputsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuJobOutputsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFsuJobsResponse> listFsuJobs(ListFsuJobsRequest request, AsyncHandler<ListFsuJobsRequest, ListFsuJobsResponse> handler) {
        Objects.requireNonNull(request.getFsuActionId(), "fsuActionId is required");
        return this.clientCall(request, ListFsuJobsResponse::builder).logger(LOG, "listFsuJobs").serviceDetails("FleetSoftwareUpdate", "ListFsuJobs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJobSummary/ListFsuJobs").method(Method.GET).requestBuilder(ListFsuJobsRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendQueryParam("fsuActionId", (Object)request.getFsuActionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FsuJobCollection.class, ListFsuJobsResponse.Builder::fsuJobCollection).handleResponseHeaderString("opc-request-id", ListFsuJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("FleetSoftwareUpdate", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("FleetSoftwareUpdate", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("FleetSoftwareUpdate", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RemoveFsuCollectionTargetsResponse> removeFsuCollectionTargets(RemoveFsuCollectionTargetsRequest request, AsyncHandler<RemoveFsuCollectionTargetsRequest, RemoveFsuCollectionTargetsResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveFsuCollectionTargetsDetails(), "removeFsuCollectionTargetsDetails is required");
        return this.clientCall(request, RemoveFsuCollectionTargetsResponse::builder).logger(LOG, "removeFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "RemoveFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/RemoveFsuCollectionTargets").method(Method.PUT).requestBuilder(RemoveFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveFsuCollectionTargetsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveFsuCollectionTargetsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResumeFsuActionResponse> resumeFsuAction(ResumeFsuActionRequest request, AsyncHandler<ResumeFsuActionRequest, ResumeFsuActionResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResumeFsuActionResponse::builder).logger(LOG, "resumeFsuAction").serviceDetails("FleetSoftwareUpdate", "ResumeFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/ResumeFsuAction").method(Method.POST).requestBuilder(ResumeFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", ResumeFsuActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetryFsuJobResponse> retryFsuJob(RetryFsuJobRequest request, AsyncHandler<RetryFsuJobRequest, RetryFsuJobResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RetryFsuJobResponse::builder).logger(LOG, "retryFsuJob").serviceDetails("FleetSoftwareUpdate", "RetryFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/RetryFsuJob").method(Method.POST).requestBuilder(RetryFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("actions").appendPathParam("retry").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RetryFsuJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFsuActionResponse> updateFsuAction(UpdateFsuActionRequest request, AsyncHandler<UpdateFsuActionRequest, UpdateFsuActionResponse> handler) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuActionDetails(), "updateFsuActionDetails is required");
        return this.clientCall(request, UpdateFsuActionResponse::builder).logger(LOG, "updateFsuAction").serviceDetails("FleetSoftwareUpdate", "UpdateFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/UpdateFsuAction").method(Method.PUT).requestBuilder(UpdateFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFsuCollectionResponse> updateFsuCollection(UpdateFsuCollectionRequest request, AsyncHandler<UpdateFsuCollectionRequest, UpdateFsuCollectionResponse> handler) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuCollectionDetails(), "updateFsuCollectionDetails is required");
        return this.clientCall(request, UpdateFsuCollectionResponse::builder).logger(LOG, "updateFsuCollection").serviceDetails("FleetSoftwareUpdate", "UpdateFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/UpdateFsuCollection").method(Method.PUT).requestBuilder(UpdateFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuCollectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFsuCycleResponse> updateFsuCycle(UpdateFsuCycleRequest request, AsyncHandler<UpdateFsuCycleRequest, UpdateFsuCycleResponse> handler) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuCycleDetails(), "updateFsuCycleDetails is required");
        return this.clientCall(request, UpdateFsuCycleResponse::builder).logger(LOG, "updateFsuCycle").serviceDetails("FleetSoftwareUpdate", "UpdateFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/UpdateFsuCycle").method(Method.PUT).requestBuilder(UpdateFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuCycleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFsuDiscoveryResponse> updateFsuDiscovery(UpdateFsuDiscoveryRequest request, AsyncHandler<UpdateFsuDiscoveryRequest, UpdateFsuDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuDiscoveryDetails(), "updateFsuDiscoveryDetails is required");
        return this.clientCall(request, UpdateFsuDiscoveryResponse::builder).logger(LOG, "updateFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "UpdateFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/UpdateFsuDiscovery").method(Method.PUT).requestBuilder(UpdateFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateFsuDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFsuJobResponse> updateFsuJob(UpdateFsuJobRequest request, AsyncHandler<UpdateFsuJobRequest, UpdateFsuJobResponse> handler) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuJobDetails(), "updateFsuJobDetails is required");
        return this.clientCall(request, UpdateFsuJobResponse::builder).logger(LOG, "updateFsuJob").serviceDetails("FleetSoftwareUpdate", "UpdateFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/UpdateFsuJob").method(Method.PUT).requestBuilder(UpdateFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(FsuJob.class, UpdateFsuJobResponse.Builder::fsuJob).handleResponseHeaderString("opc-request-id", UpdateFsuJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateFsuJobResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetSoftwareUpdateAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetSoftwareUpdateAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetSoftwareUpdateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetSoftwareUpdateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetSoftwareUpdateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetSoftwareUpdateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetSoftwareUpdateAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetSoftwareUpdateAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetSoftwareUpdateAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "fleetsoftwareupdate";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetsoftwareupdate");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public FleetSoftwareUpdateAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetSoftwareUpdateAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

