/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetsoftwareupdate.FleetSoftwareUpdate;
import com.oracle.bmc.fleetsoftwareupdate.FleetSoftwareUpdatePaginators;
import com.oracle.bmc.fleetsoftwareupdate.FleetSoftwareUpdateWaiters;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuAction;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuActionSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCollectionSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCycle;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuCycleSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuDiscovery;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuDiscoverySummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJob;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJobCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJobOutputSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.TargetSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequest;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestErrorCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.fleetsoftwareupdate.model.WorkRequestSummaryCollection;
import com.oracle.bmc.fleetsoftwareupdate.requests.AbortFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.AddFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CancelFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuActionCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuCollectionCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuCycleCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ChangeFsuDiscoveryCompartmentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CloneFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.CreateFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.DeleteFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuActionOutputContentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuJobOutputContentRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuActionsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCollectionsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuCyclesRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuDiscoveriesRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuDiscoveryTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuJobOutputsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListFsuJobsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.RemoveFsuCollectionTargetsRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.ResumeFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.RetryFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.UpdateFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.responses.AbortFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.AddFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CancelFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuActionCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuCollectionCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuCycleCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ChangeFsuDiscoveryCompartmentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CloneFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.CreateFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.DeleteFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuActionOutputContentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuJobOutputContentResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetWorkRequestResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuActionsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCollectionsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuCyclesResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuDiscoveriesResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuDiscoveryTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuJobOutputsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListFsuJobsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.RemoveFsuCollectionTargetsResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.ResumeFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.RetryFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.UpdateFsuJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetSoftwareUpdateClient
extends BaseSyncClient
implements FleetSoftwareUpdate {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETSOFTWAREUPDATE").serviceEndpointPrefix("").serviceEndpointTemplate("https://fleet-software-update.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetSoftwareUpdateClient.class);
    private final FleetSoftwareUpdateWaiters waiters;
    private final FleetSoftwareUpdatePaginators paginators;

    FleetSoftwareUpdateClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    FleetSoftwareUpdateClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("FleetSoftwareUpdate-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FleetSoftwareUpdateWaiters(executorService, this);
        this.paginators = new FleetSoftwareUpdatePaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"FleetSoftwareUpdateClient", (String)"getFsuActionOutputContent,getFsuJobOutputContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AbortFsuDiscoveryResponse abortFsuDiscovery(AbortFsuDiscoveryRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return (AbortFsuDiscoveryResponse)this.clientCall(request, AbortFsuDiscoveryResponse::builder).logger(LOG, "abortFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "AbortFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/AbortFsuDiscovery").method(Method.POST).requestBuilder(AbortFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("actions").appendPathParam("abort").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", AbortFsuDiscoveryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddFsuCollectionTargetsResponse addFsuCollectionTargets(AddFsuCollectionTargetsRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddFsuCollectionTargetsDetails(), "addFsuCollectionTargetsDetails is required");
        return (AddFsuCollectionTargetsResponse)this.clientCall(request, AddFsuCollectionTargetsResponse::builder).logger(LOG, "addFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "AddFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/AddFsuCollectionTargets").method(Method.POST).requestBuilder(AddFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AddFsuCollectionTargetsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddFsuCollectionTargetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelFsuActionResponse cancelFsuAction(CancelFsuActionRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return (CancelFsuActionResponse)this.clientCall(request, CancelFsuActionResponse::builder).logger(LOG, "cancelFsuAction").serviceDetails("FleetSoftwareUpdate", "CancelFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/CancelFsuAction").method(Method.POST).requestBuilder(CancelFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelFsuActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeFsuActionCompartmentResponse changeFsuActionCompartment(ChangeFsuActionCompartmentRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuActionCompartmentDetails(), "changeFsuActionCompartmentDetails is required");
        return (ChangeFsuActionCompartmentResponse)this.clientCall(request, ChangeFsuActionCompartmentResponse::builder).logger(LOG, "changeFsuActionCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuActionCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/ChangeFsuActionCompartment").method(Method.POST).requestBuilder(ChangeFsuActionCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuActionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuActionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeFsuCollectionCompartmentResponse changeFsuCollectionCompartment(ChangeFsuCollectionCompartmentRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuCollectionCompartmentDetails(), "changeFsuCollectionCompartmentDetails is required");
        return (ChangeFsuCollectionCompartmentResponse)this.clientCall(request, ChangeFsuCollectionCompartmentResponse::builder).logger(LOG, "changeFsuCollectionCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuCollectionCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/ChangeFsuCollectionCompartment").method(Method.POST).requestBuilder(ChangeFsuCollectionCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuCollectionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuCollectionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeFsuCycleCompartmentResponse changeFsuCycleCompartment(ChangeFsuCycleCompartmentRequest request) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuCycleCompartmentDetails(), "changeFsuCycleCompartmentDetails is required");
        return (ChangeFsuCycleCompartmentResponse)this.clientCall(request, ChangeFsuCycleCompartmentResponse::builder).logger(LOG, "changeFsuCycleCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuCycleCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/ChangeFsuCycleCompartment").method(Method.POST).requestBuilder(ChangeFsuCycleCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFsuCycleCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFsuCycleCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeFsuDiscoveryCompartmentResponse changeFsuDiscoveryCompartment(ChangeFsuDiscoveryCompartmentRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFsuDiscoveryCompartmentDetails(), "changeFsuDiscoveryCompartmentDetails is required");
        return (ChangeFsuDiscoveryCompartmentResponse)this.clientCall(request, ChangeFsuDiscoveryCompartmentResponse::builder).logger(LOG, "changeFsuDiscoveryCompartment").serviceDetails("FleetSoftwareUpdate", "ChangeFsuDiscoveryCompartment", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/ChangeFsuDiscoveryCompartment").method(Method.POST).requestBuilder(ChangeFsuDiscoveryCompartmentRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeFsuDiscoveryCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CloneFsuCycleResponse cloneFsuCycle(CloneFsuCycleRequest request) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneFsuCycleDetails(), "cloneFsuCycleDetails is required");
        return (CloneFsuCycleResponse)this.clientCall(request, CloneFsuCycleResponse::builder).logger(LOG, "cloneFsuCycle").serviceDetails("FleetSoftwareUpdate", "CloneFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/CloneFsuCycle").method(Method.POST).requestBuilder(CloneFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).appendPathParam("actions").appendPathParam("clone").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(FsuCycle.class, CloneFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("opc-work-request-id", CloneFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CloneFsuCycleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CloneFsuCycleResponse.Builder::etag).handleResponseHeaderString("Location", CloneFsuCycleResponse.Builder::location).callSync();
    }

    @Override
    public CreateFsuActionResponse createFsuAction(CreateFsuActionRequest request) {
        Objects.requireNonNull(request.getCreateFsuActionDetails(), "createFsuActionDetails is required");
        return (CreateFsuActionResponse)this.clientCall(request, CreateFsuActionResponse::builder).logger(LOG, "createFsuAction").serviceDetails("FleetSoftwareUpdate", "CreateFsuAction", "").method(Method.POST).requestBuilder(CreateFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(FsuAction.class, CreateFsuActionResponse.Builder::fsuAction).handleResponseHeaderString("opc-work-request-id", CreateFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuActionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuActionResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuActionResponse.Builder::location).callSync();
    }

    @Override
    public CreateFsuCollectionResponse createFsuCollection(CreateFsuCollectionRequest request) {
        Objects.requireNonNull(request.getCreateFsuCollectionDetails(), "createFsuCollectionDetails is required");
        return (CreateFsuCollectionResponse)this.clientCall(request, CreateFsuCollectionResponse::builder).logger(LOG, "createFsuCollection").serviceDetails("FleetSoftwareUpdate", "CreateFsuCollection", "").method(Method.POST).requestBuilder(CreateFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(FsuCollection.class, CreateFsuCollectionResponse.Builder::fsuCollection).handleResponseHeaderString("opc-work-request-id", CreateFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuCollectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuCollectionResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuCollectionResponse.Builder::location).callSync();
    }

    @Override
    public CreateFsuCycleResponse createFsuCycle(CreateFsuCycleRequest request) {
        Objects.requireNonNull(request.getCreateFsuCycleDetails(), "createFsuCycleDetails is required");
        return (CreateFsuCycleResponse)this.clientCall(request, CreateFsuCycleResponse::builder).logger(LOG, "createFsuCycle").serviceDetails("FleetSoftwareUpdate", "CreateFsuCycle", "").method(Method.POST).requestBuilder(CreateFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(FsuCycle.class, CreateFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("opc-work-request-id", CreateFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuCycleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuCycleResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuCycleResponse.Builder::location).callSync();
    }

    @Override
    public CreateFsuDiscoveryResponse createFsuDiscovery(CreateFsuDiscoveryRequest request) {
        Objects.requireNonNull(request.getCreateFsuDiscoveryDetails(), "createFsuDiscoveryDetails is required");
        return (CreateFsuDiscoveryResponse)this.clientCall(request, CreateFsuDiscoveryResponse::builder).logger(LOG, "createFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "CreateFsuDiscovery", "").method(Method.POST).requestBuilder(CreateFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(FsuDiscovery.class, CreateFsuDiscoveryResponse.Builder::fsuDiscovery).handleResponseHeaderString("opc-work-request-id", CreateFsuDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFsuDiscoveryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFsuDiscoveryResponse.Builder::etag).handleResponseHeaderString("Location", CreateFsuDiscoveryResponse.Builder::location).callSync();
    }

    @Override
    public DeleteFsuActionResponse deleteFsuAction(DeleteFsuActionRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return (DeleteFsuActionResponse)this.clientCall(request, DeleteFsuActionResponse::builder).logger(LOG, "deleteFsuAction").serviceDetails("FleetSoftwareUpdate", "DeleteFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/DeleteFsuAction").method(Method.DELETE).requestBuilder(DeleteFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFsuCollectionResponse deleteFsuCollection(DeleteFsuCollectionRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return (DeleteFsuCollectionResponse)this.clientCall(request, DeleteFsuCollectionResponse::builder).logger(LOG, "deleteFsuCollection").serviceDetails("FleetSoftwareUpdate", "DeleteFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/DeleteFsuCollection").method(Method.DELETE).requestBuilder(DeleteFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuCollectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFsuCycleResponse deleteFsuCycle(DeleteFsuCycleRequest request) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        return (DeleteFsuCycleResponse)this.clientCall(request, DeleteFsuCycleResponse::builder).logger(LOG, "deleteFsuCycle").serviceDetails("FleetSoftwareUpdate", "DeleteFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/DeleteFsuCycle").method(Method.DELETE).requestBuilder(DeleteFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuCycleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFsuDiscoveryResponse deleteFsuDiscovery(DeleteFsuDiscoveryRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return (DeleteFsuDiscoveryResponse)this.clientCall(request, DeleteFsuDiscoveryResponse::builder).logger(LOG, "deleteFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "DeleteFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/DeleteFsuDiscovery").method(Method.DELETE).requestBuilder(DeleteFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteFsuDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFsuDiscoveryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFsuJobResponse deleteFsuJob(DeleteFsuJobRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return (DeleteFsuJobResponse)this.clientCall(request, DeleteFsuJobResponse::builder).logger(LOG, "deleteFsuJob").serviceDetails("FleetSoftwareUpdate", "DeleteFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/DeleteFsuJob").method(Method.DELETE).requestBuilder(DeleteFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteFsuJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuActionResponse getFsuAction(GetFsuActionRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return (GetFsuActionResponse)this.clientCall(request, GetFsuActionResponse::builder).logger(LOG, "getFsuAction").serviceDetails("FleetSoftwareUpdate", "GetFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/GetFsuAction").method(Method.GET).requestBuilder(GetFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuAction.class, GetFsuActionResponse.Builder::fsuAction).handleResponseHeaderString("etag", GetFsuActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuActionOutputContentResponse getFsuActionOutputContent(GetFsuActionOutputContentRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return (GetFsuActionOutputContentResponse)this.clientCall(request, GetFsuActionOutputContentResponse::builder).logger(LOG, "getFsuActionOutputContent").serviceDetails("FleetSoftwareUpdate", "GetFsuActionOutputContent", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/GetFsuActionOutputContent").method(Method.GET).requestBuilder(GetFsuActionOutputContentRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetFsuActionOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetFsuActionOutputContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuCollectionResponse getFsuCollection(GetFsuCollectionRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return (GetFsuCollectionResponse)this.clientCall(request, GetFsuCollectionResponse::builder).logger(LOG, "getFsuCollection").serviceDetails("FleetSoftwareUpdate", "GetFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/GetFsuCollection").method(Method.GET).requestBuilder(GetFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuCollection.class, GetFsuCollectionResponse.Builder::fsuCollection).handleResponseHeaderString("etag", GetFsuCollectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuCollectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuCycleResponse getFsuCycle(GetFsuCycleRequest request) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        return (GetFsuCycleResponse)this.clientCall(request, GetFsuCycleResponse::builder).logger(LOG, "getFsuCycle").serviceDetails("FleetSoftwareUpdate", "GetFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/GetFsuCycle").method(Method.GET).requestBuilder(GetFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuCycle.class, GetFsuCycleResponse.Builder::fsuCycle).handleResponseHeaderString("etag", GetFsuCycleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuCycleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuDiscoveryResponse getFsuDiscovery(GetFsuDiscoveryRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return (GetFsuDiscoveryResponse)this.clientCall(request, GetFsuDiscoveryResponse::builder).logger(LOG, "getFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "GetFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/GetFsuDiscovery").method(Method.GET).requestBuilder(GetFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuDiscovery.class, GetFsuDiscoveryResponse.Builder::fsuDiscovery).handleResponseHeaderString("etag", GetFsuDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFsuDiscoveryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFsuJobResponse getFsuJob(GetFsuJobRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return (GetFsuJobResponse)this.clientCall(request, GetFsuJobResponse::builder).logger(LOG, "getFsuJob").serviceDetails("FleetSoftwareUpdate", "GetFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/GetFsuJob").method(Method.GET).requestBuilder(GetFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuJob.class, GetFsuJobResponse.Builder::fsuJob).handleResponseHeaderString("opc-request-id", GetFsuJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetFsuJobResponse.Builder::etag).callSync();
    }

    @Override
    public GetFsuJobOutputContentResponse getFsuJobOutputContent(GetFsuJobOutputContentRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return (GetFsuJobOutputContentResponse)this.clientCall(request, GetFsuJobOutputContentResponse::builder).logger(LOG, "getFsuJobOutputContent").serviceDetails("FleetSoftwareUpdate", "GetFsuJobOutputContent", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/GetFsuJobOutputContent").method(Method.GET).requestBuilder(GetFsuJobOutputContentRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetFsuJobOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetFsuJobOutputContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("FleetSoftwareUpdate", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListFsuActionsResponse listFsuActions(ListFsuActionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFsuActionsResponse)this.clientCall(request, ListFsuActionsResponse::builder).logger(LOG, "listFsuActions").serviceDetails("FleetSoftwareUpdate", "ListFsuActions", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuActionSummaryCollection/ListFsuActions").method(Method.GET).requestBuilder(ListFsuActionsRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fsuCycleId", (Object)request.getFsuCycleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuActionSummaryCollection.class, ListFsuActionsResponse.Builder::fsuActionSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuActionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuActionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuCollectionTargetsResponse listFsuCollectionTargets(ListFsuCollectionTargetsRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        return (ListFsuCollectionTargetsResponse)this.clientCall(request, ListFsuCollectionTargetsResponse::builder).logger(LOG, "listFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "ListFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/TargetSummaryCollection/ListFsuCollectionTargets").method(Method.GET).requestBuilder(ListFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("targetId", (Object)request.getTargetId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TargetSummaryCollection.class, ListFsuCollectionTargetsResponse.Builder::targetSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCollectionTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCollectionTargetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuCollectionsResponse listFsuCollections(ListFsuCollectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFsuCollectionsResponse)this.clientCall(request, ListFsuCollectionsResponse::builder).logger(LOG, "listFsuCollections").serviceDetails("FleetSoftwareUpdate", "ListFsuCollections", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollectionSummaryCollection/ListFsuCollections").method(Method.GET).requestBuilder(ListFsuCollectionsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuCollectionSummaryCollection.class, ListFsuCollectionsResponse.Builder::fsuCollectionSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCollectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCollectionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuCyclesResponse listFsuCycles(ListFsuCyclesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFsuCyclesResponse)this.clientCall(request, ListFsuCyclesResponse::builder).logger(LOG, "listFsuCycles").serviceDetails("FleetSoftwareUpdate", "ListFsuCycles", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycleSummary/ListFsuCycles").method(Method.GET).requestBuilder(ListFsuCyclesRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fsuCollectionId", (Object)request.getFsuCollectionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("collectionType", (BmcEnum)request.getCollectionType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuCycleSummaryCollection.class, ListFsuCyclesResponse.Builder::fsuCycleSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuCyclesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuCyclesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuDiscoveriesResponse listFsuDiscoveries(ListFsuDiscoveriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFsuDiscoveriesResponse)this.clientCall(request, ListFsuDiscoveriesResponse::builder).logger(LOG, "listFsuDiscoveries").serviceDetails("FleetSoftwareUpdate", "ListFsuDiscoveries", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscoverySummary/ListFsuDiscoveries").method(Method.GET).requestBuilder(ListFsuDiscoveriesRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuDiscoverySummaryCollection.class, ListFsuDiscoveriesResponse.Builder::fsuDiscoverySummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuDiscoveriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuDiscoveriesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuDiscoveryTargetsResponse listFsuDiscoveryTargets(ListFsuDiscoveryTargetsRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        return (ListFsuDiscoveryTargetsResponse)this.clientCall(request, ListFsuDiscoveryTargetsResponse::builder).logger(LOG, "listFsuDiscoveryTargets").serviceDetails("FleetSoftwareUpdate", "ListFsuDiscoveryTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/TargetSummaryCollection/ListFsuDiscoveryTargets").method(Method.GET).requestBuilder(ListFsuDiscoveryTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).appendPathParam("targets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("targetId", (Object)request.getTargetId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TargetSummaryCollection.class, ListFsuDiscoveryTargetsResponse.Builder::targetSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuDiscoveryTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuDiscoveryTargetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuJobOutputsResponse listFsuJobOutputs(ListFsuJobOutputsRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return (ListFsuJobOutputsResponse)this.clientCall(request, ListFsuJobOutputsResponse::builder).logger(LOG, "listFsuJobOutputs").serviceDetails("FleetSoftwareUpdate", "ListFsuJobOutputs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJobOutputSummary/ListFsuJobOutputs").method(Method.GET).requestBuilder(ListFsuJobOutputsRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("output").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuJobOutputSummaryCollection.class, ListFsuJobOutputsResponse.Builder::fsuJobOutputSummaryCollection).handleResponseHeaderString("opc-request-id", ListFsuJobOutputsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuJobOutputsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFsuJobsResponse listFsuJobs(ListFsuJobsRequest request) {
        Objects.requireNonNull(request.getFsuActionId(), "fsuActionId is required");
        return (ListFsuJobsResponse)this.clientCall(request, ListFsuJobsResponse::builder).logger(LOG, "listFsuJobs").serviceDetails("FleetSoftwareUpdate", "ListFsuJobs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJobSummary/ListFsuJobs").method(Method.GET).requestBuilder(ListFsuJobsRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendQueryParam("fsuActionId", (Object)request.getFsuActionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FsuJobCollection.class, ListFsuJobsResponse.Builder::fsuJobCollection).handleResponseHeaderString("opc-request-id", ListFsuJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFsuJobsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("FleetSoftwareUpdate", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("FleetSoftwareUpdate", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("FleetSoftwareUpdate", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220528").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveFsuCollectionTargetsResponse removeFsuCollectionTargets(RemoveFsuCollectionTargetsRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveFsuCollectionTargetsDetails(), "removeFsuCollectionTargetsDetails is required");
        return (RemoveFsuCollectionTargetsResponse)this.clientCall(request, RemoveFsuCollectionTargetsResponse::builder).logger(LOG, "removeFsuCollectionTargets").serviceDetails("FleetSoftwareUpdate", "RemoveFsuCollectionTargets", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/RemoveFsuCollectionTargets").method(Method.PUT).requestBuilder(RemoveFsuCollectionTargetsRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).appendPathParam("targets").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RemoveFsuCollectionTargetsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveFsuCollectionTargetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResumeFsuActionResponse resumeFsuAction(ResumeFsuActionRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        return (ResumeFsuActionResponse)this.clientCall(request, ResumeFsuActionResponse::builder).logger(LOG, "resumeFsuAction").serviceDetails("FleetSoftwareUpdate", "ResumeFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/ResumeFsuAction").method(Method.POST).requestBuilder(ResumeFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", ResumeFsuActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RetryFsuJobResponse retryFsuJob(RetryFsuJobRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        return (RetryFsuJobResponse)this.clientCall(request, RetryFsuJobResponse::builder).logger(LOG, "retryFsuJob").serviceDetails("FleetSoftwareUpdate", "RetryFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/RetryFsuJob").method(Method.POST).requestBuilder(RetryFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).appendPathParam("actions").appendPathParam("retry").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", RetryFsuJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFsuActionResponse updateFsuAction(UpdateFsuActionRequest request) {
        Validate.notBlank((String)request.getFsuActionId(), (String)"fsuActionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuActionDetails(), "updateFsuActionDetails is required");
        return (UpdateFsuActionResponse)this.clientCall(request, UpdateFsuActionResponse::builder).logger(LOG, "updateFsuAction").serviceDetails("FleetSoftwareUpdate", "UpdateFsuAction", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuAction/UpdateFsuAction").method(Method.PUT).requestBuilder(UpdateFsuActionRequest::builder).basePath("/20220528").appendPathParam("fsuActions").appendPathParam(request.getFsuActionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuActionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFsuCollectionResponse updateFsuCollection(UpdateFsuCollectionRequest request) {
        Validate.notBlank((String)request.getFsuCollectionId(), (String)"fsuCollectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuCollectionDetails(), "updateFsuCollectionDetails is required");
        return (UpdateFsuCollectionResponse)this.clientCall(request, UpdateFsuCollectionResponse::builder).logger(LOG, "updateFsuCollection").serviceDetails("FleetSoftwareUpdate", "UpdateFsuCollection", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCollection/UpdateFsuCollection").method(Method.PUT).requestBuilder(UpdateFsuCollectionRequest::builder).basePath("/20220528").appendPathParam("fsuCollections").appendPathParam(request.getFsuCollectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuCollectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuCollectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFsuCycleResponse updateFsuCycle(UpdateFsuCycleRequest request) {
        Validate.notBlank((String)request.getFsuCycleId(), (String)"fsuCycleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuCycleDetails(), "updateFsuCycleDetails is required");
        return (UpdateFsuCycleResponse)this.clientCall(request, UpdateFsuCycleResponse::builder).logger(LOG, "updateFsuCycle").serviceDetails("FleetSoftwareUpdate", "UpdateFsuCycle", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuCycle/UpdateFsuCycle").method(Method.PUT).requestBuilder(UpdateFsuCycleRequest::builder).basePath("/20220528").appendPathParam("fsuCycles").appendPathParam(request.getFsuCycleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFsuCycleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFsuCycleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFsuDiscoveryResponse updateFsuDiscovery(UpdateFsuDiscoveryRequest request) {
        Validate.notBlank((String)request.getFsuDiscoveryId(), (String)"fsuDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuDiscoveryDetails(), "updateFsuDiscoveryDetails is required");
        return (UpdateFsuDiscoveryResponse)this.clientCall(request, UpdateFsuDiscoveryResponse::builder).logger(LOG, "updateFsuDiscovery").serviceDetails("FleetSoftwareUpdate", "UpdateFsuDiscovery", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuDiscovery/UpdateFsuDiscovery").method(Method.PUT).requestBuilder(UpdateFsuDiscoveryRequest::builder).basePath("/20220528").appendPathParam("fsuDiscoveries").appendPathParam(request.getFsuDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateFsuDiscoveryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFsuJobResponse updateFsuJob(UpdateFsuJobRequest request) {
        Validate.notBlank((String)request.getFsuJobId(), (String)"fsuJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFsuJobDetails(), "updateFsuJobDetails is required");
        return (UpdateFsuJobResponse)this.clientCall(request, UpdateFsuJobResponse::builder).logger(LOG, "updateFsuJob").serviceDetails("FleetSoftwareUpdate", "UpdateFsuJob", "https://docs.oracle.com/iaas/api/#/en/edsfu/20220528/FsuJob/UpdateFsuJob").method(Method.PUT).requestBuilder(UpdateFsuJobRequest::builder).basePath("/20220528").appendPathParam("fsuJobs").appendPathParam(request.getFsuJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(FsuJob.class, UpdateFsuJobResponse.Builder::fsuJob).handleResponseHeaderString("opc-request-id", UpdateFsuJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateFsuJobResponse.Builder::etag).callSync();
    }

    @Override
    public FleetSoftwareUpdateWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FleetSoftwareUpdatePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public FleetSoftwareUpdateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetSoftwareUpdateClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetSoftwareUpdateClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetSoftwareUpdateClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetSoftwareUpdateClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetSoftwareUpdateClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "fleetsoftwareupdate";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetsoftwareupdate");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public FleetSoftwareUpdateClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetSoftwareUpdateClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

