/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate;

import com.oracle.bmc.fleetsoftwareupdate.FleetSoftwareUpdate;
import com.oracle.bmc.fleetsoftwareupdate.model.ActionLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.model.CollectionLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.model.CycleLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.model.DiscoveryLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.model.JobLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuActionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCollectionRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuCycleRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuDiscoveryRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetFsuJobRequest;
import com.oracle.bmc.fleetsoftwareupdate.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuActionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCollectionResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuCycleResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuDiscoveryResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetFsuJobResponse;
import com.oracle.bmc.fleetsoftwareupdate.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetSoftwareUpdateWaiters {
    private final ExecutorService executorService;
    private final FleetSoftwareUpdate client;

    public FleetSoftwareUpdateWaiters(ExecutorService executorService, FleetSoftwareUpdate client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetFsuActionRequest, GetFsuActionResponse> forFsuAction(GetFsuActionRequest request, ActionLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuAction(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFsuActionRequest, GetFsuActionResponse> forFsuAction(GetFsuActionRequest request, ActionLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFsuAction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFsuActionRequest, GetFsuActionResponse> forFsuAction(GetFsuActionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ActionLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuAction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFsuActionRequest, GetFsuActionResponse> forFsuAction(BmcGenericWaiter waiter, GetFsuActionRequest request, ActionLifecycleStates ... targetStates) {
        final HashSet<ActionLifecycleStates> targetStatesSet = new HashSet<ActionLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFsuActionRequest, GetFsuActionResponse>(){

            @Override
            public GetFsuActionResponse apply(GetFsuActionRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getFsuAction(request);
            }
        }, (Predicate)new Predicate<GetFsuActionResponse>(){

            @Override
            public boolean test(GetFsuActionResponse response) {
                return targetStatesSet.contains((Object)response.getFsuAction().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ActionLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetFsuCollectionRequest, GetFsuCollectionResponse> forFsuCollection(GetFsuCollectionRequest request, CollectionLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuCollection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFsuCollectionRequest, GetFsuCollectionResponse> forFsuCollection(GetFsuCollectionRequest request, CollectionLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFsuCollection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFsuCollectionRequest, GetFsuCollectionResponse> forFsuCollection(GetFsuCollectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CollectionLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuCollection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFsuCollectionRequest, GetFsuCollectionResponse> forFsuCollection(BmcGenericWaiter waiter, GetFsuCollectionRequest request, CollectionLifecycleStates ... targetStates) {
        final HashSet<CollectionLifecycleStates> targetStatesSet = new HashSet<CollectionLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFsuCollectionRequest, GetFsuCollectionResponse>(){

            @Override
            public GetFsuCollectionResponse apply(GetFsuCollectionRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getFsuCollection(request);
            }
        }, (Predicate)new Predicate<GetFsuCollectionResponse>(){

            @Override
            public boolean test(GetFsuCollectionResponse response) {
                return targetStatesSet.contains((Object)response.getFsuCollection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CollectionLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetFsuCycleRequest, GetFsuCycleResponse> forFsuCycle(GetFsuCycleRequest request, CycleLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuCycle(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFsuCycleRequest, GetFsuCycleResponse> forFsuCycle(GetFsuCycleRequest request, CycleLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFsuCycle(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFsuCycleRequest, GetFsuCycleResponse> forFsuCycle(GetFsuCycleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CycleLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuCycle(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFsuCycleRequest, GetFsuCycleResponse> forFsuCycle(BmcGenericWaiter waiter, GetFsuCycleRequest request, CycleLifecycleStates ... targetStates) {
        final HashSet<CycleLifecycleStates> targetStatesSet = new HashSet<CycleLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFsuCycleRequest, GetFsuCycleResponse>(){

            @Override
            public GetFsuCycleResponse apply(GetFsuCycleRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getFsuCycle(request);
            }
        }, (Predicate)new Predicate<GetFsuCycleResponse>(){

            @Override
            public boolean test(GetFsuCycleResponse response) {
                return targetStatesSet.contains((Object)response.getFsuCycle().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CycleLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse> forFsuDiscovery(GetFsuDiscoveryRequest request, DiscoveryLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuDiscovery(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse> forFsuDiscovery(GetFsuDiscoveryRequest request, DiscoveryLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFsuDiscovery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse> forFsuDiscovery(GetFsuDiscoveryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DiscoveryLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuDiscovery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse> forFsuDiscovery(BmcGenericWaiter waiter, GetFsuDiscoveryRequest request, DiscoveryLifecycleStates ... targetStates) {
        final HashSet<DiscoveryLifecycleStates> targetStatesSet = new HashSet<DiscoveryLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFsuDiscoveryRequest, GetFsuDiscoveryResponse>(){

            @Override
            public GetFsuDiscoveryResponse apply(GetFsuDiscoveryRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getFsuDiscovery(request);
            }
        }, (Predicate)new Predicate<GetFsuDiscoveryResponse>(){

            @Override
            public boolean test(GetFsuDiscoveryResponse response) {
                return targetStatesSet.contains((Object)response.getFsuDiscovery().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DiscoveryLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetFsuJobRequest, GetFsuJobResponse> forFsuJob(GetFsuJobRequest request, JobLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFsuJobRequest, GetFsuJobResponse> forFsuJob(GetFsuJobRequest request, JobLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFsuJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFsuJobRequest, GetFsuJobResponse> forFsuJob(GetFsuJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFsuJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFsuJobRequest, GetFsuJobResponse> forFsuJob(BmcGenericWaiter waiter, GetFsuJobRequest request, JobLifecycleStates ... targetStates) {
        final HashSet<JobLifecycleStates> targetStatesSet = new HashSet<JobLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFsuJobRequest, GetFsuJobResponse>(){

            @Override
            public GetFsuJobResponse apply(GetFsuJobRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getFsuJob(request);
            }
        }, (Predicate)new Predicate<GetFsuJobResponse>(){

            @Override
            public boolean test(GetFsuJobResponse response) {
                return targetStatesSet.contains((Object)response.getFsuJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)JobLifecycleStates.Terminated)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return FleetSoftwareUpdateWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

