/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.FsuJob;
import com.oracle.bmc.fleetsoftwareupdate.model.JobLifecycleStates;
import com.oracle.bmc.fleetsoftwareupdate.model.JobProgressDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.ScheduleDetails;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ApplyFsuJob
extends FsuJob {
    @JsonProperty(value="fsuCollectionId")
    private final String fsuCollectionId;
    @JsonProperty(value="fsuCycleId")
    private final String fsuCycleId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="schedule")
    private final ScheduleDetails schedule;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ApplyFsuJob(String id, String displayName, String compartmentId, String fsuActionId, JobProgressDetails progress, Date timeCreated, Date timeStarted, Date timeUpdated, Date timeFinished, JobLifecycleStates lifecycleState, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String fsuCollectionId, String fsuCycleId, String targetId, ScheduleDetails schedule) {
        super(id, displayName, compartmentId, fsuActionId, progress, timeCreated, timeStarted, timeUpdated, timeFinished, lifecycleState, lifecycleDetails, freeformTags, definedTags, systemTags);
        this.fsuCollectionId = fsuCollectionId;
        this.fsuCycleId = fsuCycleId;
        this.targetId = targetId;
        this.schedule = schedule;
    }

    public String getFsuCollectionId() {
        return this.fsuCollectionId;
    }

    public String getFsuCycleId() {
        return this.fsuCycleId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public ScheduleDetails getSchedule() {
        return this.schedule;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplyFsuJob(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fsuCollectionId=").append(String.valueOf(this.fsuCollectionId));
        sb.append(", fsuCycleId=").append(String.valueOf(this.fsuCycleId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", schedule=").append(String.valueOf((Object)this.schedule));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplyFsuJob)) {
            return false;
        }
        ApplyFsuJob other = (ApplyFsuJob)((Object)o);
        return Objects.equals(this.fsuCollectionId, other.fsuCollectionId) && Objects.equals(this.fsuCycleId, other.fsuCycleId) && Objects.equals(this.targetId, other.targetId) && Objects.equals((Object)this.schedule, (Object)other.schedule) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fsuCollectionId == null ? 43 : this.fsuCollectionId.hashCode());
        result = result * 59 + (this.fsuCycleId == null ? 43 : this.fsuCycleId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.schedule == null ? 43 : this.schedule.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="fsuActionId")
        private String fsuActionId;
        @JsonProperty(value="progress")
        private JobProgressDetails progress;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="lifecycleState")
        private JobLifecycleStates lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="fsuCollectionId")
        private String fsuCollectionId;
        @JsonProperty(value="fsuCycleId")
        private String fsuCycleId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="schedule")
        private ScheduleDetails schedule;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder fsuActionId(String fsuActionId) {
            this.fsuActionId = fsuActionId;
            this.__explicitlySet__.add("fsuActionId");
            return this;
        }

        public Builder progress(JobProgressDetails progress) {
            this.progress = progress;
            this.__explicitlySet__.add("progress");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder lifecycleState(JobLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder fsuCollectionId(String fsuCollectionId) {
            this.fsuCollectionId = fsuCollectionId;
            this.__explicitlySet__.add("fsuCollectionId");
            return this;
        }

        public Builder fsuCycleId(String fsuCycleId) {
            this.fsuCycleId = fsuCycleId;
            this.__explicitlySet__.add("fsuCycleId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder schedule(ScheduleDetails schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }

        public ApplyFsuJob build() {
            ApplyFsuJob model = new ApplyFsuJob(this.id, this.displayName, this.compartmentId, this.fsuActionId, this.progress, this.timeCreated, this.timeStarted, this.timeUpdated, this.timeFinished, this.lifecycleState, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags, this.fsuCollectionId, this.fsuCycleId, this.targetId, this.schedule);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplyFsuJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("fsuActionId")) {
                this.fsuActionId(model.getFsuActionId());
            }
            if (model.wasPropertyExplicitlySet("progress")) {
                this.progress(model.getProgress());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("fsuCollectionId")) {
                this.fsuCollectionId(model.getFsuCollectionId());
            }
            if (model.wasPropertyExplicitlySet("fsuCycleId")) {
                this.fsuCycleId(model.getFsuCycleId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            return this;
        }
    }
}

