/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.CollectionServiceTypes;
import com.oracle.bmc.fleetsoftwareupdate.model.CreateFsuCollectionDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.DbFleetDiscoveryDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.DbSourceMajorVersions;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDbFsuCollectionDetails
extends CreateFsuCollectionDetails {
    @JsonProperty(value="sourceMajorVersion")
    private final DbSourceMajorVersions sourceMajorVersion;
    @JsonProperty(value="fleetDiscovery")
    private final DbFleetDiscoveryDetails fleetDiscovery;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDbFsuCollectionDetails(String displayName, CollectionServiceTypes serviceType, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, DbSourceMajorVersions sourceMajorVersion, DbFleetDiscoveryDetails fleetDiscovery) {
        super(displayName, serviceType, compartmentId, freeformTags, definedTags);
        this.sourceMajorVersion = sourceMajorVersion;
        this.fleetDiscovery = fleetDiscovery;
    }

    public DbSourceMajorVersions getSourceMajorVersion() {
        return this.sourceMajorVersion;
    }

    public DbFleetDiscoveryDetails getFleetDiscovery() {
        return this.fleetDiscovery;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDbFsuCollectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sourceMajorVersion=").append(String.valueOf((Object)this.sourceMajorVersion));
        sb.append(", fleetDiscovery=").append(String.valueOf((Object)this.fleetDiscovery));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDbFsuCollectionDetails)) {
            return false;
        }
        CreateDbFsuCollectionDetails other = (CreateDbFsuCollectionDetails)((Object)o);
        return Objects.equals((Object)this.sourceMajorVersion, (Object)other.sourceMajorVersion) && Objects.equals((Object)this.fleetDiscovery, (Object)other.fleetDiscovery) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sourceMajorVersion == null ? 43 : this.sourceMajorVersion.hashCode());
        result = result * 59 + (this.fleetDiscovery == null ? 43 : this.fleetDiscovery.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="serviceType")
        private CollectionServiceTypes serviceType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="sourceMajorVersion")
        private DbSourceMajorVersions sourceMajorVersion;
        @JsonProperty(value="fleetDiscovery")
        private DbFleetDiscoveryDetails fleetDiscovery;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder serviceType(CollectionServiceTypes serviceType) {
            this.serviceType = serviceType;
            this.__explicitlySet__.add("serviceType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder sourceMajorVersion(DbSourceMajorVersions sourceMajorVersion) {
            this.sourceMajorVersion = sourceMajorVersion;
            this.__explicitlySet__.add("sourceMajorVersion");
            return this;
        }

        public Builder fleetDiscovery(DbFleetDiscoveryDetails fleetDiscovery) {
            this.fleetDiscovery = fleetDiscovery;
            this.__explicitlySet__.add("fleetDiscovery");
            return this;
        }

        public CreateDbFsuCollectionDetails build() {
            CreateDbFsuCollectionDetails model = new CreateDbFsuCollectionDetails(this.displayName, this.serviceType, this.compartmentId, this.freeformTags, this.definedTags, this.sourceMajorVersion, this.fleetDiscovery);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDbFsuCollectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("serviceType")) {
                this.serviceType(model.getServiceType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("sourceMajorVersion")) {
                this.sourceMajorVersion(model.getSourceMajorVersion());
            }
            if (model.wasPropertyExplicitlySet("fleetDiscovery")) {
                this.fleetDiscovery(model.getFleetDiscovery());
            }
            return this;
        }
    }
}

