/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.TargetDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseTargetSummary
extends TargetDetails {
    @JsonProperty(value="dbHomeId")
    private final String dbHomeId;
    @JsonProperty(value="vmClusterId")
    private final String vmClusterId;
    @JsonProperty(value="infrastructureId")
    private final String infrastructureId;
    @JsonProperty(value="softwareImageId")
    private final String softwareImageId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseTargetSummary(String id, String compartmentId, String dbHomeId, String vmClusterId, String infrastructureId, String softwareImageId) {
        super(id, compartmentId);
        this.dbHomeId = dbHomeId;
        this.vmClusterId = vmClusterId;
        this.infrastructureId = infrastructureId;
        this.softwareImageId = softwareImageId;
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getInfrastructureId() {
        return this.infrastructureId;
    }

    public String getSoftwareImageId() {
        return this.softwareImageId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseTargetSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(", vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(", infrastructureId=").append(String.valueOf(this.infrastructureId));
        sb.append(", softwareImageId=").append(String.valueOf(this.softwareImageId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseTargetSummary)) {
            return false;
        }
        DatabaseTargetSummary other = (DatabaseTargetSummary)((Object)o);
        return Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.infrastructureId, other.infrastructureId) && Objects.equals(this.softwareImageId, other.softwareImageId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.infrastructureId == null ? 43 : this.infrastructureId.hashCode());
        result = result * 59 + (this.softwareImageId == null ? 43 : this.softwareImageId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbHomeId")
        private String dbHomeId;
        @JsonProperty(value="vmClusterId")
        private String vmClusterId;
        @JsonProperty(value="infrastructureId")
        private String infrastructureId;
        @JsonProperty(value="softwareImageId")
        private String softwareImageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            this.__explicitlySet__.add("dbHomeId");
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            this.__explicitlySet__.add("vmClusterId");
            return this;
        }

        public Builder infrastructureId(String infrastructureId) {
            this.infrastructureId = infrastructureId;
            this.__explicitlySet__.add("infrastructureId");
            return this;
        }

        public Builder softwareImageId(String softwareImageId) {
            this.softwareImageId = softwareImageId;
            this.__explicitlySet__.add("softwareImageId");
            return this;
        }

        public DatabaseTargetSummary build() {
            DatabaseTargetSummary model = new DatabaseTargetSummary(this.id, this.compartmentId, this.dbHomeId, this.vmClusterId, this.infrastructureId, this.softwareImageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseTargetSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbHomeId")) {
                this.dbHomeId(model.getDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("vmClusterId")) {
                this.vmClusterId(model.getVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("infrastructureId")) {
                this.infrastructureId(model.getInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("softwareImageId")) {
                this.softwareImageId(model.getSoftwareImageId());
            }
            return this;
        }
    }
}

