/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.DbFleetDiscoveryFilter;
import com.oracle.bmc.fleetsoftwareupdate.model.FleetDiscoveryOperators;
import com.oracle.bmc.fleetsoftwareupdate.model.FreeformTagFilterEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DbFreeformTagsFilter
extends DbFleetDiscoveryFilter {
    @JsonProperty(value="tags")
    private final List<FreeformTagFilterEntry> tags;
    @JsonProperty(value="operator")
    private final FleetDiscoveryOperators operator;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DbFreeformTagsFilter(DbFleetDiscoveryFilter.Mode mode, List<FreeformTagFilterEntry> tags, FleetDiscoveryOperators operator) {
        super(mode);
        this.tags = tags;
        this.operator = operator;
    }

    public List<FreeformTagFilterEntry> getTags() {
        return this.tags;
    }

    public FleetDiscoveryOperators getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbFreeformTagsFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbFreeformTagsFilter)) {
            return false;
        }
        DbFreeformTagsFilter other = (DbFreeformTagsFilter)((Object)o);
        return Objects.equals(this.tags, other.tags) && Objects.equals((Object)this.operator, (Object)other.operator) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mode")
        private DbFleetDiscoveryFilter.Mode mode;
        @JsonProperty(value="tags")
        private List<FreeformTagFilterEntry> tags;
        @JsonProperty(value="operator")
        private FleetDiscoveryOperators operator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mode(DbFleetDiscoveryFilter.Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder tags(List<FreeformTagFilterEntry> tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder operator(FleetDiscoveryOperators operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public DbFreeformTagsFilter build() {
            DbFreeformTagsFilter model = new DbFreeformTagsFilter(this.mode, this.tags, this.operator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbFreeformTagsFilter model) {
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            return this;
        }
    }
}

