/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.DbFleetDiscoveryFilter;
import com.oracle.bmc.fleetsoftwareupdate.model.FleetDiscoveryOperators;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DbResourceIdFilter
extends DbFleetDiscoveryFilter {
    @JsonProperty(value="entityType")
    private final EntityType entityType;
    @JsonProperty(value="identifiers")
    private final List<String> identifiers;
    @JsonProperty(value="operator")
    private final FleetDiscoveryOperators operator;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DbResourceIdFilter(DbFleetDiscoveryFilter.Mode mode, EntityType entityType, List<String> identifiers, FleetDiscoveryOperators operator) {
        super(mode);
        this.entityType = entityType;
        this.identifiers = identifiers;
        this.operator = operator;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public FleetDiscoveryOperators getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbResourceIdFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", entityType=").append(String.valueOf((Object)this.entityType));
        sb.append(", identifiers=").append(String.valueOf(this.identifiers));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbResourceIdFilter)) {
            return false;
        }
        DbResourceIdFilter other = (DbResourceIdFilter)((Object)o);
        return Objects.equals((Object)this.entityType, (Object)other.entityType) && Objects.equals(this.identifiers, other.identifiers) && Objects.equals((Object)this.operator, (Object)other.operator) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.identifiers == null ? 43 : this.identifiers.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        return result;
    }

    public static enum EntityType implements BmcEnum
    {
        Databasesoftwareimage("DATABASESOFTWAREIMAGE"),
        Dbhome("DBHOME"),
        Exadatainfrastructure("EXADATAINFRASTRUCTURE"),
        Cloudexadatainfrastructure("CLOUDEXADATAINFRASTRUCTURE"),
        Vmcluster("VMCLUSTER"),
        Cloudvmcluster("CLOUDVMCLUSTER"),
        Fsucollection("FSUCOLLECTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EntityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EntityType.class);
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mode")
        private DbFleetDiscoveryFilter.Mode mode;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonProperty(value="identifiers")
        private List<String> identifiers;
        @JsonProperty(value="operator")
        private FleetDiscoveryOperators operator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mode(DbFleetDiscoveryFilter.Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder identifiers(List<String> identifiers) {
            this.identifiers = identifiers;
            this.__explicitlySet__.add("identifiers");
            return this;
        }

        public Builder operator(FleetDiscoveryOperators operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public DbResourceIdFilter build() {
            DbResourceIdFilter model = new DbResourceIdFilter(this.mode, this.entityType, this.identifiers, this.operator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbResourceIdFilter model) {
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("identifiers")) {
                this.identifiers(model.getIdentifiers());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            return this;
        }
    }
}

