/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.DiscoveryDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.DiscoveryServiceTypes;
import com.oracle.bmc.fleetsoftwareupdate.model.GiFleetDiscoveryDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.GiSourceMajorVersions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class GiDiscoveryDetails
extends DiscoveryDetails {
    @JsonProperty(value="sourceMajorVersion")
    private final GiSourceMajorVersions sourceMajorVersion;
    @JsonProperty(value="criteria")
    private final GiFleetDiscoveryDetails criteria;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GiDiscoveryDetails(DiscoveryServiceTypes serviceType, GiSourceMajorVersions sourceMajorVersion, GiFleetDiscoveryDetails criteria) {
        super(serviceType);
        this.sourceMajorVersion = sourceMajorVersion;
        this.criteria = criteria;
    }

    public GiSourceMajorVersions getSourceMajorVersion() {
        return this.sourceMajorVersion;
    }

    public GiFleetDiscoveryDetails getCriteria() {
        return this.criteria;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GiDiscoveryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sourceMajorVersion=").append(String.valueOf((Object)this.sourceMajorVersion));
        sb.append(", criteria=").append(String.valueOf((Object)this.criteria));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GiDiscoveryDetails)) {
            return false;
        }
        GiDiscoveryDetails other = (GiDiscoveryDetails)((Object)o);
        return Objects.equals((Object)this.sourceMajorVersion, (Object)other.sourceMajorVersion) && Objects.equals((Object)this.criteria, (Object)other.criteria) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sourceMajorVersion == null ? 43 : this.sourceMajorVersion.hashCode());
        result = result * 59 + (this.criteria == null ? 43 : this.criteria.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serviceType")
        private DiscoveryServiceTypes serviceType;
        @JsonProperty(value="sourceMajorVersion")
        private GiSourceMajorVersions sourceMajorVersion;
        @JsonProperty(value="criteria")
        private GiFleetDiscoveryDetails criteria;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serviceType(DiscoveryServiceTypes serviceType) {
            this.serviceType = serviceType;
            this.__explicitlySet__.add("serviceType");
            return this;
        }

        public Builder sourceMajorVersion(GiSourceMajorVersions sourceMajorVersion) {
            this.sourceMajorVersion = sourceMajorVersion;
            this.__explicitlySet__.add("sourceMajorVersion");
            return this;
        }

        public Builder criteria(GiFleetDiscoveryDetails criteria) {
            this.criteria = criteria;
            this.__explicitlySet__.add("criteria");
            return this;
        }

        public GiDiscoveryDetails build() {
            GiDiscoveryDetails model = new GiDiscoveryDetails(this.serviceType, this.sourceMajorVersion, this.criteria);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GiDiscoveryDetails model) {
            if (model.wasPropertyExplicitlySet("serviceType")) {
                this.serviceType(model.getServiceType());
            }
            if (model.wasPropertyExplicitlySet("sourceMajorVersion")) {
                this.sourceMajorVersion(model.getSourceMajorVersion());
            }
            if (model.wasPropertyExplicitlySet("criteria")) {
                this.criteria(model.getCriteria());
            }
            return this;
        }
    }
}

