/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TargetProgressSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="progressOfOperation")
    private final Integer progressOfOperation;

    @Deprecated
    @ConstructorProperties(value={"operationType", "progressOfOperation"})
    public TargetProgressSummary(OperationType operationType, Integer progressOfOperation) {
        this.operationType = operationType;
        this.progressOfOperation = progressOfOperation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Integer getProgressOfOperation() {
        return this.progressOfOperation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetProgressSummary(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", progressOfOperation=").append(String.valueOf(this.progressOfOperation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetProgressSummary)) {
            return false;
        }
        TargetProgressSummary other = (TargetProgressSummary)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.progressOfOperation, other.progressOfOperation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.progressOfOperation == null ? 43 : this.progressOfOperation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationType implements BmcEnum
    {
        Stage("STAGE"),
        Precheck("PRECHECK"),
        Apply("APPLY"),
        Rollback("ROLLBACK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="progressOfOperation")
        private Integer progressOfOperation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder progressOfOperation(Integer progressOfOperation) {
            this.progressOfOperation = progressOfOperation;
            this.__explicitlySet__.add("progressOfOperation");
            return this;
        }

        public TargetProgressSummary build() {
            TargetProgressSummary model = new TargetProgressSummary(this.operationType, this.progressOfOperation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TargetProgressSummary model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("progressOfOperation")) {
                this.progressOfOperation(model.getProgressOfOperation());
            }
            return this;
        }
    }
}

