/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetsoftwareupdate.model.TargetDetails;
import com.oracle.bmc.fleetsoftwareupdate.model.TargetProgressSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TargetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="target")
    private final TargetDetails target;
    @JsonProperty(value="currentVersion")
    private final String currentVersion;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="executingFsuJobId")
    private final String executingFsuJobId;
    @JsonProperty(value="activeFsuCycleId")
    private final String activeFsuCycleId;
    @JsonProperty(value="progress")
    private final TargetProgressSummary progress;

    @Deprecated
    @ConstructorProperties(value={"target", "currentVersion", "status", "executingFsuJobId", "activeFsuCycleId", "progress"})
    public TargetSummary(TargetDetails target, String currentVersion, Status status, String executingFsuJobId, String activeFsuCycleId, TargetProgressSummary progress) {
        this.target = target;
        this.currentVersion = currentVersion;
        this.status = status;
        this.executingFsuJobId = executingFsuJobId;
        this.activeFsuCycleId = activeFsuCycleId;
        this.progress = progress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TargetDetails getTarget() {
        return this.target;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getExecutingFsuJobId() {
        return this.executingFsuJobId;
    }

    public String getActiveFsuCycleId() {
        return this.activeFsuCycleId;
    }

    public TargetProgressSummary getProgress() {
        return this.progress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("target=").append(String.valueOf((Object)this.target));
        sb.append(", currentVersion=").append(String.valueOf(this.currentVersion));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", executingFsuJobId=").append(String.valueOf(this.executingFsuJobId));
        sb.append(", activeFsuCycleId=").append(String.valueOf(this.activeFsuCycleId));
        sb.append(", progress=").append(String.valueOf((Object)this.progress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetSummary)) {
            return false;
        }
        TargetSummary other = (TargetSummary)((Object)o);
        return Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.currentVersion, other.currentVersion) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.executingFsuJobId, other.executingFsuJobId) && Objects.equals(this.activeFsuCycleId, other.activeFsuCycleId) && Objects.equals((Object)this.progress, (Object)other.progress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.currentVersion == null ? 43 : this.currentVersion.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.executingFsuJobId == null ? 43 : this.executingFsuJobId.hashCode());
        result = result * 59 + (this.activeFsuCycleId == null ? 43 : this.activeFsuCycleId.hashCode());
        result = result * 59 + (this.progress == null ? 43 : this.progress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Idle("IDLE"),
        ExecutingJob("EXECUTING_JOB"),
        JobFailed("JOB_FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="target")
        private TargetDetails target;
        @JsonProperty(value="currentVersion")
        private String currentVersion;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="executingFsuJobId")
        private String executingFsuJobId;
        @JsonProperty(value="activeFsuCycleId")
        private String activeFsuCycleId;
        @JsonProperty(value="progress")
        private TargetProgressSummary progress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder target(TargetDetails target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            this.__explicitlySet__.add("currentVersion");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder executingFsuJobId(String executingFsuJobId) {
            this.executingFsuJobId = executingFsuJobId;
            this.__explicitlySet__.add("executingFsuJobId");
            return this;
        }

        public Builder activeFsuCycleId(String activeFsuCycleId) {
            this.activeFsuCycleId = activeFsuCycleId;
            this.__explicitlySet__.add("activeFsuCycleId");
            return this;
        }

        public Builder progress(TargetProgressSummary progress) {
            this.progress = progress;
            this.__explicitlySet__.add("progress");
            return this;
        }

        public TargetSummary build() {
            TargetSummary model = new TargetSummary(this.target, this.currentVersion, this.status, this.executingFsuJobId, this.activeFsuCycleId, this.progress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TargetSummary model) {
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("currentVersion")) {
                this.currentVersion(model.getCurrentVersion());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("executingFsuJobId")) {
                this.executingFsuJobId(model.getExecutingFsuJobId());
            }
            if (model.wasPropertyExplicitlySet("activeFsuCycleId")) {
                this.activeFsuCycleId(model.getActiveFsuCycleId());
            }
            if (model.wasPropertyExplicitlySet("progress")) {
                this.progress(model.getProgress());
            }
            return this;
        }
    }
}

