/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.fleetsoftwareupdate.model.CloneFsuCycleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CloneFsuCycleRequest
extends BmcRequest<CloneFsuCycleDetails> {
    private String fsuCycleId;
    private CloneFsuCycleDetails cloneFsuCycleDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getFsuCycleId() {
        return this.fsuCycleId;
    }

    public CloneFsuCycleDetails getCloneFsuCycleDetails() {
        return this.cloneFsuCycleDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CloneFsuCycleDetails getBody$() {
        return this.cloneFsuCycleDetails;
    }

    public Builder toBuilder() {
        return new Builder().fsuCycleId(this.fsuCycleId).cloneFsuCycleDetails(this.cloneFsuCycleDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fsuCycleId=").append(String.valueOf(this.fsuCycleId));
        sb.append(",cloneFsuCycleDetails=").append(String.valueOf((Object)this.cloneFsuCycleDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloneFsuCycleRequest)) {
            return false;
        }
        CloneFsuCycleRequest other = (CloneFsuCycleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fsuCycleId, other.fsuCycleId) && Objects.equals((Object)this.cloneFsuCycleDetails, (Object)other.cloneFsuCycleDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fsuCycleId == null ? 43 : this.fsuCycleId.hashCode());
        result = result * 59 + (this.cloneFsuCycleDetails == null ? 43 : this.cloneFsuCycleDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CloneFsuCycleRequest, CloneFsuCycleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fsuCycleId = null;
        private CloneFsuCycleDetails cloneFsuCycleDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder fsuCycleId(String fsuCycleId) {
            this.fsuCycleId = fsuCycleId;
            return this;
        }

        public Builder cloneFsuCycleDetails(CloneFsuCycleDetails cloneFsuCycleDetails) {
            this.cloneFsuCycleDetails = cloneFsuCycleDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CloneFsuCycleRequest o) {
            this.fsuCycleId(o.getFsuCycleId());
            this.cloneFsuCycleDetails(o.getCloneFsuCycleDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CloneFsuCycleRequest build() {
            CloneFsuCycleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CloneFsuCycleDetails body) {
            this.cloneFsuCycleDetails(body);
            return this;
        }

        public CloneFsuCycleRequest buildWithoutInvocationCallback() {
            CloneFsuCycleRequest request = new CloneFsuCycleRequest();
            request.fsuCycleId = this.fsuCycleId;
            request.cloneFsuCycleDetails = this.cloneFsuCycleDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

