/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFsuActionRequest
extends BmcRequest<Void> {
    private String fsuActionId;
    private String opcRequestId;

    public String getFsuActionId() {
        return this.fsuActionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fsuActionId(this.fsuActionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fsuActionId=").append(String.valueOf(this.fsuActionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFsuActionRequest)) {
            return false;
        }
        GetFsuActionRequest other = (GetFsuActionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fsuActionId, other.fsuActionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fsuActionId == null ? 43 : this.fsuActionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFsuActionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fsuActionId = null;
        private String opcRequestId = null;

        public Builder fsuActionId(String fsuActionId) {
            this.fsuActionId = fsuActionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFsuActionRequest o) {
            this.fsuActionId(o.getFsuActionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFsuActionRequest build() {
            GetFsuActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFsuActionRequest buildWithoutInvocationCallback() {
            GetFsuActionRequest request = new GetFsuActionRequest();
            request.fsuActionId = this.fsuActionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

