/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFsuDiscoveryRequest
extends BmcRequest<Void> {
    private String fsuDiscoveryId;
    private String opcRequestId;

    public String getFsuDiscoveryId() {
        return this.fsuDiscoveryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fsuDiscoveryId(this.fsuDiscoveryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fsuDiscoveryId=").append(String.valueOf(this.fsuDiscoveryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFsuDiscoveryRequest)) {
            return false;
        }
        GetFsuDiscoveryRequest other = (GetFsuDiscoveryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fsuDiscoveryId, other.fsuDiscoveryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fsuDiscoveryId == null ? 43 : this.fsuDiscoveryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFsuDiscoveryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fsuDiscoveryId = null;
        private String opcRequestId = null;

        public Builder fsuDiscoveryId(String fsuDiscoveryId) {
            this.fsuDiscoveryId = fsuDiscoveryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFsuDiscoveryRequest o) {
            this.fsuDiscoveryId(o.getFsuDiscoveryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFsuDiscoveryRequest build() {
            GetFsuDiscoveryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFsuDiscoveryRequest buildWithoutInvocationCallback() {
            GetFsuDiscoveryRequest request = new GetFsuDiscoveryRequest();
            request.fsuDiscoveryId = this.fsuDiscoveryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

