/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetsoftwareupdate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFsuJobOutputContentRequest
extends BmcRequest<Void> {
    private String fsuJobId;
    private String opcRequestId;

    public String getFsuJobId() {
        return this.fsuJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fsuJobId(this.fsuJobId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fsuJobId=").append(String.valueOf(this.fsuJobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFsuJobOutputContentRequest)) {
            return false;
        }
        GetFsuJobOutputContentRequest other = (GetFsuJobOutputContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fsuJobId, other.fsuJobId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fsuJobId == null ? 43 : this.fsuJobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFsuJobOutputContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fsuJobId = null;
        private String opcRequestId = null;

        public Builder fsuJobId(String fsuJobId) {
            this.fsuJobId = fsuJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFsuJobOutputContentRequest o) {
            this.fsuJobId(o.getFsuJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFsuJobOutputContentRequest build() {
            GetFsuJobOutputContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFsuJobOutputContentRequest buildWithoutInvocationCallback() {
            GetFsuJobOutputContentRequest request = new GetFsuJobOutputContentRequest();
            request.fsuJobId = this.fsuJobId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

