/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.functions.FunctionsManagementAsync;
import com.oracle.bmc.functions.model.Application;
import com.oracle.bmc.functions.model.ApplicationSummary;
import com.oracle.bmc.functions.model.Function;
import com.oracle.bmc.functions.model.FunctionSummary;
import com.oracle.bmc.functions.model.PbfListing;
import com.oracle.bmc.functions.model.PbfListingVersion;
import com.oracle.bmc.functions.model.PbfListingVersionsCollection;
import com.oracle.bmc.functions.model.PbfListingsCollection;
import com.oracle.bmc.functions.model.TriggersCollection;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.GetPbfListingRequest;
import com.oracle.bmc.functions.requests.GetPbfListingVersionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingVersionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingsRequest;
import com.oracle.bmc.functions.requests.ListTriggersRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.GetPbfListingResponse;
import com.oracle.bmc.functions.responses.GetPbfListingVersionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingVersionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingsResponse;
import com.oracle.bmc.functions.responses.ListTriggersResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManagementAsyncClient
extends BaseAsyncClient
implements FunctionsManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FUNCTIONSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://functions.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsManagementAsyncClient.class);

    FunctionsManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request, AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApplicationCompartmentDetails(), "changeApplicationCompartmentDetails is required");
        return this.clientCall(request, ChangeApplicationCompartmentResponse::builder).logger(LOG, "changeApplicationCompartment").serviceDetails("FunctionsManagement", "ChangeApplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Application/ChangeApplicationCompartment").method(Method.POST).requestBuilder(ChangeApplicationCompartmentRequest::builder).basePath("/20181201").appendPathParam("applications").appendPathParam(request.getApplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeApplicationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        Objects.requireNonNull(request.getCreateApplicationDetails(), "createApplicationDetails is required");
        return this.clientCall(request, CreateApplicationResponse::builder).logger(LOG, "createApplication").serviceDetails("FunctionsManagement", "CreateApplication", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Application/CreateApplication").method(Method.POST).requestBuilder(CreateApplicationRequest::builder).basePath("/20181201").appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Application.class, CreateApplicationResponse.Builder::application).handleResponseHeaderString("etag", CreateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFunctionResponse> createFunction(CreateFunctionRequest request, AsyncHandler<CreateFunctionRequest, CreateFunctionResponse> handler) {
        Objects.requireNonNull(request.getCreateFunctionDetails(), "createFunctionDetails is required");
        return this.clientCall(request, CreateFunctionResponse::builder).logger(LOG, "createFunction").serviceDetails("FunctionsManagement", "CreateFunction", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Function/CreateFunction").method(Method.POST).requestBuilder(CreateFunctionRequest::builder).basePath("/20181201").appendPathParam("functions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Function.class, CreateFunctionResponse.Builder::function).handleResponseHeaderString("etag", CreateFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApplicationResponse::builder).logger(LOG, "deleteApplication").serviceDetails("FunctionsManagement", "DeleteApplication", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Application/DeleteApplication").method(Method.DELETE).requestBuilder(DeleteApplicationRequest::builder).basePath("/20181201").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request, AsyncHandler<DeleteFunctionRequest, DeleteFunctionResponse> handler) {
        Validate.notBlank((String)request.getFunctionId(), (String)"functionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFunctionResponse::builder).logger(LOG, "deleteFunction").serviceDetails("FunctionsManagement", "DeleteFunction", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Function/DeleteFunction").method(Method.DELETE).requestBuilder(DeleteFunctionRequest::builder).basePath("/20181201").appendPathParam("functions").appendPathParam(request.getFunctionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApplicationResponse::builder).logger(LOG, "getApplication").serviceDetails("FunctionsManagement", "GetApplication", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Application/GetApplication").method(Method.GET).requestBuilder(GetApplicationRequest::builder).basePath("/20181201").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Application.class, GetApplicationResponse.Builder::application).handleResponseHeaderString("etag", GetApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFunctionResponse> getFunction(GetFunctionRequest request, AsyncHandler<GetFunctionRequest, GetFunctionResponse> handler) {
        Validate.notBlank((String)request.getFunctionId(), (String)"functionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFunctionResponse::builder).logger(LOG, "getFunction").serviceDetails("FunctionsManagement", "GetFunction", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Function/GetFunction").method(Method.GET).requestBuilder(GetFunctionRequest::builder).basePath("/20181201").appendPathParam("functions").appendPathParam(request.getFunctionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Function.class, GetFunctionResponse.Builder::function).handleResponseHeaderString("etag", GetFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPbfListingResponse> getPbfListing(GetPbfListingRequest request, AsyncHandler<GetPbfListingRequest, GetPbfListingResponse> handler) {
        Validate.notBlank((String)request.getPbfListingId(), (String)"pbfListingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPbfListingResponse::builder).logger(LOG, "getPbfListing").serviceDetails("FunctionsManagement", "GetPbfListing", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/PbfListing/GetPbfListing").method(Method.GET).requestBuilder(GetPbfListingRequest::builder).basePath("/20181201").appendPathParam("pbfListings").appendPathParam(request.getPbfListingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PbfListing.class, GetPbfListingResponse.Builder::pbfListing).handleResponseHeaderString("etag", GetPbfListingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPbfListingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPbfListingVersionResponse> getPbfListingVersion(GetPbfListingVersionRequest request, AsyncHandler<GetPbfListingVersionRequest, GetPbfListingVersionResponse> handler) {
        Validate.notBlank((String)request.getPbfListingVersionId(), (String)"pbfListingVersionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPbfListingVersionResponse::builder).logger(LOG, "getPbfListingVersion").serviceDetails("FunctionsManagement", "GetPbfListingVersion", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/PbfListingVersion/GetPbfListingVersion").method(Method.GET).requestBuilder(GetPbfListingVersionRequest::builder).basePath("/20181201").appendPathParam("pbfListingVersions").appendPathParam(request.getPbfListingVersionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PbfListingVersion.class, GetPbfListingVersionResponse.Builder::pbfListingVersion).handleResponseHeaderString("etag", GetPbfListingVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPbfListingVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApplicationsResponse::builder).logger(LOG, "listApplications").serviceDetails("FunctionsManagement", "ListApplications", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/ApplicationSummary/ListApplications").method(Method.GET).requestBuilder(ListApplicationsRequest::builder).basePath("/20181201").appendPathParam("applications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApplicationSummary.class, ListApplicationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListApplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListApplicationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListFunctionsResponse> listFunctions(ListFunctionsRequest request, AsyncHandler<ListFunctionsRequest, ListFunctionsResponse> handler) {
        Objects.requireNonNull(request.getApplicationId(), "applicationId is required");
        return this.clientCall(request, ListFunctionsResponse::builder).logger(LOG, "listFunctions").serviceDetails("FunctionsManagement", "ListFunctions", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/FunctionSummary/ListFunctions").method(Method.GET).requestBuilder(ListFunctionsRequest::builder).basePath("/20181201").appendPathParam("functions").appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(FunctionSummary.class, ListFunctionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListFunctionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListFunctionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListPbfListingVersionsResponse> listPbfListingVersions(ListPbfListingVersionsRequest request, AsyncHandler<ListPbfListingVersionsRequest, ListPbfListingVersionsResponse> handler) {
        Objects.requireNonNull(request.getPbfListingId(), "pbfListingId is required");
        return this.clientCall(request, ListPbfListingVersionsResponse::builder).logger(LOG, "listPbfListingVersions").serviceDetails("FunctionsManagement", "ListPbfListingVersions", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/PbfListingVersion/ListPbfListingVersions").method(Method.GET).requestBuilder(ListPbfListingVersionsRequest::builder).basePath("/20181201").appendPathParam("pbfListingVersions").appendQueryParam("pbfListingId", (Object)request.getPbfListingId()).appendQueryParam("pbfListingVersionId", (Object)request.getPbfListingVersionId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isCurrentVersion", (Object)request.getIsCurrentVersion()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PbfListingVersionsCollection.class, ListPbfListingVersionsResponse.Builder::pbfListingVersionsCollection).handleResponseHeaderString("opc-request-id", ListPbfListingVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPbfListingVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPbfListingsResponse> listPbfListings(ListPbfListingsRequest request, AsyncHandler<ListPbfListingsRequest, ListPbfListingsResponse> handler) {
        return this.clientCall(request, ListPbfListingsResponse::builder).logger(LOG, "listPbfListings").serviceDetails("FunctionsManagement", "ListPbfListings", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/PbfListing/ListPbfListings").method(Method.GET).requestBuilder(ListPbfListingsRequest::builder).basePath("/20181201").appendPathParam("pbfListings").appendQueryParam("pbfListingId", (Object)request.getPbfListingId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("nameStartsWith", (Object)request.getNameStartsWith()).appendListQueryParam("trigger", request.getTrigger(), CollectionFormatType.Multi).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PbfListingsCollection.class, ListPbfListingsResponse.Builder::pbfListingsCollection).handleResponseHeaderString("opc-request-id", ListPbfListingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPbfListingsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTriggersResponse> listTriggers(ListTriggersRequest request, AsyncHandler<ListTriggersRequest, ListTriggersResponse> handler) {
        return this.clientCall(request, ListTriggersResponse::builder).logger(LOG, "listTriggers").serviceDetails("FunctionsManagement", "ListTriggers", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/TriggersCollection/ListTriggers").method(Method.GET).requestBuilder(ListTriggersRequest::builder).basePath("/20181201").appendPathParam("pbfListings").appendPathParam("triggers").appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TriggersCollection.class, ListTriggersResponse.Builder::triggersCollection).handleResponseHeaderString("opc-request-id", ListTriggersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTriggersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApplicationDetails(), "updateApplicationDetails is required");
        return this.clientCall(request, UpdateApplicationResponse::builder).logger(LOG, "updateApplication").serviceDetails("FunctionsManagement", "UpdateApplication", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Application/UpdateApplication").method(Method.PUT).requestBuilder(UpdateApplicationRequest::builder).basePath("/20181201").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Application.class, UpdateApplicationResponse.Builder::application).handleResponseHeaderString("etag", UpdateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateApplicationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request, AsyncHandler<UpdateFunctionRequest, UpdateFunctionResponse> handler) {
        Validate.notBlank((String)request.getFunctionId(), (String)"functionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFunctionDetails(), "updateFunctionDetails is required");
        return this.clientCall(request, UpdateFunctionResponse::builder).logger(LOG, "updateFunction").serviceDetails("FunctionsManagement", "UpdateFunction", "https://docs.oracle.com/iaas/api/#/en/functions/20181201/Function/UpdateFunction").method(Method.PUT).requestBuilder(UpdateFunctionRequest::builder).basePath("/20181201").appendPathParam("functions").appendPathParam(request.getFunctionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Function.class, UpdateFunctionResponse.Builder::function).handleResponseHeaderString("etag", UpdateFunctionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFunctionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FunctionsManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FunctionsManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FunctionsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FunctionsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FunctionsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FunctionsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FunctionsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FunctionsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FunctionsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FunctionsManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FunctionsManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

