/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.oracle.bmc.functions.FunctionsManagement;
import com.oracle.bmc.functions.model.Application;
import com.oracle.bmc.functions.model.Function;
import com.oracle.bmc.functions.model.PbfListing;
import com.oracle.bmc.functions.model.PbfListingVersion;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.GetPbfListingRequest;
import com.oracle.bmc.functions.requests.GetPbfListingVersionRequest;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.GetPbfListingResponse;
import com.oracle.bmc.functions.responses.GetPbfListingVersionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FunctionsManagementWaiters {
    private final ExecutorService executorService;
    private final FunctionsManagement client;

    public FunctionsManagementWaiters(ExecutorService executorService, FunctionsManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(BmcGenericWaiter waiter, GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        final HashSet<Application.LifecycleState> targetStatesSet = new HashSet<Application.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApplicationRequest, GetApplicationResponse>(){

            @Override
            public GetApplicationResponse apply(GetApplicationRequest request) {
                return FunctionsManagementWaiters.this.client.getApplication(request);
            }
        }, (Predicate)new Predicate<GetApplicationResponse>(){

            @Override
            public boolean test(GetApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Application.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, Function.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFunction(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, Function.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFunction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Function.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFunction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(BmcGenericWaiter waiter, GetFunctionRequest request, Function.LifecycleState ... targetStates) {
        final HashSet<Function.LifecycleState> targetStatesSet = new HashSet<Function.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFunctionRequest, GetFunctionResponse>(){

            @Override
            public GetFunctionResponse apply(GetFunctionRequest request) {
                return FunctionsManagementWaiters.this.client.getFunction(request);
            }
        }, (Predicate)new Predicate<GetFunctionResponse>(){

            @Override
            public boolean test(GetFunctionResponse response) {
                return targetStatesSet.contains((Object)response.getFunction().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Function.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPbfListingRequest, GetPbfListingResponse> forPbfListing(GetPbfListingRequest request, PbfListing.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPbfListing(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPbfListingRequest, GetPbfListingResponse> forPbfListing(GetPbfListingRequest request, PbfListing.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPbfListing(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPbfListingRequest, GetPbfListingResponse> forPbfListing(GetPbfListingRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PbfListing.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPbfListing(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPbfListingRequest, GetPbfListingResponse> forPbfListing(BmcGenericWaiter waiter, GetPbfListingRequest request, PbfListing.LifecycleState ... targetStates) {
        final HashSet<PbfListing.LifecycleState> targetStatesSet = new HashSet<PbfListing.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPbfListingRequest, GetPbfListingResponse>(){

            @Override
            public GetPbfListingResponse apply(GetPbfListingRequest request) {
                return FunctionsManagementWaiters.this.client.getPbfListing(request);
            }
        }, (Predicate)new Predicate<GetPbfListingResponse>(){

            @Override
            public boolean test(GetPbfListingResponse response) {
                return targetStatesSet.contains((Object)response.getPbfListing().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PbfListing.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPbfListingVersionRequest, GetPbfListingVersionResponse> forPbfListingVersion(GetPbfListingVersionRequest request, PbfListingVersion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPbfListingVersion(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPbfListingVersionRequest, GetPbfListingVersionResponse> forPbfListingVersion(GetPbfListingVersionRequest request, PbfListingVersion.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPbfListingVersion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPbfListingVersionRequest, GetPbfListingVersionResponse> forPbfListingVersion(GetPbfListingVersionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PbfListingVersion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPbfListingVersion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPbfListingVersionRequest, GetPbfListingVersionResponse> forPbfListingVersion(BmcGenericWaiter waiter, GetPbfListingVersionRequest request, PbfListingVersion.LifecycleState ... targetStates) {
        final HashSet<PbfListingVersion.LifecycleState> targetStatesSet = new HashSet<PbfListingVersion.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPbfListingVersionRequest, GetPbfListingVersionResponse>(){

            @Override
            public GetPbfListingVersionResponse apply(GetPbfListingVersionRequest request) {
                return FunctionsManagementWaiters.this.client.getPbfListingVersion(request);
            }
        }, (Predicate)new Predicate<GetPbfListingVersionResponse>(){

            @Override
            public boolean test(GetPbfListingVersionResponse response) {
                return targetStatesSet.contains((Object)response.getPbfListingVersion().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PbfListingVersion.LifecycleState.Deleted)), (Object)request);
    }
}

