/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPbfListingVersionRequest
extends BmcRequest<Void> {
    private String pbfListingVersionId;
    private String opcRequestId;

    public String getPbfListingVersionId() {
        return this.pbfListingVersionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pbfListingVersionId(this.pbfListingVersionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pbfListingVersionId=").append(String.valueOf(this.pbfListingVersionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPbfListingVersionRequest)) {
            return false;
        }
        GetPbfListingVersionRequest other = (GetPbfListingVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pbfListingVersionId, other.pbfListingVersionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pbfListingVersionId == null ? 43 : this.pbfListingVersionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPbfListingVersionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pbfListingVersionId = null;
        private String opcRequestId = null;

        public Builder pbfListingVersionId(String pbfListingVersionId) {
            this.pbfListingVersionId = pbfListingVersionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPbfListingVersionRequest o) {
            this.pbfListingVersionId(o.getPbfListingVersionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPbfListingVersionRequest build() {
            GetPbfListingVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPbfListingVersionRequest buildWithoutInvocationCallback() {
            GetPbfListingVersionRequest request = new GetPbfListingVersionRequest();
            request.pbfListingVersionId = this.pbfListingVersionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

