/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.oracle.bmc.functions.FunctionsManagement;
import com.oracle.bmc.functions.model.ApplicationSummary;
import com.oracle.bmc.functions.model.FunctionSummary;
import com.oracle.bmc.functions.model.PbfListingSummary;
import com.oracle.bmc.functions.model.PbfListingVersionSummary;
import com.oracle.bmc.functions.model.TriggerSummary;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingVersionsRequest;
import com.oracle.bmc.functions.requests.ListPbfListingsRequest;
import com.oracle.bmc.functions.requests.ListTriggersRequest;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingVersionsResponse;
import com.oracle.bmc.functions.responses.ListPbfListingsResponse;
import com.oracle.bmc.functions.responses.ListTriggersResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionsManagementPaginators {
    private final FunctionsManagement client;

    public FunctionsManagementPaginators(FunctionsManagement client) {
        this.client = client;
    }

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return FunctionsManagementPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return FunctionsManagementPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            @Override
            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFunctionsResponse> listFunctionsResponseIterator(final ListFunctionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFunctionsRequest.Builder>(){

            @Override
            public ListFunctionsRequest.Builder get() {
                return ListFunctionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFunctionsResponse, String>(){

            @Override
            public String apply(ListFunctionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFunctionsRequest.Builder>, ListFunctionsRequest>(){

            @Override
            public ListFunctionsRequest apply(RequestBuilderAndToken<ListFunctionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFunctionsRequest, ListFunctionsResponse>(){

            @Override
            public ListFunctionsResponse apply(ListFunctionsRequest request) {
                return FunctionsManagementPaginators.this.client.listFunctions(request);
            }
        });
    }

    public Iterable<FunctionSummary> listFunctionsRecordIterator(final ListFunctionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFunctionsRequest.Builder>(){

            @Override
            public ListFunctionsRequest.Builder get() {
                return ListFunctionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFunctionsResponse, String>(){

            @Override
            public String apply(ListFunctionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFunctionsRequest.Builder>, ListFunctionsRequest>(){

            @Override
            public ListFunctionsRequest apply(RequestBuilderAndToken<ListFunctionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFunctionsRequest, ListFunctionsResponse>(){

            @Override
            public ListFunctionsResponse apply(ListFunctionsRequest request) {
                return FunctionsManagementPaginators.this.client.listFunctions(request);
            }
        }, (Function)new Function<ListFunctionsResponse, List<FunctionSummary>>(){

            @Override
            public List<FunctionSummary> apply(ListFunctionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPbfListingVersionsResponse> listPbfListingVersionsResponseIterator(final ListPbfListingVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPbfListingVersionsRequest.Builder>(){

            @Override
            public ListPbfListingVersionsRequest.Builder get() {
                return ListPbfListingVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPbfListingVersionsResponse, String>(){

            @Override
            public String apply(ListPbfListingVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPbfListingVersionsRequest.Builder>, ListPbfListingVersionsRequest>(){

            @Override
            public ListPbfListingVersionsRequest apply(RequestBuilderAndToken<ListPbfListingVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPbfListingVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPbfListingVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPbfListingVersionsRequest, ListPbfListingVersionsResponse>(){

            @Override
            public ListPbfListingVersionsResponse apply(ListPbfListingVersionsRequest request) {
                return FunctionsManagementPaginators.this.client.listPbfListingVersions(request);
            }
        });
    }

    public Iterable<PbfListingVersionSummary> listPbfListingVersionsRecordIterator(final ListPbfListingVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPbfListingVersionsRequest.Builder>(){

            @Override
            public ListPbfListingVersionsRequest.Builder get() {
                return ListPbfListingVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPbfListingVersionsResponse, String>(){

            @Override
            public String apply(ListPbfListingVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPbfListingVersionsRequest.Builder>, ListPbfListingVersionsRequest>(){

            @Override
            public ListPbfListingVersionsRequest apply(RequestBuilderAndToken<ListPbfListingVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPbfListingVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPbfListingVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPbfListingVersionsRequest, ListPbfListingVersionsResponse>(){

            @Override
            public ListPbfListingVersionsResponse apply(ListPbfListingVersionsRequest request) {
                return FunctionsManagementPaginators.this.client.listPbfListingVersions(request);
            }
        }, (Function)new Function<ListPbfListingVersionsResponse, List<PbfListingVersionSummary>>(){

            @Override
            public List<PbfListingVersionSummary> apply(ListPbfListingVersionsResponse response) {
                return response.getPbfListingVersionsCollection().getItems();
            }
        });
    }

    public Iterable<ListPbfListingsResponse> listPbfListingsResponseIterator(final ListPbfListingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPbfListingsRequest.Builder>(){

            @Override
            public ListPbfListingsRequest.Builder get() {
                return ListPbfListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPbfListingsResponse, String>(){

            @Override
            public String apply(ListPbfListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPbfListingsRequest.Builder>, ListPbfListingsRequest>(){

            @Override
            public ListPbfListingsRequest apply(RequestBuilderAndToken<ListPbfListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPbfListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPbfListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPbfListingsRequest, ListPbfListingsResponse>(){

            @Override
            public ListPbfListingsResponse apply(ListPbfListingsRequest request) {
                return FunctionsManagementPaginators.this.client.listPbfListings(request);
            }
        });
    }

    public Iterable<PbfListingSummary> listPbfListingsRecordIterator(final ListPbfListingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPbfListingsRequest.Builder>(){

            @Override
            public ListPbfListingsRequest.Builder get() {
                return ListPbfListingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPbfListingsResponse, String>(){

            @Override
            public String apply(ListPbfListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPbfListingsRequest.Builder>, ListPbfListingsRequest>(){

            @Override
            public ListPbfListingsRequest apply(RequestBuilderAndToken<ListPbfListingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPbfListingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPbfListingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPbfListingsRequest, ListPbfListingsResponse>(){

            @Override
            public ListPbfListingsResponse apply(ListPbfListingsRequest request) {
                return FunctionsManagementPaginators.this.client.listPbfListings(request);
            }
        }, (Function)new Function<ListPbfListingsResponse, List<PbfListingSummary>>(){

            @Override
            public List<PbfListingSummary> apply(ListPbfListingsResponse response) {
                return response.getPbfListingsCollection().getItems();
            }
        });
    }

    public Iterable<ListTriggersResponse> listTriggersResponseIterator(final ListTriggersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTriggersRequest.Builder>(){

            @Override
            public ListTriggersRequest.Builder get() {
                return ListTriggersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTriggersResponse, String>(){

            @Override
            public String apply(ListTriggersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTriggersRequest.Builder>, ListTriggersRequest>(){

            @Override
            public ListTriggersRequest apply(RequestBuilderAndToken<ListTriggersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTriggersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTriggersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTriggersRequest, ListTriggersResponse>(){

            @Override
            public ListTriggersResponse apply(ListTriggersRequest request) {
                return FunctionsManagementPaginators.this.client.listTriggers(request);
            }
        });
    }

    public Iterable<TriggerSummary> listTriggersRecordIterator(final ListTriggersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTriggersRequest.Builder>(){

            @Override
            public ListTriggersRequest.Builder get() {
                return ListTriggersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTriggersResponse, String>(){

            @Override
            public String apply(ListTriggersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTriggersRequest.Builder>, ListTriggersRequest>(){

            @Override
            public ListTriggersRequest apply(RequestBuilderAndToken<ListTriggersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTriggersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTriggersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTriggersRequest, ListTriggersResponse>(){

            @Override
            public ListTriggersResponse apply(ListTriggersRequest request) {
                return FunctionsManagementPaginators.this.client.listTriggers(request);
            }
        }, (Function)new Function<ListTriggersResponse, List<TriggerSummary>>(){

            @Override
            public List<TriggerSummary> apply(ListTriggersResponse response) {
                return response.getTriggersCollection().getItems();
            }
        });
    }
}

