/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.functions.model.FunctionProvisionedConcurrencyConfig;
import com.oracle.bmc.functions.model.FunctionSourceDetails;
import com.oracle.bmc.functions.model.FunctionTraceConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Function
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="image")
    private final String image;
    @JsonProperty(value="imageDigest")
    private final String imageDigest;
    @JsonProperty(value="sourceDetails")
    private final FunctionSourceDetails sourceDetails;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="memoryInMBs")
    private final Long memoryInMBs;
    @JsonProperty(value="config")
    private final Map<String, String> config;
    @JsonProperty(value="timeoutInSeconds")
    private final Integer timeoutInSeconds;
    @JsonProperty(value="provisionedConcurrencyConfig")
    private final FunctionProvisionedConcurrencyConfig provisionedConcurrencyConfig;
    @JsonProperty(value="traceConfig")
    private final FunctionTraceConfig traceConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="invokeEndpoint")
    private final String invokeEndpoint;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "lifecycleState", "applicationId", "compartmentId", "image", "imageDigest", "sourceDetails", "shape", "memoryInMBs", "config", "timeoutInSeconds", "provisionedConcurrencyConfig", "traceConfig", "freeformTags", "invokeEndpoint", "definedTags", "timeCreated", "timeUpdated"})
    public Function(String id, String displayName, LifecycleState lifecycleState, String applicationId, String compartmentId, String image, String imageDigest, FunctionSourceDetails sourceDetails, Shape shape, Long memoryInMBs, Map<String, String> config, Integer timeoutInSeconds, FunctionProvisionedConcurrencyConfig provisionedConcurrencyConfig, FunctionTraceConfig traceConfig, Map<String, String> freeformTags, String invokeEndpoint, Map<String, Map<String, Object>> definedTags, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.applicationId = applicationId;
        this.compartmentId = compartmentId;
        this.image = image;
        this.imageDigest = imageDigest;
        this.sourceDetails = sourceDetails;
        this.shape = shape;
        this.memoryInMBs = memoryInMBs;
        this.config = config;
        this.timeoutInSeconds = timeoutInSeconds;
        this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
        this.traceConfig = traceConfig;
        this.freeformTags = freeformTags;
        this.invokeEndpoint = invokeEndpoint;
        this.definedTags = definedTags;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public FunctionSourceDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Long getMemoryInMBs() {
        return this.memoryInMBs;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public FunctionProvisionedConcurrencyConfig getProvisionedConcurrencyConfig() {
        return this.provisionedConcurrencyConfig;
    }

    public FunctionTraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getInvokeEndpoint() {
        return this.invokeEndpoint;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Function(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", imageDigest=").append(String.valueOf(this.imageDigest));
        sb.append(", sourceDetails=").append(String.valueOf((Object)this.sourceDetails));
        sb.append(", shape=").append(String.valueOf((Object)this.shape));
        sb.append(", memoryInMBs=").append(String.valueOf(this.memoryInMBs));
        sb.append(", config=").append(String.valueOf(this.config));
        sb.append(", timeoutInSeconds=").append(String.valueOf(this.timeoutInSeconds));
        sb.append(", provisionedConcurrencyConfig=").append(String.valueOf((Object)this.provisionedConcurrencyConfig));
        sb.append(", traceConfig=").append(String.valueOf((Object)this.traceConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", invokeEndpoint=").append(String.valueOf(this.invokeEndpoint));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.image, other.image) && Objects.equals(this.imageDigest, other.imageDigest) && Objects.equals((Object)this.sourceDetails, (Object)other.sourceDetails) && Objects.equals((Object)this.shape, (Object)other.shape) && Objects.equals(this.memoryInMBs, other.memoryInMBs) && Objects.equals(this.config, other.config) && Objects.equals(this.timeoutInSeconds, other.timeoutInSeconds) && Objects.equals((Object)this.provisionedConcurrencyConfig, (Object)other.provisionedConcurrencyConfig) && Objects.equals((Object)this.traceConfig, (Object)other.traceConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.invokeEndpoint, other.invokeEndpoint) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.imageDigest == null ? 43 : this.imageDigest.hashCode());
        result = result * 59 + (this.sourceDetails == null ? 43 : this.sourceDetails.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.memoryInMBs == null ? 43 : this.memoryInMBs.hashCode());
        result = result * 59 + (this.config == null ? 43 : this.config.hashCode());
        result = result * 59 + (this.timeoutInSeconds == null ? 43 : this.timeoutInSeconds.hashCode());
        result = result * 59 + (this.provisionedConcurrencyConfig == null ? 43 : this.provisionedConcurrencyConfig.hashCode());
        result = result * 59 + (this.traceConfig == null ? 43 : this.traceConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.invokeEndpoint == null ? 43 : this.invokeEndpoint.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Shape implements BmcEnum
    {
        GenericX86("GENERIC_X86"),
        GenericArm("GENERIC_ARM"),
        GenericX86Arm("GENERIC_X86_ARM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Shape> map;

        private Shape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Shape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Shape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Shape.class);
            map = new HashMap<String, Shape>();
            for (Shape v : Shape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="image")
        private String image;
        @JsonProperty(value="imageDigest")
        private String imageDigest;
        @JsonProperty(value="sourceDetails")
        private FunctionSourceDetails sourceDetails;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="memoryInMBs")
        private Long memoryInMBs;
        @JsonProperty(value="config")
        private Map<String, String> config;
        @JsonProperty(value="timeoutInSeconds")
        private Integer timeoutInSeconds;
        @JsonProperty(value="provisionedConcurrencyConfig")
        private FunctionProvisionedConcurrencyConfig provisionedConcurrencyConfig;
        @JsonProperty(value="traceConfig")
        private FunctionTraceConfig traceConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="invokeEndpoint")
        private String invokeEndpoint;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            this.__explicitlySet__.add("imageDigest");
            return this;
        }

        public Builder sourceDetails(FunctionSourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            this.__explicitlySet__.add("sourceDetails");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder memoryInMBs(Long memoryInMBs) {
            this.memoryInMBs = memoryInMBs;
            this.__explicitlySet__.add("memoryInMBs");
            return this;
        }

        public Builder config(Map<String, String> config) {
            this.config = config;
            this.__explicitlySet__.add("config");
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            this.__explicitlySet__.add("timeoutInSeconds");
            return this;
        }

        public Builder provisionedConcurrencyConfig(FunctionProvisionedConcurrencyConfig provisionedConcurrencyConfig) {
            this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
            this.__explicitlySet__.add("provisionedConcurrencyConfig");
            return this;
        }

        public Builder traceConfig(FunctionTraceConfig traceConfig) {
            this.traceConfig = traceConfig;
            this.__explicitlySet__.add("traceConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder invokeEndpoint(String invokeEndpoint) {
            this.invokeEndpoint = invokeEndpoint;
            this.__explicitlySet__.add("invokeEndpoint");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Function build() {
            Function model = new Function(this.id, this.displayName, this.lifecycleState, this.applicationId, this.compartmentId, this.image, this.imageDigest, this.sourceDetails, this.shape, this.memoryInMBs, this.config, this.timeoutInSeconds, this.provisionedConcurrencyConfig, this.traceConfig, this.freeformTags, this.invokeEndpoint, this.definedTags, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Function model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("imageDigest")) {
                this.imageDigest(model.getImageDigest());
            }
            if (model.wasPropertyExplicitlySet("sourceDetails")) {
                this.sourceDetails(model.getSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("memoryInMBs")) {
                this.memoryInMBs(model.getMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("config")) {
                this.config(model.getConfig());
            }
            if (model.wasPropertyExplicitlySet("timeoutInSeconds")) {
                this.timeoutInSeconds(model.getTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("provisionedConcurrencyConfig")) {
                this.provisionedConcurrencyConfig(model.getProvisionedConcurrencyConfig());
            }
            if (model.wasPropertyExplicitlySet("traceConfig")) {
                this.traceConfig(model.getTraceConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("invokeEndpoint")) {
                this.invokeEndpoint(model.getInvokeEndpoint());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

