/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.functions.model.ApplicationTraceConfig;
import com.oracle.bmc.functions.model.ImagePolicyConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateApplicationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="config")
    private final Map<String, String> config;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="syslogUrl")
    private final String syslogUrl;
    @JsonProperty(value="traceConfig")
    private final ApplicationTraceConfig traceConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="imagePolicyConfig")
    private final ImagePolicyConfig imagePolicyConfig;

    @Deprecated
    @ConstructorProperties(value={"config", "networkSecurityGroupIds", "syslogUrl", "traceConfig", "freeformTags", "definedTags", "imagePolicyConfig"})
    public UpdateApplicationDetails(Map<String, String> config, List<String> networkSecurityGroupIds, String syslogUrl, ApplicationTraceConfig traceConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ImagePolicyConfig imagePolicyConfig) {
        this.config = config;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.syslogUrl = syslogUrl;
        this.traceConfig = traceConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.imagePolicyConfig = imagePolicyConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public String getSyslogUrl() {
        return this.syslogUrl;
    }

    public ApplicationTraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public ImagePolicyConfig getImagePolicyConfig() {
        return this.imagePolicyConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateApplicationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("config=").append(String.valueOf(this.config));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", syslogUrl=").append(String.valueOf(this.syslogUrl));
        sb.append(", traceConfig=").append(String.valueOf((Object)this.traceConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", imagePolicyConfig=").append(String.valueOf((Object)this.imagePolicyConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateApplicationDetails)) {
            return false;
        }
        UpdateApplicationDetails other = (UpdateApplicationDetails)((Object)o);
        return Objects.equals(this.config, other.config) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals(this.syslogUrl, other.syslogUrl) && Objects.equals((Object)this.traceConfig, (Object)other.traceConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.imagePolicyConfig, (Object)other.imagePolicyConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.config == null ? 43 : this.config.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.syslogUrl == null ? 43 : this.syslogUrl.hashCode());
        result = result * 59 + (this.traceConfig == null ? 43 : this.traceConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.imagePolicyConfig == null ? 43 : this.imagePolicyConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="config")
        private Map<String, String> config;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="syslogUrl")
        private String syslogUrl;
        @JsonProperty(value="traceConfig")
        private ApplicationTraceConfig traceConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="imagePolicyConfig")
        private ImagePolicyConfig imagePolicyConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder config(Map<String, String> config) {
            this.config = config;
            this.__explicitlySet__.add("config");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder syslogUrl(String syslogUrl) {
            this.syslogUrl = syslogUrl;
            this.__explicitlySet__.add("syslogUrl");
            return this;
        }

        public Builder traceConfig(ApplicationTraceConfig traceConfig) {
            this.traceConfig = traceConfig;
            this.__explicitlySet__.add("traceConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder imagePolicyConfig(ImagePolicyConfig imagePolicyConfig) {
            this.imagePolicyConfig = imagePolicyConfig;
            this.__explicitlySet__.add("imagePolicyConfig");
            return this;
        }

        public UpdateApplicationDetails build() {
            UpdateApplicationDetails model = new UpdateApplicationDetails(this.config, this.networkSecurityGroupIds, this.syslogUrl, this.traceConfig, this.freeformTags, this.definedTags, this.imagePolicyConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateApplicationDetails model) {
            if (model.wasPropertyExplicitlySet("config")) {
                this.config(model.getConfig());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("syslogUrl")) {
                this.syslogUrl(model.getSyslogUrl());
            }
            if (model.wasPropertyExplicitlySet("traceConfig")) {
                this.traceConfig(model.getTraceConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("imagePolicyConfig")) {
                this.imagePolicyConfig(model.getImagePolicyConfig());
            }
            return this;
        }
    }
}

