/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPbfListingRequest
extends BmcRequest<Void> {
    private String pbfListingId;
    private String opcRequestId;

    public String getPbfListingId() {
        return this.pbfListingId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pbfListingId(this.pbfListingId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pbfListingId=").append(String.valueOf(this.pbfListingId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPbfListingRequest)) {
            return false;
        }
        GetPbfListingRequest other = (GetPbfListingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pbfListingId, other.pbfListingId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pbfListingId == null ? 43 : this.pbfListingId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPbfListingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pbfListingId = null;
        private String opcRequestId = null;

        public Builder pbfListingId(String pbfListingId) {
            this.pbfListingId = pbfListingId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPbfListingRequest o) {
            this.pbfListingId(o.getPbfListingId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPbfListingRequest build() {
            GetPbfListingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPbfListingRequest buildWithoutInvocationCallback() {
            GetPbfListingRequest request = new GetPbfListingRequest();
            request.pbfListingId = this.pbfListingId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

