/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InvokeFunctionRequest
extends BmcRequest<InputStream> {
    private String functionId;
    private InputStream invokeFunctionBody;
    private FnIntent fnIntent;
    private FnInvokeType fnInvokeType;
    private String opcRequestId;

    public String getFunctionId() {
        return this.functionId;
    }

    public InputStream getInvokeFunctionBody() {
        return this.invokeFunctionBody;
    }

    public FnIntent getFnIntent() {
        return this.fnIntent;
    }

    public FnInvokeType getFnInvokeType() {
        return this.fnInvokeType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.invokeFunctionBody;
    }

    public Builder toBuilder() {
        return new Builder().functionId(this.functionId).invokeFunctionBody(this.invokeFunctionBody).fnIntent(this.fnIntent).fnInvokeType(this.fnInvokeType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",functionId=").append(String.valueOf(this.functionId));
        sb.append(",invokeFunctionBody=").append(String.valueOf(this.invokeFunctionBody));
        sb.append(",fnIntent=").append(String.valueOf((Object)this.fnIntent));
        sb.append(",fnInvokeType=").append(String.valueOf((Object)this.fnInvokeType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvokeFunctionRequest)) {
            return false;
        }
        InvokeFunctionRequest other = (InvokeFunctionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.functionId, other.functionId) && Objects.equals(this.invokeFunctionBody, other.invokeFunctionBody) && Objects.equals((Object)this.fnIntent, (Object)other.fnIntent) && Objects.equals((Object)this.fnInvokeType, (Object)other.fnInvokeType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.invokeFunctionBody == null ? 43 : this.invokeFunctionBody.hashCode());
        result = result * 59 + (this.fnIntent == null ? 43 : this.fnIntent.hashCode());
        result = result * 59 + (this.fnInvokeType == null ? 43 : this.fnInvokeType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<InvokeFunctionRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String functionId = null;
        private InputStream invokeFunctionBody = null;
        private FnIntent fnIntent = null;
        private FnInvokeType fnInvokeType = null;
        private String opcRequestId = null;

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder invokeFunctionBody(InputStream invokeFunctionBody) {
            this.invokeFunctionBody = invokeFunctionBody;
            return this;
        }

        public Builder fnIntent(FnIntent fnIntent) {
            this.fnIntent = fnIntent;
            return this;
        }

        public Builder fnInvokeType(FnInvokeType fnInvokeType) {
            this.fnInvokeType = fnInvokeType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InvokeFunctionRequest o) {
            this.functionId(o.getFunctionId());
            this.invokeFunctionBody(o.getInvokeFunctionBody());
            this.fnIntent(o.getFnIntent());
            this.fnInvokeType(o.getFnInvokeType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InvokeFunctionRequest build() {
            InvokeFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.invokeFunctionBody(body);
            return this;
        }

        public InvokeFunctionRequest buildWithoutInvocationCallback() {
            InvokeFunctionRequest request = new InvokeFunctionRequest();
            request.functionId = this.functionId;
            request.invokeFunctionBody = this.invokeFunctionBody;
            request.fnIntent = this.fnIntent;
            request.fnInvokeType = this.fnInvokeType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum FnInvokeType implements BmcEnum
    {
        Detached("detached"),
        Sync("sync");

        private final String value;
        private static Map<String, FnInvokeType> map;

        private FnInvokeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FnInvokeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FnInvokeType: " + key);
        }

        static {
            map = new HashMap<String, FnInvokeType>();
            for (FnInvokeType v : FnInvokeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FnIntent implements BmcEnum
    {
        Httprequest("httprequest"),
        Cloudevent("cloudevent");

        private final String value;
        private static Map<String, FnIntent> map;

        private FnIntent(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FnIntent create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FnIntent: " + key);
        }

        static {
            map = new HashMap<String, FnIntent>();
            for (FnIntent v : FnIntent.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

