/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.functions.model.PbfListingVersion;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPbfListingVersionsRequest
extends BmcRequest<Void> {
    private String pbfListingId;
    private String pbfListingVersionId;
    private String name;
    private Boolean isCurrentVersion;
    private PbfListingVersion.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getPbfListingId() {
        return this.pbfListingId;
    }

    public String getPbfListingVersionId() {
        return this.pbfListingVersionId;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsCurrentVersion() {
        return this.isCurrentVersion;
    }

    public PbfListingVersion.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pbfListingId(this.pbfListingId).pbfListingVersionId(this.pbfListingVersionId).name(this.name).isCurrentVersion(this.isCurrentVersion).lifecycleState(this.lifecycleState).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pbfListingId=").append(String.valueOf(this.pbfListingId));
        sb.append(",pbfListingVersionId=").append(String.valueOf(this.pbfListingVersionId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",isCurrentVersion=").append(String.valueOf(this.isCurrentVersion));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPbfListingVersionsRequest)) {
            return false;
        }
        ListPbfListingVersionsRequest other = (ListPbfListingVersionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pbfListingId, other.pbfListingId) && Objects.equals(this.pbfListingVersionId, other.pbfListingVersionId) && Objects.equals(this.name, other.name) && Objects.equals(this.isCurrentVersion, other.isCurrentVersion) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pbfListingId == null ? 43 : this.pbfListingId.hashCode());
        result = result * 59 + (this.pbfListingVersionId == null ? 43 : this.pbfListingVersionId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isCurrentVersion == null ? 43 : this.isCurrentVersion.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPbfListingVersionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pbfListingId = null;
        private String pbfListingVersionId = null;
        private String name = null;
        private Boolean isCurrentVersion = null;
        private PbfListingVersion.LifecycleState lifecycleState = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder pbfListingId(String pbfListingId) {
            this.pbfListingId = pbfListingId;
            return this;
        }

        public Builder pbfListingVersionId(String pbfListingVersionId) {
            this.pbfListingVersionId = pbfListingVersionId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isCurrentVersion(Boolean isCurrentVersion) {
            this.isCurrentVersion = isCurrentVersion;
            return this;
        }

        public Builder lifecycleState(PbfListingVersion.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPbfListingVersionsRequest o) {
            this.pbfListingId(o.getPbfListingId());
            this.pbfListingVersionId(o.getPbfListingVersionId());
            this.name(o.getName());
            this.isCurrentVersion(o.getIsCurrentVersion());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPbfListingVersionsRequest build() {
            ListPbfListingVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPbfListingVersionsRequest buildWithoutInvocationCallback() {
            ListPbfListingVersionsRequest request = new ListPbfListingVersionsRequest();
            request.pbfListingId = this.pbfListingId;
            request.pbfListingVersionId = this.pbfListingVersionId;
            request.name = this.name;
            request.isCurrentVersion = this.isCurrentVersion;
            request.lifecycleState = this.lifecycleState;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

