/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.functions.model.PbfListing;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListPbfListingsRequest
extends BmcRequest<Void> {
    private String pbfListingId;
    private String name;
    private String nameContains;
    private String nameStartsWith;
    private List<String> trigger;
    private PbfListing.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getPbfListingId() {
        return this.pbfListingId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public String getNameStartsWith() {
        return this.nameStartsWith;
    }

    public List<String> getTrigger() {
        return this.trigger;
    }

    public PbfListing.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pbfListingId(this.pbfListingId).name(this.name).nameContains(this.nameContains).nameStartsWith(this.nameStartsWith).trigger(this.trigger).lifecycleState(this.lifecycleState).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pbfListingId=").append(String.valueOf(this.pbfListingId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",nameContains=").append(String.valueOf(this.nameContains));
        sb.append(",nameStartsWith=").append(String.valueOf(this.nameStartsWith));
        sb.append(",trigger=").append(String.valueOf(this.trigger));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPbfListingsRequest)) {
            return false;
        }
        ListPbfListingsRequest other = (ListPbfListingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pbfListingId, other.pbfListingId) && Objects.equals(this.name, other.name) && Objects.equals(this.nameContains, other.nameContains) && Objects.equals(this.nameStartsWith, other.nameStartsWith) && Objects.equals(this.trigger, other.trigger) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pbfListingId == null ? 43 : this.pbfListingId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.nameContains == null ? 43 : this.nameContains.hashCode());
        result = result * 59 + (this.nameStartsWith == null ? 43 : this.nameStartsWith.hashCode());
        result = result * 59 + (this.trigger == null ? 43 : this.trigger.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPbfListingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pbfListingId = null;
        private String name = null;
        private String nameContains = null;
        private String nameStartsWith = null;
        private List<String> trigger = null;
        private PbfListing.LifecycleState lifecycleState = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder pbfListingId(String pbfListingId) {
            this.pbfListingId = pbfListingId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public Builder nameStartsWith(String nameStartsWith) {
            this.nameStartsWith = nameStartsWith;
            return this;
        }

        public Builder trigger(List<String> trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder trigger(String singularValue) {
            return this.trigger(Arrays.asList(singularValue));
        }

        public Builder lifecycleState(PbfListing.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPbfListingsRequest o) {
            this.pbfListingId(o.getPbfListingId());
            this.name(o.getName());
            this.nameContains(o.getNameContains());
            this.nameStartsWith(o.getNameStartsWith());
            this.trigger(o.getTrigger());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPbfListingsRequest build() {
            ListPbfListingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPbfListingsRequest buildWithoutInvocationCallback() {
            ListPbfListingsRequest request = new ListPbfListingsRequest();
            request.pbfListingId = this.pbfListingId;
            request.name = this.name;
            request.nameContains = this.nameContains;
            request.nameStartsWith = this.nameStartsWith;
            request.trigger = this.trigger;
            request.lifecycleState = this.lifecycleState;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

