/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.functions.model.UpdateFunctionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateFunctionRequest
extends BmcRequest<UpdateFunctionDetails> {
    private String functionId;
    private UpdateFunctionDetails updateFunctionDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getFunctionId() {
        return this.functionId;
    }

    public UpdateFunctionDetails getUpdateFunctionDetails() {
        return this.updateFunctionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateFunctionDetails getBody$() {
        return this.updateFunctionDetails;
    }

    public Builder toBuilder() {
        return new Builder().functionId(this.functionId).updateFunctionDetails(this.updateFunctionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",functionId=").append(String.valueOf(this.functionId));
        sb.append(",updateFunctionDetails=").append(String.valueOf((Object)this.updateFunctionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateFunctionRequest)) {
            return false;
        }
        UpdateFunctionRequest other = (UpdateFunctionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.functionId, other.functionId) && Objects.equals((Object)this.updateFunctionDetails, (Object)other.updateFunctionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.updateFunctionDetails == null ? 43 : this.updateFunctionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateFunctionRequest, UpdateFunctionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String functionId = null;
        private UpdateFunctionDetails updateFunctionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder updateFunctionDetails(UpdateFunctionDetails updateFunctionDetails) {
            this.updateFunctionDetails = updateFunctionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFunctionRequest o) {
            this.functionId(o.getFunctionId());
            this.updateFunctionDetails(o.getUpdateFunctionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFunctionRequest build() {
            UpdateFunctionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateFunctionDetails body) {
            this.updateFunctionDetails(body);
            return this;
        }

        public UpdateFunctionRequest buildWithoutInvocationCallback() {
            UpdateFunctionRequest request = new UpdateFunctionRequest();
            request.functionId = this.functionId;
            request.updateFunctionDetails = this.updateFunctionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

