/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EnvironmentRole
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currentRole")
    private final CurrentRole currentRole;
    @JsonProperty(value="standbyEnvironmentRegion")
    private final String standbyEnvironmentRegion;
    @JsonProperty(value="standbyEnvironmentId")
    private final String standbyEnvironmentId;

    @Deprecated
    @ConstructorProperties(value={"currentRole", "standbyEnvironmentRegion", "standbyEnvironmentId"})
    public EnvironmentRole(CurrentRole currentRole, String standbyEnvironmentRegion, String standbyEnvironmentId) {
        this.currentRole = currentRole;
        this.standbyEnvironmentRegion = standbyEnvironmentRegion;
        this.standbyEnvironmentId = standbyEnvironmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public CurrentRole getCurrentRole() {
        return this.currentRole;
    }

    public String getStandbyEnvironmentRegion() {
        return this.standbyEnvironmentRegion;
    }

    public String getStandbyEnvironmentId() {
        return this.standbyEnvironmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EnvironmentRole(");
        sb.append("super=").append(super.toString());
        sb.append("currentRole=").append(String.valueOf((Object)this.currentRole));
        sb.append(", standbyEnvironmentRegion=").append(String.valueOf(this.standbyEnvironmentRegion));
        sb.append(", standbyEnvironmentId=").append(String.valueOf(this.standbyEnvironmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnvironmentRole)) {
            return false;
        }
        EnvironmentRole other = (EnvironmentRole)((Object)o);
        return Objects.equals((Object)this.currentRole, (Object)other.currentRole) && Objects.equals(this.standbyEnvironmentRegion, other.standbyEnvironmentRegion) && Objects.equals(this.standbyEnvironmentId, other.standbyEnvironmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currentRole == null ? 43 : this.currentRole.hashCode());
        result = result * 59 + (this.standbyEnvironmentRegion == null ? 43 : this.standbyEnvironmentRegion.hashCode());
        result = result * 59 + (this.standbyEnvironmentId == null ? 43 : this.standbyEnvironmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CurrentRole implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CurrentRole> map;

        private CurrentRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CurrentRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CurrentRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CurrentRole.class);
            map = new HashMap<String, CurrentRole>();
            for (CurrentRole v : CurrentRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentRole")
        private CurrentRole currentRole;
        @JsonProperty(value="standbyEnvironmentRegion")
        private String standbyEnvironmentRegion;
        @JsonProperty(value="standbyEnvironmentId")
        private String standbyEnvironmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentRole(CurrentRole currentRole) {
            this.currentRole = currentRole;
            this.__explicitlySet__.add("currentRole");
            return this;
        }

        public Builder standbyEnvironmentRegion(String standbyEnvironmentRegion) {
            this.standbyEnvironmentRegion = standbyEnvironmentRegion;
            this.__explicitlySet__.add("standbyEnvironmentRegion");
            return this;
        }

        public Builder standbyEnvironmentId(String standbyEnvironmentId) {
            this.standbyEnvironmentId = standbyEnvironmentId;
            this.__explicitlySet__.add("standbyEnvironmentId");
            return this;
        }

        public EnvironmentRole build() {
            EnvironmentRole model = new EnvironmentRole(this.currentRole, this.standbyEnvironmentRegion, this.standbyEnvironmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EnvironmentRole model) {
            if (model.wasPropertyExplicitlySet("currentRole")) {
                this.currentRole(model.getCurrentRole());
            }
            if (model.wasPropertyExplicitlySet("standbyEnvironmentRegion")) {
                this.standbyEnvironmentRegion(model.getStandbyEnvironmentRegion());
            }
            if (model.wasPropertyExplicitlySet("standbyEnvironmentId")) {
                this.standbyEnvironmentId(model.getStandbyEnvironmentId());
            }
            return this;
        }
    }
}

