/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.EnvironmentRole;
import com.oracle.bmc.fusionapps.model.GetMaintenancePolicyDetails;
import com.oracle.bmc.fusionapps.model.RefreshDetails;
import com.oracle.bmc.fusionapps.model.Rule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FusionEnvironment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="maintenancePolicy")
    private final GetMaintenancePolicyDetails maintenancePolicy;
    @JsonProperty(value="timeUpcomingMaintenance")
    private final Date timeUpcomingMaintenance;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="fusionEnvironmentFamilyId")
    private final String fusionEnvironmentFamilyId;
    @JsonProperty(value="subscriptionIds")
    private final List<String> subscriptionIds;
    @JsonProperty(value="fusionEnvironmentType")
    private final FusionEnvironmentType fusionEnvironmentType;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyInfo")
    private final Object kmsKeyInfo;
    @JsonProperty(value="domainId")
    private final String domainId;
    @JsonProperty(value="idcsDomainUrl")
    private final String idcsDomainUrl;
    @JsonProperty(value="appliedPatchBundles")
    private final List<String> appliedPatchBundles;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="publicUrl")
    private final String publicUrl;
    @JsonProperty(value="dnsPrefix")
    private final String dnsPrefix;
    @JsonProperty(value="additionalLanguagePacks")
    private final List<String> additionalLanguagePacks;
    @JsonProperty(value="lockboxId")
    private final String lockboxId;
    @JsonProperty(value="isBreakGlassEnabled")
    private final Boolean isBreakGlassEnabled;
    @JsonProperty(value="refresh")
    private final RefreshDetails refresh;
    @JsonProperty(value="rules")
    private final List<Rule> rules;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="systemName")
    private final String systemName;
    @JsonProperty(value="environmentRole")
    private final EnvironmentRole environmentRole;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isSuspended")
    private final Boolean isSuspended;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "maintenancePolicy", "timeUpcomingMaintenance", "compartmentId", "fusionEnvironmentFamilyId", "subscriptionIds", "fusionEnvironmentType", "kmsKeyId", "kmsKeyInfo", "domainId", "idcsDomainUrl", "appliedPatchBundles", "version", "publicUrl", "dnsPrefix", "additionalLanguagePacks", "lockboxId", "isBreakGlassEnabled", "refresh", "rules", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "systemName", "environmentRole", "freeformTags", "definedTags", "isSuspended"})
    public FusionEnvironment(String id, String displayName, GetMaintenancePolicyDetails maintenancePolicy, Date timeUpcomingMaintenance, String compartmentId, String fusionEnvironmentFamilyId, List<String> subscriptionIds, FusionEnvironmentType fusionEnvironmentType, String kmsKeyId, Object kmsKeyInfo, String domainId, String idcsDomainUrl, List<String> appliedPatchBundles, String version, String publicUrl, String dnsPrefix, List<String> additionalLanguagePacks, String lockboxId, Boolean isBreakGlassEnabled, RefreshDetails refresh, List<Rule> rules, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, String systemName, EnvironmentRole environmentRole, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isSuspended) {
        this.id = id;
        this.displayName = displayName;
        this.maintenancePolicy = maintenancePolicy;
        this.timeUpcomingMaintenance = timeUpcomingMaintenance;
        this.compartmentId = compartmentId;
        this.fusionEnvironmentFamilyId = fusionEnvironmentFamilyId;
        this.subscriptionIds = subscriptionIds;
        this.fusionEnvironmentType = fusionEnvironmentType;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyInfo = kmsKeyInfo;
        this.domainId = domainId;
        this.idcsDomainUrl = idcsDomainUrl;
        this.appliedPatchBundles = appliedPatchBundles;
        this.version = version;
        this.publicUrl = publicUrl;
        this.dnsPrefix = dnsPrefix;
        this.additionalLanguagePacks = additionalLanguagePacks;
        this.lockboxId = lockboxId;
        this.isBreakGlassEnabled = isBreakGlassEnabled;
        this.refresh = refresh;
        this.rules = rules;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.systemName = systemName;
        this.environmentRole = environmentRole;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isSuspended = isSuspended;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GetMaintenancePolicyDetails getMaintenancePolicy() {
        return this.maintenancePolicy;
    }

    public Date getTimeUpcomingMaintenance() {
        return this.timeUpcomingMaintenance;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getFusionEnvironmentFamilyId() {
        return this.fusionEnvironmentFamilyId;
    }

    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public FusionEnvironmentType getFusionEnvironmentType() {
        return this.fusionEnvironmentType;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Object getKmsKeyInfo() {
        return this.kmsKeyInfo;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getIdcsDomainUrl() {
        return this.idcsDomainUrl;
    }

    public List<String> getAppliedPatchBundles() {
        return this.appliedPatchBundles;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public String getDnsPrefix() {
        return this.dnsPrefix;
    }

    public List<String> getAdditionalLanguagePacks() {
        return this.additionalLanguagePacks;
    }

    public String getLockboxId() {
        return this.lockboxId;
    }

    public Boolean getIsBreakGlassEnabled() {
        return this.isBreakGlassEnabled;
    }

    public RefreshDetails getRefresh() {
        return this.refresh;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public EnvironmentRole getEnvironmentRole() {
        return this.environmentRole;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsSuspended() {
        return this.isSuspended;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FusionEnvironment(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", maintenancePolicy=").append(String.valueOf((Object)this.maintenancePolicy));
        sb.append(", timeUpcomingMaintenance=").append(String.valueOf(this.timeUpcomingMaintenance));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", fusionEnvironmentFamilyId=").append(String.valueOf(this.fusionEnvironmentFamilyId));
        sb.append(", subscriptionIds=").append(String.valueOf(this.subscriptionIds));
        sb.append(", fusionEnvironmentType=").append(String.valueOf((Object)this.fusionEnvironmentType));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyInfo=").append(String.valueOf(this.kmsKeyInfo));
        sb.append(", domainId=").append(String.valueOf(this.domainId));
        sb.append(", idcsDomainUrl=").append(String.valueOf(this.idcsDomainUrl));
        sb.append(", appliedPatchBundles=").append(String.valueOf(this.appliedPatchBundles));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", publicUrl=").append(String.valueOf(this.publicUrl));
        sb.append(", dnsPrefix=").append(String.valueOf(this.dnsPrefix));
        sb.append(", additionalLanguagePacks=").append(String.valueOf(this.additionalLanguagePacks));
        sb.append(", lockboxId=").append(String.valueOf(this.lockboxId));
        sb.append(", isBreakGlassEnabled=").append(String.valueOf(this.isBreakGlassEnabled));
        sb.append(", refresh=").append(String.valueOf((Object)this.refresh));
        sb.append(", rules=").append(String.valueOf(this.rules));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", systemName=").append(String.valueOf(this.systemName));
        sb.append(", environmentRole=").append(String.valueOf((Object)this.environmentRole));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", isSuspended=").append(String.valueOf(this.isSuspended));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FusionEnvironment)) {
            return false;
        }
        FusionEnvironment other = (FusionEnvironment)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.maintenancePolicy, (Object)other.maintenancePolicy) && Objects.equals(this.timeUpcomingMaintenance, other.timeUpcomingMaintenance) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.fusionEnvironmentFamilyId, other.fusionEnvironmentFamilyId) && Objects.equals(this.subscriptionIds, other.subscriptionIds) && Objects.equals((Object)this.fusionEnvironmentType, (Object)other.fusionEnvironmentType) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyInfo, other.kmsKeyInfo) && Objects.equals(this.domainId, other.domainId) && Objects.equals(this.idcsDomainUrl, other.idcsDomainUrl) && Objects.equals(this.appliedPatchBundles, other.appliedPatchBundles) && Objects.equals(this.version, other.version) && Objects.equals(this.publicUrl, other.publicUrl) && Objects.equals(this.dnsPrefix, other.dnsPrefix) && Objects.equals(this.additionalLanguagePacks, other.additionalLanguagePacks) && Objects.equals(this.lockboxId, other.lockboxId) && Objects.equals(this.isBreakGlassEnabled, other.isBreakGlassEnabled) && Objects.equals((Object)this.refresh, (Object)other.refresh) && Objects.equals(this.rules, other.rules) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.systemName, other.systemName) && Objects.equals((Object)this.environmentRole, (Object)other.environmentRole) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.isSuspended, other.isSuspended) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.maintenancePolicy == null ? 43 : this.maintenancePolicy.hashCode());
        result = result * 59 + (this.timeUpcomingMaintenance == null ? 43 : this.timeUpcomingMaintenance.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.fusionEnvironmentFamilyId == null ? 43 : this.fusionEnvironmentFamilyId.hashCode());
        result = result * 59 + (this.subscriptionIds == null ? 43 : this.subscriptionIds.hashCode());
        result = result * 59 + (this.fusionEnvironmentType == null ? 43 : this.fusionEnvironmentType.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyInfo == null ? 43 : this.kmsKeyInfo.hashCode());
        result = result * 59 + (this.domainId == null ? 43 : this.domainId.hashCode());
        result = result * 59 + (this.idcsDomainUrl == null ? 43 : this.idcsDomainUrl.hashCode());
        result = result * 59 + (this.appliedPatchBundles == null ? 43 : this.appliedPatchBundles.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.publicUrl == null ? 43 : this.publicUrl.hashCode());
        result = result * 59 + (this.dnsPrefix == null ? 43 : this.dnsPrefix.hashCode());
        result = result * 59 + (this.additionalLanguagePacks == null ? 43 : this.additionalLanguagePacks.hashCode());
        result = result * 59 + (this.lockboxId == null ? 43 : this.lockboxId.hashCode());
        result = result * 59 + (this.isBreakGlassEnabled == null ? 43 : this.isBreakGlassEnabled.hashCode());
        result = result * 59 + (this.refresh == null ? 43 : this.refresh.hashCode());
        result = result * 59 + (this.rules == null ? 43 : this.rules.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.systemName == null ? 43 : this.systemName.hashCode());
        result = result * 59 + (this.environmentRole == null ? 43 : this.environmentRole.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.isSuspended == null ? 43 : this.isSuspended.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FusionEnvironmentType implements BmcEnum
    {
        Production("PRODUCTION"),
        Test("TEST"),
        Development("DEVELOPMENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FusionEnvironmentType> map;

        private FusionEnvironmentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FusionEnvironmentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FusionEnvironmentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FusionEnvironmentType.class);
            map = new HashMap<String, FusionEnvironmentType>();
            for (FusionEnvironmentType v : FusionEnvironmentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="maintenancePolicy")
        private GetMaintenancePolicyDetails maintenancePolicy;
        @JsonProperty(value="timeUpcomingMaintenance")
        private Date timeUpcomingMaintenance;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="fusionEnvironmentFamilyId")
        private String fusionEnvironmentFamilyId;
        @JsonProperty(value="subscriptionIds")
        private List<String> subscriptionIds;
        @JsonProperty(value="fusionEnvironmentType")
        private FusionEnvironmentType fusionEnvironmentType;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyInfo")
        private Object kmsKeyInfo;
        @JsonProperty(value="domainId")
        private String domainId;
        @JsonProperty(value="idcsDomainUrl")
        private String idcsDomainUrl;
        @JsonProperty(value="appliedPatchBundles")
        private List<String> appliedPatchBundles;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="publicUrl")
        private String publicUrl;
        @JsonProperty(value="dnsPrefix")
        private String dnsPrefix;
        @JsonProperty(value="additionalLanguagePacks")
        private List<String> additionalLanguagePacks;
        @JsonProperty(value="lockboxId")
        private String lockboxId;
        @JsonProperty(value="isBreakGlassEnabled")
        private Boolean isBreakGlassEnabled;
        @JsonProperty(value="refresh")
        private RefreshDetails refresh;
        @JsonProperty(value="rules")
        private List<Rule> rules;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="systemName")
        private String systemName;
        @JsonProperty(value="environmentRole")
        private EnvironmentRole environmentRole;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isSuspended")
        private Boolean isSuspended;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder maintenancePolicy(GetMaintenancePolicyDetails maintenancePolicy) {
            this.maintenancePolicy = maintenancePolicy;
            this.__explicitlySet__.add("maintenancePolicy");
            return this;
        }

        public Builder timeUpcomingMaintenance(Date timeUpcomingMaintenance) {
            this.timeUpcomingMaintenance = timeUpcomingMaintenance;
            this.__explicitlySet__.add("timeUpcomingMaintenance");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder fusionEnvironmentFamilyId(String fusionEnvironmentFamilyId) {
            this.fusionEnvironmentFamilyId = fusionEnvironmentFamilyId;
            this.__explicitlySet__.add("fusionEnvironmentFamilyId");
            return this;
        }

        public Builder subscriptionIds(List<String> subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            this.__explicitlySet__.add("subscriptionIds");
            return this;
        }

        public Builder fusionEnvironmentType(FusionEnvironmentType fusionEnvironmentType) {
            this.fusionEnvironmentType = fusionEnvironmentType;
            this.__explicitlySet__.add("fusionEnvironmentType");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyInfo(Object kmsKeyInfo) {
            this.kmsKeyInfo = kmsKeyInfo;
            this.__explicitlySet__.add("kmsKeyInfo");
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            this.__explicitlySet__.add("domainId");
            return this;
        }

        public Builder idcsDomainUrl(String idcsDomainUrl) {
            this.idcsDomainUrl = idcsDomainUrl;
            this.__explicitlySet__.add("idcsDomainUrl");
            return this;
        }

        public Builder appliedPatchBundles(List<String> appliedPatchBundles) {
            this.appliedPatchBundles = appliedPatchBundles;
            this.__explicitlySet__.add("appliedPatchBundles");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            this.__explicitlySet__.add("publicUrl");
            return this;
        }

        public Builder dnsPrefix(String dnsPrefix) {
            this.dnsPrefix = dnsPrefix;
            this.__explicitlySet__.add("dnsPrefix");
            return this;
        }

        public Builder additionalLanguagePacks(List<String> additionalLanguagePacks) {
            this.additionalLanguagePacks = additionalLanguagePacks;
            this.__explicitlySet__.add("additionalLanguagePacks");
            return this;
        }

        public Builder lockboxId(String lockboxId) {
            this.lockboxId = lockboxId;
            this.__explicitlySet__.add("lockboxId");
            return this;
        }

        public Builder isBreakGlassEnabled(Boolean isBreakGlassEnabled) {
            this.isBreakGlassEnabled = isBreakGlassEnabled;
            this.__explicitlySet__.add("isBreakGlassEnabled");
            return this;
        }

        public Builder refresh(RefreshDetails refresh) {
            this.refresh = refresh;
            this.__explicitlySet__.add("refresh");
            return this;
        }

        public Builder rules(List<Rule> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder systemName(String systemName) {
            this.systemName = systemName;
            this.__explicitlySet__.add("systemName");
            return this;
        }

        public Builder environmentRole(EnvironmentRole environmentRole) {
            this.environmentRole = environmentRole;
            this.__explicitlySet__.add("environmentRole");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isSuspended(Boolean isSuspended) {
            this.isSuspended = isSuspended;
            this.__explicitlySet__.add("isSuspended");
            return this;
        }

        public FusionEnvironment build() {
            FusionEnvironment model = new FusionEnvironment(this.id, this.displayName, this.maintenancePolicy, this.timeUpcomingMaintenance, this.compartmentId, this.fusionEnvironmentFamilyId, this.subscriptionIds, this.fusionEnvironmentType, this.kmsKeyId, this.kmsKeyInfo, this.domainId, this.idcsDomainUrl, this.appliedPatchBundles, this.version, this.publicUrl, this.dnsPrefix, this.additionalLanguagePacks, this.lockboxId, this.isBreakGlassEnabled, this.refresh, this.rules, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.systemName, this.environmentRole, this.freeformTags, this.definedTags, this.isSuspended);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FusionEnvironment model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("maintenancePolicy")) {
                this.maintenancePolicy(model.getMaintenancePolicy());
            }
            if (model.wasPropertyExplicitlySet("timeUpcomingMaintenance")) {
                this.timeUpcomingMaintenance(model.getTimeUpcomingMaintenance());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("fusionEnvironmentFamilyId")) {
                this.fusionEnvironmentFamilyId(model.getFusionEnvironmentFamilyId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionIds")) {
                this.subscriptionIds(model.getSubscriptionIds());
            }
            if (model.wasPropertyExplicitlySet("fusionEnvironmentType")) {
                this.fusionEnvironmentType(model.getFusionEnvironmentType());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyInfo")) {
                this.kmsKeyInfo(model.getKmsKeyInfo());
            }
            if (model.wasPropertyExplicitlySet("domainId")) {
                this.domainId(model.getDomainId());
            }
            if (model.wasPropertyExplicitlySet("idcsDomainUrl")) {
                this.idcsDomainUrl(model.getIdcsDomainUrl());
            }
            if (model.wasPropertyExplicitlySet("appliedPatchBundles")) {
                this.appliedPatchBundles(model.getAppliedPatchBundles());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("publicUrl")) {
                this.publicUrl(model.getPublicUrl());
            }
            if (model.wasPropertyExplicitlySet("dnsPrefix")) {
                this.dnsPrefix(model.getDnsPrefix());
            }
            if (model.wasPropertyExplicitlySet("additionalLanguagePacks")) {
                this.additionalLanguagePacks(model.getAdditionalLanguagePacks());
            }
            if (model.wasPropertyExplicitlySet("lockboxId")) {
                this.lockboxId(model.getLockboxId());
            }
            if (model.wasPropertyExplicitlySet("isBreakGlassEnabled")) {
                this.isBreakGlassEnabled(model.getIsBreakGlassEnabled());
            }
            if (model.wasPropertyExplicitlySet("refresh")) {
                this.refresh(model.getRefresh());
            }
            if (model.wasPropertyExplicitlySet("rules")) {
                this.rules(model.getRules());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("systemName")) {
                this.systemName(model.getSystemName());
            }
            if (model.wasPropertyExplicitlySet("environmentRole")) {
                this.environmentRole(model.getEnvironmentRole());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("isSuspended")) {
                this.isSuspended(model.getIsSuspended());
            }
            return this;
        }
    }
}

