/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.SubscriptionSku;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Subscription
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="classicSubscriptionId")
    private final String classicSubscriptionId;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;
    @JsonProperty(value="skus")
    private final List<SubscriptionSku> skus;

    @Deprecated
    @ConstructorProperties(value={"id", "classicSubscriptionId", "serviceName", "lifecycleState", "lifecycleDetails", "skus"})
    public Subscription(String id, String classicSubscriptionId, String serviceName, LifecycleState lifecycleState, LifecycleDetails lifecycleDetails, List<SubscriptionSku> skus) {
        this.id = id;
        this.classicSubscriptionId = classicSubscriptionId;
        this.serviceName = serviceName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.skus = skus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getClassicSubscriptionId() {
        return this.classicSubscriptionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<SubscriptionSku> getSkus() {
        return this.skus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Subscription(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", classicSubscriptionId=").append(String.valueOf(this.classicSubscriptionId));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(", skus=").append(String.valueOf(this.skus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.classicSubscriptionId, other.classicSubscriptionId) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && Objects.equals(this.skus, other.skus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.classicSubscriptionId == null ? 43 : this.classicSubscriptionId.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.skus == null ? 43 : this.skus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleDetails implements BmcEnum
    {
        Active("ACTIVE"),
        Purged("PURGED"),
        Canceled("CANCELED"),
        PaidPurged("PAID_PURGED"),
        Initialized("INITIALIZED"),
        SoftTerminated("SOFT_TERMINATED"),
        Disabled("DISABLED"),
        BeginTermination("BEGIN_TERMINATION"),
        Migrated("MIGRATED"),
        PendingCancelation("PENDING_CANCELATION"),
        Archived("ARCHIVED"),
        NonRecoverable("NON_RECOVERABLE"),
        BeginSoftTermination("BEGIN_SOFT_TERMINATION"),
        Activated("ACTIVATED"),
        AccessDisabled("ACCESS_DISABLED"),
        PendingRegistration("PENDING_REGISTRATION"),
        Terminated("TERMINATED"),
        Relocating("RELOCATING"),
        Deprovisioned("DEPROVISIONED"),
        Provisioned("PROVISIONED"),
        BeginTerminationPassive("BEGIN_TERMINATION_PASSIVE"),
        Locked("LOCKED"),
        PendingDeprovisioning("PENDING_DEPROVISIONING"),
        Registered("REGISTERED"),
        Cancelled("CANCELLED"),
        Expired("EXPIRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleDetails> map;

        private LifecycleDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleDetails.class);
            map = new HashMap<String, LifecycleDetails>();
            for (LifecycleDetails v : LifecycleDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="classicSubscriptionId")
        private String classicSubscriptionId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private LifecycleDetails lifecycleDetails;
        @JsonProperty(value="skus")
        private List<SubscriptionSku> skus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder classicSubscriptionId(String classicSubscriptionId) {
            this.classicSubscriptionId = classicSubscriptionId;
            this.__explicitlySet__.add("classicSubscriptionId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder skus(List<SubscriptionSku> skus) {
            this.skus = skus;
            this.__explicitlySet__.add("skus");
            return this;
        }

        public Subscription build() {
            Subscription model = new Subscription(this.id, this.classicSubscriptionId, this.serviceName, this.lifecycleState, this.lifecycleDetails, this.skus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Subscription model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("classicSubscriptionId")) {
                this.classicSubscriptionId(model.getClassicSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("skus")) {
                this.skus(model.getSkus());
            }
            return this;
        }
    }
}

