/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateExtractDetailsRequest
extends BmcRequest<Void> {
    private String fusionEnvironmentId;
    private String opcRequestId;

    public String getFusionEnvironmentId() {
        return this.fusionEnvironmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fusionEnvironmentId(this.fusionEnvironmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fusionEnvironmentId=").append(String.valueOf(this.fusionEnvironmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateExtractDetailsRequest)) {
            return false;
        }
        GenerateExtractDetailsRequest other = (GenerateExtractDetailsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fusionEnvironmentId, other.fusionEnvironmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fusionEnvironmentId == null ? 43 : this.fusionEnvironmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateExtractDetailsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fusionEnvironmentId = null;
        private String opcRequestId = null;

        public Builder fusionEnvironmentId(String fusionEnvironmentId) {
            this.fusionEnvironmentId = fusionEnvironmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateExtractDetailsRequest o) {
            this.fusionEnvironmentId(o.getFusionEnvironmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateExtractDetailsRequest build() {
            GenerateExtractDetailsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GenerateExtractDetailsRequest buildWithoutInvocationCallback() {
            GenerateExtractDetailsRequest request = new GenerateExtractDetailsRequest();
            request.fusionEnvironmentId = this.fusionEnvironmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

