/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps;

import com.oracle.bmc.fusionapps.FusionApplications;
import com.oracle.bmc.fusionapps.model.DataMaskingActivity;
import com.oracle.bmc.fusionapps.model.FusionEnvironment;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentFamily;
import com.oracle.bmc.fusionapps.model.RefreshActivity;
import com.oracle.bmc.fusionapps.model.ScheduledActivity;
import com.oracle.bmc.fusionapps.model.ServiceAttachment;
import com.oracle.bmc.fusionapps.requests.GetDataMaskingActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentFamilyRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentRequest;
import com.oracle.bmc.fusionapps.requests.GetRefreshActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetScheduledActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetServiceAttachmentRequest;
import com.oracle.bmc.fusionapps.requests.GetWorkRequestRequest;
import com.oracle.bmc.fusionapps.responses.GetDataMaskingActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentFamilyResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentResponse;
import com.oracle.bmc.fusionapps.responses.GetRefreshActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetScheduledActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetServiceAttachmentResponse;
import com.oracle.bmc.fusionapps.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FusionApplicationsWaiters {
    private final ExecutorService executorService;
    private final FusionApplications client;

    public FusionApplicationsWaiters(ExecutorService executorService, FusionApplications client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse> forDataMaskingActivity(GetDataMaskingActivityRequest request, DataMaskingActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataMaskingActivity(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse> forDataMaskingActivity(GetDataMaskingActivityRequest request, DataMaskingActivity.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataMaskingActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse> forDataMaskingActivity(GetDataMaskingActivityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataMaskingActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataMaskingActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse> forDataMaskingActivity(BmcGenericWaiter waiter, GetDataMaskingActivityRequest request, DataMaskingActivity.LifecycleState ... targetStates) {
        final HashSet<DataMaskingActivity.LifecycleState> targetStatesSet = new HashSet<DataMaskingActivity.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse>(){

            @Override
            public GetDataMaskingActivityResponse apply(GetDataMaskingActivityRequest request) {
                return FusionApplicationsWaiters.this.client.getDataMaskingActivity(request);
            }
        }, (Predicate)new Predicate<GetDataMaskingActivityResponse>(){

            @Override
            public boolean test(GetDataMaskingActivityResponse response) {
                return targetStatesSet.contains((Object)response.getDataMaskingActivity().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse> forFusionEnvironment(GetFusionEnvironmentRequest request, FusionEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFusionEnvironment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse> forFusionEnvironment(GetFusionEnvironmentRequest request, FusionEnvironment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFusionEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse> forFusionEnvironment(GetFusionEnvironmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FusionEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFusionEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse> forFusionEnvironment(BmcGenericWaiter waiter, GetFusionEnvironmentRequest request, FusionEnvironment.LifecycleState ... targetStates) {
        final HashSet<FusionEnvironment.LifecycleState> targetStatesSet = new HashSet<FusionEnvironment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse>(){

            @Override
            public GetFusionEnvironmentResponse apply(GetFusionEnvironmentRequest request) {
                return FusionApplicationsWaiters.this.client.getFusionEnvironment(request);
            }
        }, (Predicate)new Predicate<GetFusionEnvironmentResponse>(){

            @Override
            public boolean test(GetFusionEnvironmentResponse response) {
                return targetStatesSet.contains((Object)response.getFusionEnvironment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FusionEnvironment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse> forFusionEnvironmentFamily(GetFusionEnvironmentFamilyRequest request, FusionEnvironmentFamily.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFusionEnvironmentFamily(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse> forFusionEnvironmentFamily(GetFusionEnvironmentFamilyRequest request, FusionEnvironmentFamily.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFusionEnvironmentFamily(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse> forFusionEnvironmentFamily(GetFusionEnvironmentFamilyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FusionEnvironmentFamily.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFusionEnvironmentFamily(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse> forFusionEnvironmentFamily(BmcGenericWaiter waiter, GetFusionEnvironmentFamilyRequest request, FusionEnvironmentFamily.LifecycleState ... targetStates) {
        final HashSet<FusionEnvironmentFamily.LifecycleState> targetStatesSet = new HashSet<FusionEnvironmentFamily.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse>(){

            @Override
            public GetFusionEnvironmentFamilyResponse apply(GetFusionEnvironmentFamilyRequest request) {
                return FusionApplicationsWaiters.this.client.getFusionEnvironmentFamily(request);
            }
        }, (Predicate)new Predicate<GetFusionEnvironmentFamilyResponse>(){

            @Override
            public boolean test(GetFusionEnvironmentFamilyResponse response) {
                return targetStatesSet.contains((Object)response.getFusionEnvironmentFamily().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FusionEnvironmentFamily.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRefreshActivityRequest, GetRefreshActivityResponse> forRefreshActivity(GetRefreshActivityRequest request, RefreshActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRefreshActivity(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRefreshActivityRequest, GetRefreshActivityResponse> forRefreshActivity(GetRefreshActivityRequest request, RefreshActivity.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRefreshActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRefreshActivityRequest, GetRefreshActivityResponse> forRefreshActivity(GetRefreshActivityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RefreshActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRefreshActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRefreshActivityRequest, GetRefreshActivityResponse> forRefreshActivity(BmcGenericWaiter waiter, GetRefreshActivityRequest request, RefreshActivity.LifecycleState ... targetStates) {
        final HashSet<RefreshActivity.LifecycleState> targetStatesSet = new HashSet<RefreshActivity.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRefreshActivityRequest, GetRefreshActivityResponse>(){

            @Override
            public GetRefreshActivityResponse apply(GetRefreshActivityRequest request) {
                return FusionApplicationsWaiters.this.client.getRefreshActivity(request);
            }
        }, (Predicate)new Predicate<GetRefreshActivityResponse>(){

            @Override
            public boolean test(GetRefreshActivityResponse response) {
                return targetStatesSet.contains((Object)response.getRefreshActivity().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetScheduledActivityRequest, GetScheduledActivityResponse> forScheduledActivity(GetScheduledActivityRequest request, ScheduledActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledActivity(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduledActivityRequest, GetScheduledActivityResponse> forScheduledActivity(GetScheduledActivityRequest request, ScheduledActivity.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forScheduledActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduledActivityRequest, GetScheduledActivityResponse> forScheduledActivity(GetScheduledActivityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ScheduledActivity.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forScheduledActivity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduledActivityRequest, GetScheduledActivityResponse> forScheduledActivity(BmcGenericWaiter waiter, GetScheduledActivityRequest request, ScheduledActivity.LifecycleState ... targetStates) {
        final HashSet<ScheduledActivity.LifecycleState> targetStatesSet = new HashSet<ScheduledActivity.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetScheduledActivityRequest, GetScheduledActivityResponse>(){

            @Override
            public GetScheduledActivityResponse apply(GetScheduledActivityRequest request) {
                return FusionApplicationsWaiters.this.client.getScheduledActivity(request);
            }
        }, (Predicate)new Predicate<GetScheduledActivityResponse>(){

            @Override
            public boolean test(GetScheduledActivityResponse response) {
                return targetStatesSet.contains((Object)response.getScheduledActivity().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetServiceAttachmentRequest, GetServiceAttachmentResponse> forServiceAttachment(GetServiceAttachmentRequest request, ServiceAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forServiceAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetServiceAttachmentRequest, GetServiceAttachmentResponse> forServiceAttachment(GetServiceAttachmentRequest request, ServiceAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forServiceAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetServiceAttachmentRequest, GetServiceAttachmentResponse> forServiceAttachment(GetServiceAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ServiceAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forServiceAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetServiceAttachmentRequest, GetServiceAttachmentResponse> forServiceAttachment(BmcGenericWaiter waiter, GetServiceAttachmentRequest request, ServiceAttachment.LifecycleState ... targetStates) {
        final HashSet<ServiceAttachment.LifecycleState> targetStatesSet = new HashSet<ServiceAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetServiceAttachmentRequest, GetServiceAttachmentResponse>(){

            @Override
            public GetServiceAttachmentResponse apply(GetServiceAttachmentRequest request) {
                return FusionApplicationsWaiters.this.client.getServiceAttachment(request);
            }
        }, (Predicate)new Predicate<GetServiceAttachmentResponse>(){

            @Override
            public boolean test(GetServiceAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getServiceAttachment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ServiceAttachment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return FusionApplicationsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

