/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.FamilyMaintenancePolicy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FusionEnvironmentFamily
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="familyMaintenancePolicy")
    private final FamilyMaintenancePolicy familyMaintenancePolicy;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="subscriptionIds")
    private final List<String> subscriptionIds;
    @JsonProperty(value="isSubscriptionUpdateNeeded")
    private final Boolean isSubscriptionUpdateNeeded;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="systemName")
    private final String systemName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="timeLastSubscriptionUpdate")
    private final Date timeLastSubscriptionUpdate;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "familyMaintenancePolicy", "compartmentId", "subscriptionIds", "isSubscriptionUpdateNeeded", "timeCreated", "lifecycleState", "lifecycleDetails", "systemName", "freeformTags", "definedTags", "timeLastSubscriptionUpdate"})
    public FusionEnvironmentFamily(String id, String displayName, FamilyMaintenancePolicy familyMaintenancePolicy, String compartmentId, List<String> subscriptionIds, Boolean isSubscriptionUpdateNeeded, Date timeCreated, LifecycleState lifecycleState, String lifecycleDetails, String systemName, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Date timeLastSubscriptionUpdate) {
        this.id = id;
        this.displayName = displayName;
        this.familyMaintenancePolicy = familyMaintenancePolicy;
        this.compartmentId = compartmentId;
        this.subscriptionIds = subscriptionIds;
        this.isSubscriptionUpdateNeeded = isSubscriptionUpdateNeeded;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.systemName = systemName;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.timeLastSubscriptionUpdate = timeLastSubscriptionUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FamilyMaintenancePolicy getFamilyMaintenancePolicy() {
        return this.familyMaintenancePolicy;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public Boolean getIsSubscriptionUpdateNeeded() {
        return this.isSubscriptionUpdateNeeded;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Date getTimeLastSubscriptionUpdate() {
        return this.timeLastSubscriptionUpdate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FusionEnvironmentFamily(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", familyMaintenancePolicy=").append(String.valueOf((Object)this.familyMaintenancePolicy));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", subscriptionIds=").append(String.valueOf(this.subscriptionIds));
        sb.append(", isSubscriptionUpdateNeeded=").append(String.valueOf(this.isSubscriptionUpdateNeeded));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", systemName=").append(String.valueOf(this.systemName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", timeLastSubscriptionUpdate=").append(String.valueOf(this.timeLastSubscriptionUpdate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FusionEnvironmentFamily)) {
            return false;
        }
        FusionEnvironmentFamily other = (FusionEnvironmentFamily)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.familyMaintenancePolicy, (Object)other.familyMaintenancePolicy) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionIds, other.subscriptionIds) && Objects.equals(this.isSubscriptionUpdateNeeded, other.isSubscriptionUpdateNeeded) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.systemName, other.systemName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.timeLastSubscriptionUpdate, other.timeLastSubscriptionUpdate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.familyMaintenancePolicy == null ? 43 : this.familyMaintenancePolicy.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionIds == null ? 43 : this.subscriptionIds.hashCode());
        result = result * 59 + (this.isSubscriptionUpdateNeeded == null ? 43 : this.isSubscriptionUpdateNeeded.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.systemName == null ? 43 : this.systemName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.timeLastSubscriptionUpdate == null ? 43 : this.timeLastSubscriptionUpdate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="familyMaintenancePolicy")
        private FamilyMaintenancePolicy familyMaintenancePolicy;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="subscriptionIds")
        private List<String> subscriptionIds;
        @JsonProperty(value="isSubscriptionUpdateNeeded")
        private Boolean isSubscriptionUpdateNeeded;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="systemName")
        private String systemName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="timeLastSubscriptionUpdate")
        private Date timeLastSubscriptionUpdate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder familyMaintenancePolicy(FamilyMaintenancePolicy familyMaintenancePolicy) {
            this.familyMaintenancePolicy = familyMaintenancePolicy;
            this.__explicitlySet__.add("familyMaintenancePolicy");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder subscriptionIds(List<String> subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            this.__explicitlySet__.add("subscriptionIds");
            return this;
        }

        public Builder isSubscriptionUpdateNeeded(Boolean isSubscriptionUpdateNeeded) {
            this.isSubscriptionUpdateNeeded = isSubscriptionUpdateNeeded;
            this.__explicitlySet__.add("isSubscriptionUpdateNeeded");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder systemName(String systemName) {
            this.systemName = systemName;
            this.__explicitlySet__.add("systemName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder timeLastSubscriptionUpdate(Date timeLastSubscriptionUpdate) {
            this.timeLastSubscriptionUpdate = timeLastSubscriptionUpdate;
            this.__explicitlySet__.add("timeLastSubscriptionUpdate");
            return this;
        }

        public FusionEnvironmentFamily build() {
            FusionEnvironmentFamily model = new FusionEnvironmentFamily(this.id, this.displayName, this.familyMaintenancePolicy, this.compartmentId, this.subscriptionIds, this.isSubscriptionUpdateNeeded, this.timeCreated, this.lifecycleState, this.lifecycleDetails, this.systemName, this.freeformTags, this.definedTags, this.timeLastSubscriptionUpdate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FusionEnvironmentFamily model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("familyMaintenancePolicy")) {
                this.familyMaintenancePolicy(model.getFamilyMaintenancePolicy());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionIds")) {
                this.subscriptionIds(model.getSubscriptionIds());
            }
            if (model.wasPropertyExplicitlySet("isSubscriptionUpdateNeeded")) {
                this.isSubscriptionUpdateNeeded(model.getIsSubscriptionUpdateNeeded());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("systemName")) {
                this.systemName(model.getSystemName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("timeLastSubscriptionUpdate")) {
                this.timeLastSubscriptionUpdate(model.getTimeLastSubscriptionUpdate());
            }
            return this;
        }
    }
}

