/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaintenancePolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="monthlyPatchingOverride")
    private final MonthlyPatchingOverride monthlyPatchingOverride;
    @JsonProperty(value="environmentMaintenanceOverride")
    private final EnvironmentMaintenanceOverride environmentMaintenanceOverride;

    @Deprecated
    @ConstructorProperties(value={"monthlyPatchingOverride", "environmentMaintenanceOverride"})
    public MaintenancePolicy(MonthlyPatchingOverride monthlyPatchingOverride, EnvironmentMaintenanceOverride environmentMaintenanceOverride) {
        this.monthlyPatchingOverride = monthlyPatchingOverride;
        this.environmentMaintenanceOverride = environmentMaintenanceOverride;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MonthlyPatchingOverride getMonthlyPatchingOverride() {
        return this.monthlyPatchingOverride;
    }

    public EnvironmentMaintenanceOverride getEnvironmentMaintenanceOverride() {
        return this.environmentMaintenanceOverride;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaintenancePolicy(");
        sb.append("super=").append(super.toString());
        sb.append("monthlyPatchingOverride=").append(String.valueOf((Object)this.monthlyPatchingOverride));
        sb.append(", environmentMaintenanceOverride=").append(String.valueOf((Object)this.environmentMaintenanceOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenancePolicy)) {
            return false;
        }
        MaintenancePolicy other = (MaintenancePolicy)((Object)o);
        return Objects.equals((Object)this.monthlyPatchingOverride, (Object)other.monthlyPatchingOverride) && Objects.equals((Object)this.environmentMaintenanceOverride, (Object)other.environmentMaintenanceOverride) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.monthlyPatchingOverride == null ? 43 : this.monthlyPatchingOverride.hashCode());
        result = result * 59 + (this.environmentMaintenanceOverride == null ? 43 : this.environmentMaintenanceOverride.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EnvironmentMaintenanceOverride implements BmcEnum
    {
        Prod("PROD"),
        NonProd("NON_PROD"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnvironmentMaintenanceOverride> map;

        private EnvironmentMaintenanceOverride(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnvironmentMaintenanceOverride create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnvironmentMaintenanceOverride', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnvironmentMaintenanceOverride.class);
            map = new HashMap<String, EnvironmentMaintenanceOverride>();
            for (EnvironmentMaintenanceOverride v : EnvironmentMaintenanceOverride.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MonthlyPatchingOverride implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MonthlyPatchingOverride> map;

        private MonthlyPatchingOverride(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MonthlyPatchingOverride create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MonthlyPatchingOverride', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MonthlyPatchingOverride.class);
            map = new HashMap<String, MonthlyPatchingOverride>();
            for (MonthlyPatchingOverride v : MonthlyPatchingOverride.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="monthlyPatchingOverride")
        private MonthlyPatchingOverride monthlyPatchingOverride;
        @JsonProperty(value="environmentMaintenanceOverride")
        private EnvironmentMaintenanceOverride environmentMaintenanceOverride;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder monthlyPatchingOverride(MonthlyPatchingOverride monthlyPatchingOverride) {
            this.monthlyPatchingOverride = monthlyPatchingOverride;
            this.__explicitlySet__.add("monthlyPatchingOverride");
            return this;
        }

        public Builder environmentMaintenanceOverride(EnvironmentMaintenanceOverride environmentMaintenanceOverride) {
            this.environmentMaintenanceOverride = environmentMaintenanceOverride;
            this.__explicitlySet__.add("environmentMaintenanceOverride");
            return this;
        }

        public MaintenancePolicy build() {
            MaintenancePolicy model = new MaintenancePolicy(this.monthlyPatchingOverride, this.environmentMaintenanceOverride);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaintenancePolicy model) {
            if (model.wasPropertyExplicitlySet("monthlyPatchingOverride")) {
                this.monthlyPatchingOverride(model.getMonthlyPatchingOverride());
            }
            if (model.wasPropertyExplicitlySet("environmentMaintenanceOverride")) {
                this.environmentMaintenanceOverride(model.getEnvironmentMaintenanceOverride());
            }
            return this;
        }
    }
}

