/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.Action;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType")
@JsonFilter(value="explicitlySetFilter")
public final class PatchAction
extends Action {
    @JsonProperty(value="mode")
    private final Mode mode;
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="artifact")
    private final String artifact;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PatchAction(String referenceKey, Action.State state, String description, Mode mode, Category category, String artifact) {
        super(referenceKey, state, description);
        this.mode = mode;
        this.category = category;
        this.artifact = artifact;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getArtifact() {
        return this.artifact;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mode=").append(String.valueOf((Object)this.mode));
        sb.append(", category=").append(String.valueOf((Object)this.category));
        sb.append(", artifact=").append(String.valueOf(this.artifact));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchAction)) {
            return false;
        }
        PatchAction other = (PatchAction)((Object)o);
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.artifact, other.artifact) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.artifact == null ? 43 : this.artifact.hashCode());
        return result;
    }

    public static enum Category implements BmcEnum
    {
        Monthly("MONTHLY"),
        Weekly("WEEKLY"),
        Oneoff("ONEOFF"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Mode implements BmcEnum
    {
        Hot("HOT"),
        Cold("COLD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Mode> map;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Mode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Mode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Mode.class);
            map = new HashMap<String, Mode>();
            for (Mode v : Mode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="referenceKey")
        private String referenceKey;
        @JsonProperty(value="state")
        private Action.State state;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="mode")
        private Mode mode;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="artifact")
        private String artifact;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            this.__explicitlySet__.add("referenceKey");
            return this;
        }

        public Builder state(Action.State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder artifact(String artifact) {
            this.artifact = artifact;
            this.__explicitlySet__.add("artifact");
            return this;
        }

        public PatchAction build() {
            PatchAction model = new PatchAction(this.referenceKey, this.state, this.description, this.mode, this.category, this.artifact);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchAction model) {
            if (model.wasPropertyExplicitlySet("referenceKey")) {
                this.referenceKey(model.getReferenceKey());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("artifact")) {
                this.artifact(model.getArtifact());
            }
            return this;
        }
    }
}

