/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.generativeai.GenerativeAiAsync;
import com.oracle.bmc.generativeai.model.DedicatedAiCluster;
import com.oracle.bmc.generativeai.model.DedicatedAiClusterCollection;
import com.oracle.bmc.generativeai.model.Endpoint;
import com.oracle.bmc.generativeai.model.EndpointCollection;
import com.oracle.bmc.generativeai.model.Model;
import com.oracle.bmc.generativeai.model.ModelCollection;
import com.oracle.bmc.generativeai.model.WorkRequest;
import com.oracle.bmc.generativeai.model.WorkRequestErrorCollection;
import com.oracle.bmc.generativeai.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.generativeai.model.WorkRequestSummaryCollection;
import com.oracle.bmc.generativeai.requests.ChangeDedicatedAiClusterCompartmentRequest;
import com.oracle.bmc.generativeai.requests.ChangeEndpointCompartmentRequest;
import com.oracle.bmc.generativeai.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.generativeai.requests.CreateDedicatedAiClusterRequest;
import com.oracle.bmc.generativeai.requests.CreateEndpointRequest;
import com.oracle.bmc.generativeai.requests.CreateModelRequest;
import com.oracle.bmc.generativeai.requests.DeleteDedicatedAiClusterRequest;
import com.oracle.bmc.generativeai.requests.DeleteEndpointRequest;
import com.oracle.bmc.generativeai.requests.DeleteModelRequest;
import com.oracle.bmc.generativeai.requests.GetDedicatedAiClusterRequest;
import com.oracle.bmc.generativeai.requests.GetEndpointRequest;
import com.oracle.bmc.generativeai.requests.GetModelRequest;
import com.oracle.bmc.generativeai.requests.GetWorkRequestRequest;
import com.oracle.bmc.generativeai.requests.ListDedicatedAiClustersRequest;
import com.oracle.bmc.generativeai.requests.ListEndpointsRequest;
import com.oracle.bmc.generativeai.requests.ListModelsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestsRequest;
import com.oracle.bmc.generativeai.requests.UpdateDedicatedAiClusterRequest;
import com.oracle.bmc.generativeai.requests.UpdateEndpointRequest;
import com.oracle.bmc.generativeai.requests.UpdateModelRequest;
import com.oracle.bmc.generativeai.responses.ChangeDedicatedAiClusterCompartmentResponse;
import com.oracle.bmc.generativeai.responses.ChangeEndpointCompartmentResponse;
import com.oracle.bmc.generativeai.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.generativeai.responses.CreateDedicatedAiClusterResponse;
import com.oracle.bmc.generativeai.responses.CreateEndpointResponse;
import com.oracle.bmc.generativeai.responses.CreateModelResponse;
import com.oracle.bmc.generativeai.responses.DeleteDedicatedAiClusterResponse;
import com.oracle.bmc.generativeai.responses.DeleteEndpointResponse;
import com.oracle.bmc.generativeai.responses.DeleteModelResponse;
import com.oracle.bmc.generativeai.responses.GetDedicatedAiClusterResponse;
import com.oracle.bmc.generativeai.responses.GetEndpointResponse;
import com.oracle.bmc.generativeai.responses.GetModelResponse;
import com.oracle.bmc.generativeai.responses.GetWorkRequestResponse;
import com.oracle.bmc.generativeai.responses.ListDedicatedAiClustersResponse;
import com.oracle.bmc.generativeai.responses.ListEndpointsResponse;
import com.oracle.bmc.generativeai.responses.ListModelsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestsResponse;
import com.oracle.bmc.generativeai.responses.UpdateDedicatedAiClusterResponse;
import com.oracle.bmc.generativeai.responses.UpdateEndpointResponse;
import com.oracle.bmc.generativeai.responses.UpdateModelResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerativeAiAsyncClient
extends BaseAsyncClient
implements GenerativeAiAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GENERATIVEAI").serviceEndpointPrefix("").serviceEndpointTemplate("https://generativeai.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GenerativeAiAsyncClient.class);

    GenerativeAiAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeDedicatedAiClusterCompartmentResponse> changeDedicatedAiClusterCompartment(ChangeDedicatedAiClusterCompartmentRequest request, AsyncHandler<ChangeDedicatedAiClusterCompartmentRequest, ChangeDedicatedAiClusterCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDedicatedAiClusterId(), (String)"dedicatedAiClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDedicatedAiClusterCompartmentDetails(), "changeDedicatedAiClusterCompartmentDetails is required");
        return this.clientCall(request, ChangeDedicatedAiClusterCompartmentResponse::builder).logger(LOG, "changeDedicatedAiClusterCompartment").serviceDetails("GenerativeAi", "ChangeDedicatedAiClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiCluster/ChangeDedicatedAiClusterCompartment").method(Method.POST).requestBuilder(ChangeDedicatedAiClusterCompartmentRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").appendPathParam(request.getDedicatedAiClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDedicatedAiClusterCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeEndpointCompartmentResponse> changeEndpointCompartment(ChangeEndpointCompartmentRequest request, AsyncHandler<ChangeEndpointCompartmentRequest, ChangeEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEndpointCompartmentDetails(), "changeEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangeEndpointCompartmentResponse::builder).logger(LOG, "changeEndpointCompartment").serviceDetails("GenerativeAi", "ChangeEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Endpoint/ChangeEndpointCompartment").method(Method.POST).requestBuilder(ChangeEndpointCompartmentRequest::builder).basePath("/20231130").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeEndpointCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("GenerativeAi", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20231130").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDedicatedAiClusterResponse> createDedicatedAiCluster(CreateDedicatedAiClusterRequest request, AsyncHandler<CreateDedicatedAiClusterRequest, CreateDedicatedAiClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateDedicatedAiClusterDetails(), "createDedicatedAiClusterDetails is required");
        return this.clientCall(request, CreateDedicatedAiClusterResponse::builder).logger(LOG, "createDedicatedAiCluster").serviceDetails("GenerativeAi", "CreateDedicatedAiCluster", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiCluster/CreateDedicatedAiCluster").method(Method.POST).requestBuilder(CreateDedicatedAiClusterRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DedicatedAiCluster.class, CreateDedicatedAiClusterResponse.Builder::dedicatedAiCluster).handleResponseHeaderString("etag", CreateDedicatedAiClusterResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDedicatedAiClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDedicatedAiClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEndpointResponse> createEndpoint(CreateEndpointRequest request, AsyncHandler<CreateEndpointRequest, CreateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateEndpointDetails(), "createEndpointDetails is required");
        return this.clientCall(request, CreateEndpointResponse::builder).logger(LOG, "createEndpoint").serviceDetails("GenerativeAi", "CreateEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Endpoint/CreateEndpoint").method(Method.POST).requestBuilder(CreateEndpointRequest::builder).basePath("/20231130").appendPathParam("endpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Endpoint.class, CreateEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", CreateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("GenerativeAi", "CreateModel", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Model/CreateModel").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20231130").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDedicatedAiClusterResponse> deleteDedicatedAiCluster(DeleteDedicatedAiClusterRequest request, AsyncHandler<DeleteDedicatedAiClusterRequest, DeleteDedicatedAiClusterResponse> handler) {
        Validate.notBlank((String)request.getDedicatedAiClusterId(), (String)"dedicatedAiClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDedicatedAiClusterResponse::builder).logger(LOG, "deleteDedicatedAiCluster").serviceDetails("GenerativeAi", "DeleteDedicatedAiCluster", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiCluster/DeleteDedicatedAiCluster").method(Method.DELETE).requestBuilder(DeleteDedicatedAiClusterRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").appendPathParam(request.getDedicatedAiClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDedicatedAiClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDedicatedAiClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest request, AsyncHandler<DeleteEndpointRequest, DeleteEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEndpointResponse::builder).logger(LOG, "deleteEndpoint").serviceDetails("GenerativeAi", "DeleteEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Endpoint/DeleteEndpoint").method(Method.DELETE).requestBuilder(DeleteEndpointRequest::builder).basePath("/20231130").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("GenerativeAi", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20231130").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDedicatedAiClusterResponse> getDedicatedAiCluster(GetDedicatedAiClusterRequest request, AsyncHandler<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse> handler) {
        Validate.notBlank((String)request.getDedicatedAiClusterId(), (String)"dedicatedAiClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDedicatedAiClusterResponse::builder).logger(LOG, "getDedicatedAiCluster").serviceDetails("GenerativeAi", "GetDedicatedAiCluster", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiCluster/GetDedicatedAiCluster").method(Method.GET).requestBuilder(GetDedicatedAiClusterRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").appendPathParam(request.getDedicatedAiClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedAiCluster.class, GetDedicatedAiClusterResponse.Builder::dedicatedAiCluster).handleResponseHeaderString("etag", GetDedicatedAiClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDedicatedAiClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEndpointResponse> getEndpoint(GetEndpointRequest request, AsyncHandler<GetEndpointRequest, GetEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEndpointResponse::builder).logger(LOG, "getEndpoint").serviceDetails("GenerativeAi", "GetEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Endpoint/GetEndpoint").method(Method.GET).requestBuilder(GetEndpointRequest::builder).basePath("/20231130").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Endpoint.class, GetEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", GetEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("GenerativeAi", "GetModel", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20231130").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("GenerativeAi", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20231130").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedAiClustersResponse> listDedicatedAiClusters(ListDedicatedAiClustersRequest request, AsyncHandler<ListDedicatedAiClustersRequest, ListDedicatedAiClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDedicatedAiClustersResponse::builder).logger(LOG, "listDedicatedAiClusters").serviceDetails("GenerativeAi", "ListDedicatedAiClusters", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiClusterCollection/ListDedicatedAiClusters").method(Method.GET).requestBuilder(ListDedicatedAiClustersRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedAiClusterCollection.class, ListDedicatedAiClustersResponse.Builder::dedicatedAiClusterCollection).handleResponseHeaderString("opc-request-id", ListDedicatedAiClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDedicatedAiClustersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListEndpointsResponse> listEndpoints(ListEndpointsRequest request, AsyncHandler<ListEndpointsRequest, ListEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEndpointsResponse::builder).logger(LOG, "listEndpoints").serviceDetails("GenerativeAi", "ListEndpoints", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/EndpointCollection/ListEndpoints").method(Method.GET).requestBuilder(ListEndpointsRequest::builder).basePath("/20231130").appendPathParam("endpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EndpointCollection.class, ListEndpointsResponse.Builder::endpointCollection).handleResponseHeaderString("opc-request-id", ListEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("GenerativeAi", "ListModels", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/ModelCollection/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20231130").appendPathParam("models").appendQueryParam("vendor", (Object)request.getVendor()).appendListQueryParam("capability", request.getCapability(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("GenerativeAi", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20231130").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("GenerativeAi", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20231130").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("GenerativeAi", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20231130").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateDedicatedAiClusterResponse> updateDedicatedAiCluster(UpdateDedicatedAiClusterRequest request, AsyncHandler<UpdateDedicatedAiClusterRequest, UpdateDedicatedAiClusterResponse> handler) {
        Validate.notBlank((String)request.getDedicatedAiClusterId(), (String)"dedicatedAiClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDedicatedAiClusterDetails(), "updateDedicatedAiClusterDetails is required");
        return this.clientCall(request, UpdateDedicatedAiClusterResponse::builder).logger(LOG, "updateDedicatedAiCluster").serviceDetails("GenerativeAi", "UpdateDedicatedAiCluster", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/DedicatedAiCluster/UpdateDedicatedAiCluster").method(Method.PUT).requestBuilder(UpdateDedicatedAiClusterRequest::builder).basePath("/20231130").appendPathParam("dedicatedAiClusters").appendPathParam(request.getDedicatedAiClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DedicatedAiCluster.class, UpdateDedicatedAiClusterResponse.Builder::dedicatedAiCluster).handleResponseHeaderString("opc-work-request-id", UpdateDedicatedAiClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDedicatedAiClusterResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDedicatedAiClusterResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest request, AsyncHandler<UpdateEndpointRequest, UpdateEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEndpointDetails(), "updateEndpointDetails is required");
        return this.clientCall(request, UpdateEndpointResponse::builder).logger(LOG, "updateEndpoint").serviceDetails("GenerativeAi", "UpdateEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Endpoint/UpdateEndpoint").method(Method.PUT).requestBuilder(UpdateEndpointRequest::builder).basePath("/20231130").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Endpoint.class, UpdateEndpointResponse.Builder::endpoint).handleResponseHeaderString("opc-work-request-id", UpdateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("GenerativeAi", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/generative-ai/20231130/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20231130").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, UpdateModelResponse.Builder::model).handleResponseHeaderString("etag", UpdateModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public GenerativeAiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GenerativeAiAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GenerativeAiAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GenerativeAiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GenerativeAiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GenerativeAiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GenerativeAiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenerativeAiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GenerativeAiAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "generativeai";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"generativeai");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GenerativeAiAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GenerativeAiAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

