/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai;

import com.oracle.bmc.generativeai.GenerativeAi;
import com.oracle.bmc.generativeai.model.DedicatedAiClusterSummary;
import com.oracle.bmc.generativeai.model.EndpointSummary;
import com.oracle.bmc.generativeai.model.ModelSummary;
import com.oracle.bmc.generativeai.model.WorkRequestError;
import com.oracle.bmc.generativeai.model.WorkRequestLogEntry;
import com.oracle.bmc.generativeai.model.WorkRequestSummary;
import com.oracle.bmc.generativeai.requests.ListDedicatedAiClustersRequest;
import com.oracle.bmc.generativeai.requests.ListEndpointsRequest;
import com.oracle.bmc.generativeai.requests.ListModelsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.generativeai.requests.ListWorkRequestsRequest;
import com.oracle.bmc.generativeai.responses.ListDedicatedAiClustersResponse;
import com.oracle.bmc.generativeai.responses.ListEndpointsResponse;
import com.oracle.bmc.generativeai.responses.ListModelsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.generativeai.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class GenerativeAiPaginators {
    private final GenerativeAi client;

    public GenerativeAiPaginators(GenerativeAi client) {
        this.client = client;
    }

    public Iterable<ListDedicatedAiClustersResponse> listDedicatedAiClustersResponseIterator(final ListDedicatedAiClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDedicatedAiClustersRequest.Builder>(){

            @Override
            public ListDedicatedAiClustersRequest.Builder get() {
                return ListDedicatedAiClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDedicatedAiClustersResponse, String>(){

            @Override
            public String apply(ListDedicatedAiClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDedicatedAiClustersRequest.Builder>, ListDedicatedAiClustersRequest>(){

            @Override
            public ListDedicatedAiClustersRequest apply(RequestBuilderAndToken<ListDedicatedAiClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDedicatedAiClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDedicatedAiClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDedicatedAiClustersRequest, ListDedicatedAiClustersResponse>(){

            @Override
            public ListDedicatedAiClustersResponse apply(ListDedicatedAiClustersRequest request) {
                return GenerativeAiPaginators.this.client.listDedicatedAiClusters(request);
            }
        });
    }

    public Iterable<DedicatedAiClusterSummary> listDedicatedAiClustersRecordIterator(final ListDedicatedAiClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDedicatedAiClustersRequest.Builder>(){

            @Override
            public ListDedicatedAiClustersRequest.Builder get() {
                return ListDedicatedAiClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDedicatedAiClustersResponse, String>(){

            @Override
            public String apply(ListDedicatedAiClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDedicatedAiClustersRequest.Builder>, ListDedicatedAiClustersRequest>(){

            @Override
            public ListDedicatedAiClustersRequest apply(RequestBuilderAndToken<ListDedicatedAiClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDedicatedAiClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDedicatedAiClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDedicatedAiClustersRequest, ListDedicatedAiClustersResponse>(){

            @Override
            public ListDedicatedAiClustersResponse apply(ListDedicatedAiClustersRequest request) {
                return GenerativeAiPaginators.this.client.listDedicatedAiClusters(request);
            }
        }, (Function)new Function<ListDedicatedAiClustersResponse, List<DedicatedAiClusterSummary>>(){

            @Override
            public List<DedicatedAiClusterSummary> apply(ListDedicatedAiClustersResponse response) {
                return response.getDedicatedAiClusterCollection().getItems();
            }
        });
    }

    public Iterable<ListEndpointsResponse> listEndpointsResponseIterator(final ListEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return GenerativeAiPaginators.this.client.listEndpoints(request);
            }
        });
    }

    public Iterable<EndpointSummary> listEndpointsRecordIterator(final ListEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return GenerativeAiPaginators.this.client.listEndpoints(request);
            }
        }, (Function)new Function<ListEndpointsResponse, List<EndpointSummary>>(){

            @Override
            public List<EndpointSummary> apply(ListEndpointsResponse response) {
                return response.getEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListModelsResponse> listModelsResponseIterator(final ListModelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return GenerativeAiPaginators.this.client.listModels(request);
            }
        });
    }

    public Iterable<ModelSummary> listModelsRecordIterator(final ListModelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return GenerativeAiPaginators.this.client.listModels(request);
            }
        }, (Function)new Function<ListModelsResponse, List<ModelSummary>>(){

            @Override
            public List<ModelSummary> apply(ListModelsResponse response) {
                return response.getModelCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GenerativeAiPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

