/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai;

import com.oracle.bmc.generativeai.GenerativeAi;
import com.oracle.bmc.generativeai.model.DedicatedAiCluster;
import com.oracle.bmc.generativeai.model.Endpoint;
import com.oracle.bmc.generativeai.model.Model;
import com.oracle.bmc.generativeai.requests.GetDedicatedAiClusterRequest;
import com.oracle.bmc.generativeai.requests.GetEndpointRequest;
import com.oracle.bmc.generativeai.requests.GetModelRequest;
import com.oracle.bmc.generativeai.requests.GetWorkRequestRequest;
import com.oracle.bmc.generativeai.responses.GetDedicatedAiClusterResponse;
import com.oracle.bmc.generativeai.responses.GetEndpointResponse;
import com.oracle.bmc.generativeai.responses.GetModelResponse;
import com.oracle.bmc.generativeai.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class GenerativeAiWaiters {
    private final ExecutorService executorService;
    private final GenerativeAi client;

    public GenerativeAiWaiters(ExecutorService executorService, GenerativeAi client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse> forDedicatedAiCluster(GetDedicatedAiClusterRequest request, DedicatedAiCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDedicatedAiCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse> forDedicatedAiCluster(GetDedicatedAiClusterRequest request, DedicatedAiCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDedicatedAiCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse> forDedicatedAiCluster(GetDedicatedAiClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DedicatedAiCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDedicatedAiCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse> forDedicatedAiCluster(BmcGenericWaiter waiter, GetDedicatedAiClusterRequest request, DedicatedAiCluster.LifecycleState ... targetStates) {
        final HashSet<DedicatedAiCluster.LifecycleState> targetStatesSet = new HashSet<DedicatedAiCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDedicatedAiClusterRequest, GetDedicatedAiClusterResponse>(){

            @Override
            public GetDedicatedAiClusterResponse apply(GetDedicatedAiClusterRequest request) {
                return GenerativeAiWaiters.this.client.getDedicatedAiCluster(request);
            }
        }, (Predicate)new Predicate<GetDedicatedAiClusterResponse>(){

            @Override
            public boolean test(GetDedicatedAiClusterResponse response) {
                return targetStatesSet.contains((Object)response.getDedicatedAiCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DedicatedAiCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(BmcGenericWaiter waiter, GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        final HashSet<Endpoint.LifecycleState> targetStatesSet = new HashSet<Endpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEndpointRequest, GetEndpointResponse>(){

            @Override
            public GetEndpointResponse apply(GetEndpointRequest request) {
                return GenerativeAiWaiters.this.client.getEndpoint(request);
            }
        }, (Predicate)new Predicate<GetEndpointResponse>(){

            @Override
            public boolean test(GetEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Endpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelRequest, GetModelResponse> forModel(BmcGenericWaiter waiter, GetModelRequest request, Model.LifecycleState ... targetStates) {
        final HashSet<Model.LifecycleState> targetStatesSet = new HashSet<Model.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelRequest, GetModelResponse>(){

            @Override
            public GetModelResponse apply(GetModelRequest request) {
                return GenerativeAiWaiters.this.client.getModel(request);
            }
        }, (Predicate)new Predicate<GetModelResponse>(){

            @Override
            public boolean test(GetModelResponse response) {
                return targetStatesSet.contains((Object)response.getModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Model.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return GenerativeAiWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

