/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeai.model.Dataset;
import com.oracle.bmc.generativeai.model.TrainingConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FineTuneDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="trainingDataset")
    private final Dataset trainingDataset;
    @JsonProperty(value="dedicatedAiClusterId")
    private final String dedicatedAiClusterId;
    @JsonProperty(value="trainingConfig")
    private final TrainingConfig trainingConfig;

    @Deprecated
    @ConstructorProperties(value={"trainingDataset", "dedicatedAiClusterId", "trainingConfig"})
    public FineTuneDetails(Dataset trainingDataset, String dedicatedAiClusterId, TrainingConfig trainingConfig) {
        this.trainingDataset = trainingDataset;
        this.dedicatedAiClusterId = dedicatedAiClusterId;
        this.trainingConfig = trainingConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Dataset getTrainingDataset() {
        return this.trainingDataset;
    }

    public String getDedicatedAiClusterId() {
        return this.dedicatedAiClusterId;
    }

    public TrainingConfig getTrainingConfig() {
        return this.trainingConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FineTuneDetails(");
        sb.append("super=").append(super.toString());
        sb.append("trainingDataset=").append(String.valueOf((Object)this.trainingDataset));
        sb.append(", dedicatedAiClusterId=").append(String.valueOf(this.dedicatedAiClusterId));
        sb.append(", trainingConfig=").append(String.valueOf((Object)this.trainingConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FineTuneDetails)) {
            return false;
        }
        FineTuneDetails other = (FineTuneDetails)((Object)o);
        return Objects.equals((Object)this.trainingDataset, (Object)other.trainingDataset) && Objects.equals(this.dedicatedAiClusterId, other.dedicatedAiClusterId) && Objects.equals((Object)this.trainingConfig, (Object)other.trainingConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.trainingDataset == null ? 43 : this.trainingDataset.hashCode());
        result = result * 59 + (this.dedicatedAiClusterId == null ? 43 : this.dedicatedAiClusterId.hashCode());
        result = result * 59 + (this.trainingConfig == null ? 43 : this.trainingConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="trainingDataset")
        private Dataset trainingDataset;
        @JsonProperty(value="dedicatedAiClusterId")
        private String dedicatedAiClusterId;
        @JsonProperty(value="trainingConfig")
        private TrainingConfig trainingConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder trainingDataset(Dataset trainingDataset) {
            this.trainingDataset = trainingDataset;
            this.__explicitlySet__.add("trainingDataset");
            return this;
        }

        public Builder dedicatedAiClusterId(String dedicatedAiClusterId) {
            this.dedicatedAiClusterId = dedicatedAiClusterId;
            this.__explicitlySet__.add("dedicatedAiClusterId");
            return this;
        }

        public Builder trainingConfig(TrainingConfig trainingConfig) {
            this.trainingConfig = trainingConfig;
            this.__explicitlySet__.add("trainingConfig");
            return this;
        }

        public FineTuneDetails build() {
            FineTuneDetails model = new FineTuneDetails(this.trainingDataset, this.dedicatedAiClusterId, this.trainingConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FineTuneDetails model) {
            if (model.wasPropertyExplicitlySet("trainingDataset")) {
                this.trainingDataset(model.getTrainingDataset());
            }
            if (model.wasPropertyExplicitlySet("dedicatedAiClusterId")) {
                this.dedicatedAiClusterId(model.getDedicatedAiClusterId());
            }
            if (model.wasPropertyExplicitlySet("trainingConfig")) {
                this.trainingConfig(model.getTrainingConfig());
            }
            return this;
        }
    }
}

