/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeai.model.TrainingConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="trainingConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class LoraTrainingConfig
extends TrainingConfig {
    @JsonProperty(value="loraR")
    private final Integer loraR;
    @JsonProperty(value="loraAlpha")
    private final Integer loraAlpha;
    @JsonProperty(value="loraDropout")
    private final Double loraDropout;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LoraTrainingConfig(Integer totalTrainingEpochs, Double learningRate, Integer trainingBatchSize, Integer earlyStoppingPatience, Double earlyStoppingThreshold, Integer logModelMetricsIntervalInSteps, Integer loraR, Integer loraAlpha, Double loraDropout) {
        super(totalTrainingEpochs, learningRate, trainingBatchSize, earlyStoppingPatience, earlyStoppingThreshold, logModelMetricsIntervalInSteps);
        this.loraR = loraR;
        this.loraAlpha = loraAlpha;
        this.loraDropout = loraDropout;
    }

    public Integer getLoraR() {
        return this.loraR;
    }

    public Integer getLoraAlpha() {
        return this.loraAlpha;
    }

    public Double getLoraDropout() {
        return this.loraDropout;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoraTrainingConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", loraR=").append(String.valueOf(this.loraR));
        sb.append(", loraAlpha=").append(String.valueOf(this.loraAlpha));
        sb.append(", loraDropout=").append(String.valueOf(this.loraDropout));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoraTrainingConfig)) {
            return false;
        }
        LoraTrainingConfig other = (LoraTrainingConfig)((Object)o);
        return Objects.equals(this.loraR, other.loraR) && Objects.equals(this.loraAlpha, other.loraAlpha) && Objects.equals(this.loraDropout, other.loraDropout) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.loraR == null ? 43 : this.loraR.hashCode());
        result = result * 59 + (this.loraAlpha == null ? 43 : this.loraAlpha.hashCode());
        result = result * 59 + (this.loraDropout == null ? 43 : this.loraDropout.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalTrainingEpochs")
        private Integer totalTrainingEpochs;
        @JsonProperty(value="learningRate")
        private Double learningRate;
        @JsonProperty(value="trainingBatchSize")
        private Integer trainingBatchSize;
        @JsonProperty(value="earlyStoppingPatience")
        private Integer earlyStoppingPatience;
        @JsonProperty(value="earlyStoppingThreshold")
        private Double earlyStoppingThreshold;
        @JsonProperty(value="logModelMetricsIntervalInSteps")
        private Integer logModelMetricsIntervalInSteps;
        @JsonProperty(value="loraR")
        private Integer loraR;
        @JsonProperty(value="loraAlpha")
        private Integer loraAlpha;
        @JsonProperty(value="loraDropout")
        private Double loraDropout;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalTrainingEpochs(Integer totalTrainingEpochs) {
            this.totalTrainingEpochs = totalTrainingEpochs;
            this.__explicitlySet__.add("totalTrainingEpochs");
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = learningRate;
            this.__explicitlySet__.add("learningRate");
            return this;
        }

        public Builder trainingBatchSize(Integer trainingBatchSize) {
            this.trainingBatchSize = trainingBatchSize;
            this.__explicitlySet__.add("trainingBatchSize");
            return this;
        }

        public Builder earlyStoppingPatience(Integer earlyStoppingPatience) {
            this.earlyStoppingPatience = earlyStoppingPatience;
            this.__explicitlySet__.add("earlyStoppingPatience");
            return this;
        }

        public Builder earlyStoppingThreshold(Double earlyStoppingThreshold) {
            this.earlyStoppingThreshold = earlyStoppingThreshold;
            this.__explicitlySet__.add("earlyStoppingThreshold");
            return this;
        }

        public Builder logModelMetricsIntervalInSteps(Integer logModelMetricsIntervalInSteps) {
            this.logModelMetricsIntervalInSteps = logModelMetricsIntervalInSteps;
            this.__explicitlySet__.add("logModelMetricsIntervalInSteps");
            return this;
        }

        public Builder loraR(Integer loraR) {
            this.loraR = loraR;
            this.__explicitlySet__.add("loraR");
            return this;
        }

        public Builder loraAlpha(Integer loraAlpha) {
            this.loraAlpha = loraAlpha;
            this.__explicitlySet__.add("loraAlpha");
            return this;
        }

        public Builder loraDropout(Double loraDropout) {
            this.loraDropout = loraDropout;
            this.__explicitlySet__.add("loraDropout");
            return this;
        }

        public LoraTrainingConfig build() {
            LoraTrainingConfig model = new LoraTrainingConfig(this.totalTrainingEpochs, this.learningRate, this.trainingBatchSize, this.earlyStoppingPatience, this.earlyStoppingThreshold, this.logModelMetricsIntervalInSteps, this.loraR, this.loraAlpha, this.loraDropout);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoraTrainingConfig model) {
            if (model.wasPropertyExplicitlySet("totalTrainingEpochs")) {
                this.totalTrainingEpochs(model.getTotalTrainingEpochs());
            }
            if (model.wasPropertyExplicitlySet("learningRate")) {
                this.learningRate(model.getLearningRate());
            }
            if (model.wasPropertyExplicitlySet("trainingBatchSize")) {
                this.trainingBatchSize(model.getTrainingBatchSize());
            }
            if (model.wasPropertyExplicitlySet("earlyStoppingPatience")) {
                this.earlyStoppingPatience(model.getEarlyStoppingPatience());
            }
            if (model.wasPropertyExplicitlySet("earlyStoppingThreshold")) {
                this.earlyStoppingThreshold(model.getEarlyStoppingThreshold());
            }
            if (model.wasPropertyExplicitlySet("logModelMetricsIntervalInSteps")) {
                this.logModelMetricsIntervalInSteps(model.getLogModelMetricsIntervalInSteps());
            }
            if (model.wasPropertyExplicitlySet("loraR")) {
                this.loraR(model.getLoraR());
            }
            if (model.wasPropertyExplicitlySet("loraAlpha")) {
                this.loraAlpha(model.getLoraAlpha());
            }
            if (model.wasPropertyExplicitlySet("loraDropout")) {
                this.loraDropout(model.getLoraDropout());
            }
            return this;
        }
    }
}

