/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ModelCapability implements BmcEnum
{
    TextGeneration("TEXT_GENERATION"),
    TextSummarization("TEXT_SUMMARIZATION"),
    TextEmbeddings("TEXT_EMBEDDINGS"),
    FineTune("FINE_TUNE"),
    Chat("CHAT"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, ModelCapability> map;

    private ModelCapability(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ModelCapability create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'ModelCapability', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(ModelCapability.class);
        map = new HashMap<String, ModelCapability>();
        for (ModelCapability v : ModelCapability.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

