/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.generativeai.model.LoraTrainingConfig;
import com.oracle.bmc.generativeai.model.TFewTrainingConfig;
import com.oracle.bmc.generativeai.model.VanillaTrainingConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="trainingConfigType", defaultImpl=TrainingConfig.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=LoraTrainingConfig.class, name="LORA_TRAINING_CONFIG"), @JsonSubTypes.Type(value=VanillaTrainingConfig.class, name="VANILLA_TRAINING_CONFIG"), @JsonSubTypes.Type(value=TFewTrainingConfig.class, name="TFEW_TRAINING_CONFIG")})
@JsonFilter(value="explicitlySetFilter")
public class TrainingConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalTrainingEpochs")
    private final Integer totalTrainingEpochs;
    @JsonProperty(value="learningRate")
    private final Double learningRate;
    @JsonProperty(value="trainingBatchSize")
    private final Integer trainingBatchSize;
    @JsonProperty(value="earlyStoppingPatience")
    private final Integer earlyStoppingPatience;
    @JsonProperty(value="earlyStoppingThreshold")
    private final Double earlyStoppingThreshold;
    @JsonProperty(value="logModelMetricsIntervalInSteps")
    private final Integer logModelMetricsIntervalInSteps;

    @Deprecated
    @ConstructorProperties(value={"totalTrainingEpochs", "learningRate", "trainingBatchSize", "earlyStoppingPatience", "earlyStoppingThreshold", "logModelMetricsIntervalInSteps"})
    protected TrainingConfig(Integer totalTrainingEpochs, Double learningRate, Integer trainingBatchSize, Integer earlyStoppingPatience, Double earlyStoppingThreshold, Integer logModelMetricsIntervalInSteps) {
        this.totalTrainingEpochs = totalTrainingEpochs;
        this.learningRate = learningRate;
        this.trainingBatchSize = trainingBatchSize;
        this.earlyStoppingPatience = earlyStoppingPatience;
        this.earlyStoppingThreshold = earlyStoppingThreshold;
        this.logModelMetricsIntervalInSteps = logModelMetricsIntervalInSteps;
    }

    public Integer getTotalTrainingEpochs() {
        return this.totalTrainingEpochs;
    }

    public Double getLearningRate() {
        return this.learningRate;
    }

    public Integer getTrainingBatchSize() {
        return this.trainingBatchSize;
    }

    public Integer getEarlyStoppingPatience() {
        return this.earlyStoppingPatience;
    }

    public Double getEarlyStoppingThreshold() {
        return this.earlyStoppingThreshold;
    }

    public Integer getLogModelMetricsIntervalInSteps() {
        return this.logModelMetricsIntervalInSteps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TrainingConfig(");
        sb.append("super=").append(super.toString());
        sb.append("totalTrainingEpochs=").append(String.valueOf(this.totalTrainingEpochs));
        sb.append(", learningRate=").append(String.valueOf(this.learningRate));
        sb.append(", trainingBatchSize=").append(String.valueOf(this.trainingBatchSize));
        sb.append(", earlyStoppingPatience=").append(String.valueOf(this.earlyStoppingPatience));
        sb.append(", earlyStoppingThreshold=").append(String.valueOf(this.earlyStoppingThreshold));
        sb.append(", logModelMetricsIntervalInSteps=").append(String.valueOf(this.logModelMetricsIntervalInSteps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrainingConfig)) {
            return false;
        }
        TrainingConfig other = (TrainingConfig)((Object)o);
        return Objects.equals(this.totalTrainingEpochs, other.totalTrainingEpochs) && Objects.equals(this.learningRate, other.learningRate) && Objects.equals(this.trainingBatchSize, other.trainingBatchSize) && Objects.equals(this.earlyStoppingPatience, other.earlyStoppingPatience) && Objects.equals(this.earlyStoppingThreshold, other.earlyStoppingThreshold) && Objects.equals(this.logModelMetricsIntervalInSteps, other.logModelMetricsIntervalInSteps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalTrainingEpochs == null ? 43 : this.totalTrainingEpochs.hashCode());
        result = result * 59 + (this.learningRate == null ? 43 : this.learningRate.hashCode());
        result = result * 59 + (this.trainingBatchSize == null ? 43 : this.trainingBatchSize.hashCode());
        result = result * 59 + (this.earlyStoppingPatience == null ? 43 : this.earlyStoppingPatience.hashCode());
        result = result * 59 + (this.earlyStoppingThreshold == null ? 43 : this.earlyStoppingThreshold.hashCode());
        result = result * 59 + (this.logModelMetricsIntervalInSteps == null ? 43 : this.logModelMetricsIntervalInSteps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TrainingConfigType implements BmcEnum
    {
        TfewTrainingConfig("TFEW_TRAINING_CONFIG"),
        VanillaTrainingConfig("VANILLA_TRAINING_CONFIG"),
        LoraTrainingConfig("LORA_TRAINING_CONFIG"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TrainingConfigType> map;

        private TrainingConfigType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TrainingConfigType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TrainingConfigType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TrainingConfigType.class);
            map = new HashMap<String, TrainingConfigType>();
            for (TrainingConfigType v : TrainingConfigType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

