/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeai.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeai.model.TrainingConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="trainingConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class VanillaTrainingConfig
extends TrainingConfig {
    @JsonProperty(value="numOfLastLayers")
    private final Integer numOfLastLayers;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VanillaTrainingConfig(Integer totalTrainingEpochs, Double learningRate, Integer trainingBatchSize, Integer earlyStoppingPatience, Double earlyStoppingThreshold, Integer logModelMetricsIntervalInSteps, Integer numOfLastLayers) {
        super(totalTrainingEpochs, learningRate, trainingBatchSize, earlyStoppingPatience, earlyStoppingThreshold, logModelMetricsIntervalInSteps);
        this.numOfLastLayers = numOfLastLayers;
    }

    public Integer getNumOfLastLayers() {
        return this.numOfLastLayers;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VanillaTrainingConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numOfLastLayers=").append(String.valueOf(this.numOfLastLayers));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VanillaTrainingConfig)) {
            return false;
        }
        VanillaTrainingConfig other = (VanillaTrainingConfig)((Object)o);
        return Objects.equals(this.numOfLastLayers, other.numOfLastLayers) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.numOfLastLayers == null ? 43 : this.numOfLastLayers.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalTrainingEpochs")
        private Integer totalTrainingEpochs;
        @JsonProperty(value="learningRate")
        private Double learningRate;
        @JsonProperty(value="trainingBatchSize")
        private Integer trainingBatchSize;
        @JsonProperty(value="earlyStoppingPatience")
        private Integer earlyStoppingPatience;
        @JsonProperty(value="earlyStoppingThreshold")
        private Double earlyStoppingThreshold;
        @JsonProperty(value="logModelMetricsIntervalInSteps")
        private Integer logModelMetricsIntervalInSteps;
        @JsonProperty(value="numOfLastLayers")
        private Integer numOfLastLayers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalTrainingEpochs(Integer totalTrainingEpochs) {
            this.totalTrainingEpochs = totalTrainingEpochs;
            this.__explicitlySet__.add("totalTrainingEpochs");
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = learningRate;
            this.__explicitlySet__.add("learningRate");
            return this;
        }

        public Builder trainingBatchSize(Integer trainingBatchSize) {
            this.trainingBatchSize = trainingBatchSize;
            this.__explicitlySet__.add("trainingBatchSize");
            return this;
        }

        public Builder earlyStoppingPatience(Integer earlyStoppingPatience) {
            this.earlyStoppingPatience = earlyStoppingPatience;
            this.__explicitlySet__.add("earlyStoppingPatience");
            return this;
        }

        public Builder earlyStoppingThreshold(Double earlyStoppingThreshold) {
            this.earlyStoppingThreshold = earlyStoppingThreshold;
            this.__explicitlySet__.add("earlyStoppingThreshold");
            return this;
        }

        public Builder logModelMetricsIntervalInSteps(Integer logModelMetricsIntervalInSteps) {
            this.logModelMetricsIntervalInSteps = logModelMetricsIntervalInSteps;
            this.__explicitlySet__.add("logModelMetricsIntervalInSteps");
            return this;
        }

        public Builder numOfLastLayers(Integer numOfLastLayers) {
            this.numOfLastLayers = numOfLastLayers;
            this.__explicitlySet__.add("numOfLastLayers");
            return this;
        }

        public VanillaTrainingConfig build() {
            VanillaTrainingConfig model = new VanillaTrainingConfig(this.totalTrainingEpochs, this.learningRate, this.trainingBatchSize, this.earlyStoppingPatience, this.earlyStoppingThreshold, this.logModelMetricsIntervalInSteps, this.numOfLastLayers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VanillaTrainingConfig model) {
            if (model.wasPropertyExplicitlySet("totalTrainingEpochs")) {
                this.totalTrainingEpochs(model.getTotalTrainingEpochs());
            }
            if (model.wasPropertyExplicitlySet("learningRate")) {
                this.learningRate(model.getLearningRate());
            }
            if (model.wasPropertyExplicitlySet("trainingBatchSize")) {
                this.trainingBatchSize(model.getTrainingBatchSize());
            }
            if (model.wasPropertyExplicitlySet("earlyStoppingPatience")) {
                this.earlyStoppingPatience(model.getEarlyStoppingPatience());
            }
            if (model.wasPropertyExplicitlySet("earlyStoppingThreshold")) {
                this.earlyStoppingThreshold(model.getEarlyStoppingThreshold());
            }
            if (model.wasPropertyExplicitlySet("logModelMetricsIntervalInSteps")) {
                this.logModelMetricsIntervalInSteps(model.getLogModelMetricsIntervalInSteps());
            }
            if (model.wasPropertyExplicitlySet("numOfLastLayers")) {
                this.numOfLastLayers(model.getNumOfLastLayers());
            }
            return this;
        }
    }
}

