/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent;

import com.oracle.bmc.generativeaiagent.GenerativeAiAgent;
import com.oracle.bmc.generativeaiagent.model.Agent;
import com.oracle.bmc.generativeaiagent.model.AgentEndpoint;
import com.oracle.bmc.generativeaiagent.model.DataIngestionJob;
import com.oracle.bmc.generativeaiagent.model.DataSource;
import com.oracle.bmc.generativeaiagent.model.KnowledgeBase;
import com.oracle.bmc.generativeaiagent.requests.GetAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.GetAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.GetWorkRequestRequest;
import com.oracle.bmc.generativeaiagent.responses.GetAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.GetAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class GenerativeAiAgentWaiters {
    private final ExecutorService executorService;
    private final GenerativeAiAgent client;

    public GenerativeAiAgentWaiters(ExecutorService executorService, GenerativeAiAgent client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, Agent.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAgent(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, Agent.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAgent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Agent.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAgent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAgentRequest, GetAgentResponse> forAgent(BmcGenericWaiter waiter, GetAgentRequest request, Agent.LifecycleState ... targetStates) {
        final HashSet<Agent.LifecycleState> targetStatesSet = new HashSet<Agent.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAgentRequest, GetAgentResponse>(){

            @Override
            public GetAgentResponse apply(GetAgentRequest request) {
                return GenerativeAiAgentWaiters.this.client.getAgent(request);
            }
        }, (Predicate)new Predicate<GetAgentResponse>(){

            @Override
            public boolean test(GetAgentResponse response) {
                return targetStatesSet.contains((Object)response.getAgent().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Agent.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAgentEndpointRequest, GetAgentEndpointResponse> forAgentEndpoint(GetAgentEndpointRequest request, AgentEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAgentEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAgentEndpointRequest, GetAgentEndpointResponse> forAgentEndpoint(GetAgentEndpointRequest request, AgentEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAgentEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAgentEndpointRequest, GetAgentEndpointResponse> forAgentEndpoint(GetAgentEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AgentEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAgentEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAgentEndpointRequest, GetAgentEndpointResponse> forAgentEndpoint(BmcGenericWaiter waiter, GetAgentEndpointRequest request, AgentEndpoint.LifecycleState ... targetStates) {
        final HashSet<AgentEndpoint.LifecycleState> targetStatesSet = new HashSet<AgentEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAgentEndpointRequest, GetAgentEndpointResponse>(){

            @Override
            public GetAgentEndpointResponse apply(GetAgentEndpointRequest request) {
                return GenerativeAiAgentWaiters.this.client.getAgentEndpoint(request);
            }
        }, (Predicate)new Predicate<GetAgentEndpointResponse>(){

            @Override
            public boolean test(GetAgentEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getAgentEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AgentEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataIngestionJobRequest, GetDataIngestionJobResponse> forDataIngestionJob(GetDataIngestionJobRequest request, DataIngestionJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataIngestionJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataIngestionJobRequest, GetDataIngestionJobResponse> forDataIngestionJob(GetDataIngestionJobRequest request, DataIngestionJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataIngestionJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataIngestionJobRequest, GetDataIngestionJobResponse> forDataIngestionJob(GetDataIngestionJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataIngestionJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataIngestionJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataIngestionJobRequest, GetDataIngestionJobResponse> forDataIngestionJob(BmcGenericWaiter waiter, GetDataIngestionJobRequest request, DataIngestionJob.LifecycleState ... targetStates) {
        final HashSet<DataIngestionJob.LifecycleState> targetStatesSet = new HashSet<DataIngestionJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataIngestionJobRequest, GetDataIngestionJobResponse>(){

            @Override
            public GetDataIngestionJobResponse apply(GetDataIngestionJobRequest request) {
                return GenerativeAiAgentWaiters.this.client.getDataIngestionJob(request);
            }
        }, (Predicate)new Predicate<GetDataIngestionJobResponse>(){

            @Override
            public boolean test(GetDataIngestionJobResponse response) {
                return targetStatesSet.contains((Object)response.getDataIngestionJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DataIngestionJob.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, DataSource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, DataSource.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataSource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(BmcGenericWaiter waiter, GetDataSourceRequest request, DataSource.LifecycleState ... targetStates) {
        final HashSet<DataSource.LifecycleState> targetStatesSet = new HashSet<DataSource.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataSourceRequest, GetDataSourceResponse>(){

            @Override
            public GetDataSourceResponse apply(GetDataSourceRequest request) {
                return GenerativeAiAgentWaiters.this.client.getDataSource(request);
            }
        }, (Predicate)new Predicate<GetDataSourceResponse>(){

            @Override
            public boolean test(GetDataSourceResponse response) {
                return targetStatesSet.contains((Object)response.getDataSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DataSource.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, KnowledgeBase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(BmcGenericWaiter waiter, GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState ... targetStates) {
        final HashSet<KnowledgeBase.LifecycleState> targetStatesSet = new HashSet<KnowledgeBase.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse>(){

            @Override
            public GetKnowledgeBaseResponse apply(GetKnowledgeBaseRequest request) {
                return GenerativeAiAgentWaiters.this.client.getKnowledgeBase(request);
            }
        }, (Predicate)new Predicate<GetKnowledgeBaseResponse>(){

            @Override
            public boolean test(GetKnowledgeBaseResponse response) {
                return targetStatesSet.contains((Object)response.getKnowledgeBase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)KnowledgeBase.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return GenerativeAiAgentWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

