/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataIngestionJobStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="numberOfFailedFiles")
    private final Integer numberOfFailedFiles;
    @JsonProperty(value="numberOfIngestedFiles")
    private final Integer numberOfIngestedFiles;
    @JsonProperty(value="durationInSeconds")
    private final Integer durationInSeconds;

    @Deprecated
    @ConstructorProperties(value={"numberOfFailedFiles", "numberOfIngestedFiles", "durationInSeconds"})
    public DataIngestionJobStatistics(Integer numberOfFailedFiles, Integer numberOfIngestedFiles, Integer durationInSeconds) {
        this.numberOfFailedFiles = numberOfFailedFiles;
        this.numberOfIngestedFiles = numberOfIngestedFiles;
        this.durationInSeconds = durationInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getNumberOfFailedFiles() {
        return this.numberOfFailedFiles;
    }

    public Integer getNumberOfIngestedFiles() {
        return this.numberOfIngestedFiles;
    }

    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataIngestionJobStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("numberOfFailedFiles=").append(String.valueOf(this.numberOfFailedFiles));
        sb.append(", numberOfIngestedFiles=").append(String.valueOf(this.numberOfIngestedFiles));
        sb.append(", durationInSeconds=").append(String.valueOf(this.durationInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataIngestionJobStatistics)) {
            return false;
        }
        DataIngestionJobStatistics other = (DataIngestionJobStatistics)((Object)o);
        return Objects.equals(this.numberOfFailedFiles, other.numberOfFailedFiles) && Objects.equals(this.numberOfIngestedFiles, other.numberOfIngestedFiles) && Objects.equals(this.durationInSeconds, other.durationInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.numberOfFailedFiles == null ? 43 : this.numberOfFailedFiles.hashCode());
        result = result * 59 + (this.numberOfIngestedFiles == null ? 43 : this.numberOfIngestedFiles.hashCode());
        result = result * 59 + (this.durationInSeconds == null ? 43 : this.durationInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="numberOfFailedFiles")
        private Integer numberOfFailedFiles;
        @JsonProperty(value="numberOfIngestedFiles")
        private Integer numberOfIngestedFiles;
        @JsonProperty(value="durationInSeconds")
        private Integer durationInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder numberOfFailedFiles(Integer numberOfFailedFiles) {
            this.numberOfFailedFiles = numberOfFailedFiles;
            this.__explicitlySet__.add("numberOfFailedFiles");
            return this;
        }

        public Builder numberOfIngestedFiles(Integer numberOfIngestedFiles) {
            this.numberOfIngestedFiles = numberOfIngestedFiles;
            this.__explicitlySet__.add("numberOfIngestedFiles");
            return this;
        }

        public Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.__explicitlySet__.add("durationInSeconds");
            return this;
        }

        public DataIngestionJobStatistics build() {
            DataIngestionJobStatistics model = new DataIngestionJobStatistics(this.numberOfFailedFiles, this.numberOfIngestedFiles, this.durationInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataIngestionJobStatistics model) {
            if (model.wasPropertyExplicitlySet("numberOfFailedFiles")) {
                this.numberOfFailedFiles(model.getNumberOfFailedFiles());
            }
            if (model.wasPropertyExplicitlySet("numberOfIngestedFiles")) {
                this.numberOfIngestedFiles(model.getNumberOfIngestedFiles());
            }
            if (model.wasPropertyExplicitlySet("durationInSeconds")) {
                this.durationInSeconds(model.getDurationInSeconds());
            }
            return this;
        }
    }
}

