/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiagent.model.Index;
import com.oracle.bmc.generativeaiagent.model.IndexConfig;
import com.oracle.bmc.generativeaiagent.model.SecretDetail;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="indexConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class OciOpenSearchIndexConfig
extends IndexConfig {
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="secretDetail")
    private final SecretDetail secretDetail;
    @JsonProperty(value="indexes")
    private final List<Index> indexes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciOpenSearchIndexConfig(String clusterId, SecretDetail secretDetail, List<Index> indexes) {
        this.clusterId = clusterId;
        this.secretDetail = secretDetail;
        this.indexes = indexes;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public SecretDetail getSecretDetail() {
        return this.secretDetail;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciOpenSearchIndexConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", clusterId=").append(String.valueOf(this.clusterId));
        sb.append(", secretDetail=").append(String.valueOf((Object)this.secretDetail));
        sb.append(", indexes=").append(String.valueOf(this.indexes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciOpenSearchIndexConfig)) {
            return false;
        }
        OciOpenSearchIndexConfig other = (OciOpenSearchIndexConfig)((Object)o);
        return Objects.equals(this.clusterId, other.clusterId) && Objects.equals((Object)this.secretDetail, (Object)other.secretDetail) && Objects.equals(this.indexes, other.indexes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.secretDetail == null ? 43 : this.secretDetail.hashCode());
        result = result * 59 + (this.indexes == null ? 43 : this.indexes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clusterId")
        private String clusterId;
        @JsonProperty(value="secretDetail")
        private SecretDetail secretDetail;
        @JsonProperty(value="indexes")
        private List<Index> indexes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            this.__explicitlySet__.add("clusterId");
            return this;
        }

        public Builder secretDetail(SecretDetail secretDetail) {
            this.secretDetail = secretDetail;
            this.__explicitlySet__.add("secretDetail");
            return this;
        }

        public Builder indexes(List<Index> indexes) {
            this.indexes = indexes;
            this.__explicitlySet__.add("indexes");
            return this;
        }

        public OciOpenSearchIndexConfig build() {
            OciOpenSearchIndexConfig model = new OciOpenSearchIndexConfig(this.clusterId, this.secretDetail, this.indexes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciOpenSearchIndexConfig model) {
            if (model.wasPropertyExplicitlySet("clusterId")) {
                this.clusterId(model.getClusterId());
            }
            if (model.wasPropertyExplicitlySet("secretDetail")) {
                this.secretDetail(model.getSecretDetail());
            }
            if (model.wasPropertyExplicitlySet("indexes")) {
                this.indexes(model.getIndexes());
            }
            return this;
        }
    }
}

