/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataIngestionJobLogContentRequest
extends BmcRequest<Void> {
    private String dataIngestionJobId;
    private String opcRequestId;

    public String getDataIngestionJobId() {
        return this.dataIngestionJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataIngestionJobId(this.dataIngestionJobId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataIngestionJobId=").append(String.valueOf(this.dataIngestionJobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataIngestionJobLogContentRequest)) {
            return false;
        }
        GetDataIngestionJobLogContentRequest other = (GetDataIngestionJobLogContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataIngestionJobId, other.dataIngestionJobId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataIngestionJobId == null ? 43 : this.dataIngestionJobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataIngestionJobLogContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataIngestionJobId = null;
        private String opcRequestId = null;

        public Builder dataIngestionJobId(String dataIngestionJobId) {
            this.dataIngestionJobId = dataIngestionJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataIngestionJobLogContentRequest o) {
            this.dataIngestionJobId(o.getDataIngestionJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataIngestionJobLogContentRequest build() {
            GetDataIngestionJobLogContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataIngestionJobLogContentRequest buildWithoutInvocationCallback() {
            GetDataIngestionJobLogContentRequest request = new GetDataIngestionJobLogContentRequest();
            request.dataIngestionJobId = this.dataIngestionJobId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

