/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataSourceRequest
extends BmcRequest<Void> {
    private String dataSourceId;
    private String opcRequestId;

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataSourceId(this.dataSourceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataSourceId=").append(String.valueOf(this.dataSourceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataSourceRequest)) {
            return false;
        }
        GetDataSourceRequest other = (GetDataSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataSourceId, other.dataSourceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataSourceId == null ? 43 : this.dataSourceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataSourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataSourceId = null;
        private String opcRequestId = null;

        public Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataSourceRequest o) {
            this.dataSourceId(o.getDataSourceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataSourceRequest build() {
            GetDataSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataSourceRequest buildWithoutInvocationCallback() {
            GetDataSourceRequest request = new GetDataSourceRequest();
            request.dataSourceId = this.dataSourceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

