/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiagent;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.generativeaiagent.GenerativeAiAgent;
import com.oracle.bmc.generativeaiagent.GenerativeAiAgentPaginators;
import com.oracle.bmc.generativeaiagent.GenerativeAiAgentWaiters;
import com.oracle.bmc.generativeaiagent.model.Agent;
import com.oracle.bmc.generativeaiagent.model.AgentCollection;
import com.oracle.bmc.generativeaiagent.model.AgentEndpoint;
import com.oracle.bmc.generativeaiagent.model.AgentEndpointCollection;
import com.oracle.bmc.generativeaiagent.model.DataIngestionJob;
import com.oracle.bmc.generativeaiagent.model.DataIngestionJobCollection;
import com.oracle.bmc.generativeaiagent.model.DataSource;
import com.oracle.bmc.generativeaiagent.model.DataSourceCollection;
import com.oracle.bmc.generativeaiagent.model.KnowledgeBase;
import com.oracle.bmc.generativeaiagent.model.KnowledgeBaseCollection;
import com.oracle.bmc.generativeaiagent.model.Tool;
import com.oracle.bmc.generativeaiagent.model.ToolCollection;
import com.oracle.bmc.generativeaiagent.model.WorkRequest;
import com.oracle.bmc.generativeaiagent.model.WorkRequestErrorCollection;
import com.oracle.bmc.generativeaiagent.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.generativeaiagent.model.WorkRequestSummaryCollection;
import com.oracle.bmc.generativeaiagent.requests.CancelWorkRequestRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeAgentEndpointCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateToolRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteToolRequest;
import com.oracle.bmc.generativeaiagent.requests.GetAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.GetAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataIngestionJobLogContentRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.GetToolRequest;
import com.oracle.bmc.generativeaiagent.requests.GetWorkRequestRequest;
import com.oracle.bmc.generativeaiagent.requests.ListAgentEndpointsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListAgentsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataIngestionJobsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataSourcesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListToolsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestsRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateToolRequest;
import com.oracle.bmc.generativeaiagent.responses.CancelWorkRequestResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeAgentEndpointCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateToolResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteToolResponse;
import com.oracle.bmc.generativeaiagent.responses.GetAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.GetAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataIngestionJobLogContentResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.GetToolResponse;
import com.oracle.bmc.generativeaiagent.responses.GetWorkRequestResponse;
import com.oracle.bmc.generativeaiagent.responses.ListAgentEndpointsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListAgentsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataIngestionJobsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataSourcesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListToolsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestsResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateToolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerativeAiAgentClient
extends BaseSyncClient
implements GenerativeAiAgent {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GENERATIVEAIAGENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://agent.generativeai.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GenerativeAiAgentClient.class);
    private final GenerativeAiAgentWaiters waiters;
    private final GenerativeAiAgentPaginators paginators;

    GenerativeAiAgentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    GenerativeAiAgentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("GenerativeAiAgent-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new GenerativeAiAgentWaiters(executorService, this);
        this.paginators = new GenerativeAiAgentPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"GenerativeAiAgentClient", (String)"getDataIngestionJobLogContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("GenerativeAiAgent", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20240531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeAgentCompartmentResponse changeAgentCompartment(ChangeAgentCompartmentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentCompartmentDetails(), "changeAgentCompartmentDetails is required");
        return (ChangeAgentCompartmentResponse)this.clientCall(request, ChangeAgentCompartmentResponse::builder).logger(LOG, "changeAgentCompartment").serviceDetails("GenerativeAiAgent", "ChangeAgentCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/ChangeAgentCompartment").method(Method.POST).requestBuilder(ChangeAgentCompartmentRequest::builder).basePath("/20240531").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAgentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAgentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeAgentEndpointCompartmentResponse changeAgentEndpointCompartment(ChangeAgentEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentEndpointCompartmentDetails(), "changeAgentEndpointCompartmentDetails is required");
        return (ChangeAgentEndpointCompartmentResponse)this.clientCall(request, ChangeAgentEndpointCompartmentResponse::builder).logger(LOG, "changeAgentEndpointCompartment").serviceDetails("GenerativeAiAgent", "ChangeAgentEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/ChangeAgentEndpointCompartment").method(Method.POST).requestBuilder(ChangeAgentEndpointCompartmentRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAgentEndpointCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAgentEndpointCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeKnowledgeBaseCompartmentResponse changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeKnowledgeBaseCompartmentDetails(), "changeKnowledgeBaseCompartmentDetails is required");
        return (ChangeKnowledgeBaseCompartmentResponse)this.clientCall(request, ChangeKnowledgeBaseCompartmentResponse::builder).logger(LOG, "changeKnowledgeBaseCompartment").serviceDetails("GenerativeAiAgent", "ChangeKnowledgeBaseCompartment", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/ChangeKnowledgeBaseCompartment").method(Method.POST).requestBuilder(ChangeKnowledgeBaseCompartmentRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAgentResponse createAgent(CreateAgentRequest request) {
        Objects.requireNonNull(request.getCreateAgentDetails(), "createAgentDetails is required");
        return (CreateAgentResponse)this.clientCall(request, CreateAgentResponse::builder).logger(LOG, "createAgent").serviceDetails("GenerativeAiAgent", "CreateAgent", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/CreateAgent").method(Method.POST).requestBuilder(CreateAgentRequest::builder).basePath("/20240531").appendPathParam("agents").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Agent.class, CreateAgentResponse.Builder::agent).handleResponseHeaderString("location", CreateAgentResponse.Builder::location).handleResponseHeaderString("content-location", CreateAgentResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateAgentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateAgentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateAgentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAgentEndpointResponse createAgentEndpoint(CreateAgentEndpointRequest request) {
        Objects.requireNonNull(request.getCreateAgentEndpointDetails(), "createAgentEndpointDetails is required");
        return (CreateAgentEndpointResponse)this.clientCall(request, CreateAgentEndpointResponse::builder).logger(LOG, "createAgentEndpoint").serviceDetails("GenerativeAiAgent", "CreateAgentEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/CreateAgentEndpoint").method(Method.POST).requestBuilder(CreateAgentEndpointRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(AgentEndpoint.class, CreateAgentEndpointResponse.Builder::agentEndpoint).handleResponseHeaderString("location", CreateAgentEndpointResponse.Builder::location).handleResponseHeaderString("content-location", CreateAgentEndpointResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateAgentEndpointResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateAgentEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateAgentEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataIngestionJobResponse createDataIngestionJob(CreateDataIngestionJobRequest request) {
        Objects.requireNonNull(request.getCreateDataIngestionJobDetails(), "createDataIngestionJobDetails is required");
        return (CreateDataIngestionJobResponse)this.clientCall(request, CreateDataIngestionJobResponse::builder).logger(LOG, "createDataIngestionJob").serviceDetails("GenerativeAiAgent", "CreateDataIngestionJob", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataIngestionJob/CreateDataIngestionJob").method(Method.POST).requestBuilder(CreateDataIngestionJobRequest::builder).basePath("/20240531").appendPathParam("dataIngestionJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DataIngestionJob.class, CreateDataIngestionJobResponse.Builder::dataIngestionJob).handleResponseHeaderString("location", CreateDataIngestionJobResponse.Builder::location).handleResponseHeaderString("content-location", CreateDataIngestionJobResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateDataIngestionJobResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDataIngestionJobResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDataIngestionJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest request) {
        Objects.requireNonNull(request.getCreateDataSourceDetails(), "createDataSourceDetails is required");
        return (CreateDataSourceResponse)this.clientCall(request, CreateDataSourceResponse::builder).logger(LOG, "createDataSource").serviceDetails("GenerativeAiAgent", "CreateDataSource", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataSource/CreateDataSource").method(Method.POST).requestBuilder(CreateDataSourceRequest::builder).basePath("/20240531").appendPathParam("dataSources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DataSource.class, CreateDataSourceResponse.Builder::dataSource).handleResponseHeaderString("location", CreateDataSourceResponse.Builder::location).handleResponseHeaderString("content-location", CreateDataSourceResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateDataSourceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        Objects.requireNonNull(request.getCreateKnowledgeBaseDetails(), "createKnowledgeBaseDetails is required");
        return (CreateKnowledgeBaseResponse)this.clientCall(request, CreateKnowledgeBaseResponse::builder).logger(LOG, "createKnowledgeBase").serviceDetails("GenerativeAiAgent", "CreateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/CreateKnowledgeBase").method(Method.POST).requestBuilder(CreateKnowledgeBaseRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(KnowledgeBase.class, CreateKnowledgeBaseResponse.Builder::knowledgeBase).handleResponseHeaderString("location", CreateKnowledgeBaseResponse.Builder::location).handleResponseHeaderString("content-location", CreateKnowledgeBaseResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateKnowledgeBaseResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateToolResponse createTool(CreateToolRequest request) {
        Objects.requireNonNull(request.getCreateToolDetails(), "createToolDetails is required");
        return (CreateToolResponse)this.clientCall(request, CreateToolResponse::builder).logger(LOG, "createTool").serviceDetails("GenerativeAiAgent", "CreateTool", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Tool/CreateTool").method(Method.POST).requestBuilder(CreateToolRequest::builder).basePath("/20240531").appendPathParam("tools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Tool.class, CreateToolResponse.Builder::tool).handleResponseHeaderString("location", CreateToolResponse.Builder::location).handleResponseHeaderString("content-location", CreateToolResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateToolResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateToolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateToolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAgentResponse deleteAgent(DeleteAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return (DeleteAgentResponse)this.clientCall(request, DeleteAgentResponse::builder).logger(LOG, "deleteAgent").serviceDetails("GenerativeAiAgent", "DeleteAgent", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/DeleteAgent").method(Method.DELETE).requestBuilder(DeleteAgentRequest::builder).basePath("/20240531").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteAgentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAgentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAgentEndpointResponse deleteAgentEndpoint(DeleteAgentEndpointRequest request) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        return (DeleteAgentEndpointResponse)this.clientCall(request, DeleteAgentEndpointResponse::builder).logger(LOG, "deleteAgentEndpoint").serviceDetails("GenerativeAiAgent", "DeleteAgentEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/DeleteAgentEndpoint").method(Method.DELETE).requestBuilder(DeleteAgentEndpointRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteAgentEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAgentEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataIngestionJobResponse deleteDataIngestionJob(DeleteDataIngestionJobRequest request) {
        Validate.notBlank((String)request.getDataIngestionJobId(), (String)"dataIngestionJobId must not be blank", (Object[])new Object[0]);
        return (DeleteDataIngestionJobResponse)this.clientCall(request, DeleteDataIngestionJobResponse::builder).logger(LOG, "deleteDataIngestionJob").serviceDetails("GenerativeAiAgent", "DeleteDataIngestionJob", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataIngestionJob/DeleteDataIngestionJob").method(Method.DELETE).requestBuilder(DeleteDataIngestionJobRequest::builder).basePath("/20240531").appendPathParam("dataIngestionJobs").appendPathParam(request.getDataIngestionJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDataIngestionJobResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDataIngestionJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (DeleteDataSourceResponse)this.clientCall(request, DeleteDataSourceResponse::builder).logger(LOG, "deleteDataSource").serviceDetails("GenerativeAiAgent", "DeleteDataSource", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataSource/DeleteDataSource").method(Method.DELETE).requestBuilder(DeleteDataSourceRequest::builder).basePath("/20240531").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (DeleteKnowledgeBaseResponse)this.clientCall(request, DeleteKnowledgeBaseResponse::builder).logger(LOG, "deleteKnowledgeBase").serviceDetails("GenerativeAiAgent", "DeleteKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/DeleteKnowledgeBase").method(Method.DELETE).requestBuilder(DeleteKnowledgeBaseRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteToolResponse deleteTool(DeleteToolRequest request) {
        Validate.notBlank((String)request.getToolId(), (String)"toolId must not be blank", (Object[])new Object[0]);
        return (DeleteToolResponse)this.clientCall(request, DeleteToolResponse::builder).logger(LOG, "deleteTool").serviceDetails("GenerativeAiAgent", "DeleteTool", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Tool/DeleteTool").method(Method.DELETE).requestBuilder(DeleteToolRequest::builder).basePath("/20240531").appendPathParam("tools").appendPathParam(request.getToolId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteToolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteToolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAgentResponse getAgent(GetAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return (GetAgentResponse)this.clientCall(request, GetAgentResponse::builder).logger(LOG, "getAgent").serviceDetails("GenerativeAiAgent", "GetAgent", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/GetAgent").method(Method.GET).requestBuilder(GetAgentRequest::builder).basePath("/20240531").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Agent.class, GetAgentResponse.Builder::agent).handleResponseHeaderString("etag", GetAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAgentEndpointResponse getAgentEndpoint(GetAgentEndpointRequest request) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        return (GetAgentEndpointResponse)this.clientCall(request, GetAgentEndpointResponse::builder).logger(LOG, "getAgentEndpoint").serviceDetails("GenerativeAiAgent", "GetAgentEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/GetAgentEndpoint").method(Method.GET).requestBuilder(GetAgentEndpointRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AgentEndpoint.class, GetAgentEndpointResponse.Builder::agentEndpoint).handleResponseHeaderString("etag", GetAgentEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDataIngestionJobResponse getDataIngestionJob(GetDataIngestionJobRequest request) {
        Validate.notBlank((String)request.getDataIngestionJobId(), (String)"dataIngestionJobId must not be blank", (Object[])new Object[0]);
        return (GetDataIngestionJobResponse)this.clientCall(request, GetDataIngestionJobResponse::builder).logger(LOG, "getDataIngestionJob").serviceDetails("GenerativeAiAgent", "GetDataIngestionJob", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataIngestionJob/GetDataIngestionJob").method(Method.GET).requestBuilder(GetDataIngestionJobRequest::builder).basePath("/20240531").appendPathParam("dataIngestionJobs").appendPathParam(request.getDataIngestionJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DataIngestionJob.class, GetDataIngestionJobResponse.Builder::dataIngestionJob).handleResponseHeaderString("etag", GetDataIngestionJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataIngestionJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDataIngestionJobLogContentResponse getDataIngestionJobLogContent(GetDataIngestionJobLogContentRequest request) {
        Validate.notBlank((String)request.getDataIngestionJobId(), (String)"dataIngestionJobId must not be blank", (Object[])new Object[0]);
        return (GetDataIngestionJobLogContentResponse)this.clientCall(request, GetDataIngestionJobLogContentResponse::builder).logger(LOG, "getDataIngestionJobLogContent").serviceDetails("GenerativeAiAgent", "GetDataIngestionJobLogContent", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataIngestionJob/GetDataIngestionJobLogContent").method(Method.GET).requestBuilder(GetDataIngestionJobLogContentRequest::builder).basePath("/20240531").appendPathParam("dataIngestionJobs").appendPathParam(request.getDataIngestionJobId()).appendPathParam("logs").appendPathParam("content").accept(new String[]{"text/plain; charset=utf-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetDataIngestionJobLogContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetDataIngestionJobLogContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (GetDataSourceResponse)this.clientCall(request, GetDataSourceResponse::builder).logger(LOG, "getDataSource").serviceDetails("GenerativeAiAgent", "GetDataSource", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataSource/GetDataSource").method(Method.GET).requestBuilder(GetDataSourceRequest::builder).basePath("/20240531").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DataSource.class, GetDataSourceResponse.Builder::dataSource).handleResponseHeaderString("etag", GetDataSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (GetKnowledgeBaseResponse)this.clientCall(request, GetKnowledgeBaseResponse::builder).logger(LOG, "getKnowledgeBase").serviceDetails("GenerativeAiAgent", "GetKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/GetKnowledgeBase").method(Method.GET).requestBuilder(GetKnowledgeBaseRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(KnowledgeBase.class, GetKnowledgeBaseResponse.Builder::knowledgeBase).handleResponseHeaderString("etag", GetKnowledgeBaseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetToolResponse getTool(GetToolRequest request) {
        Validate.notBlank((String)request.getToolId(), (String)"toolId must not be blank", (Object[])new Object[0]);
        return (GetToolResponse)this.clientCall(request, GetToolResponse::builder).logger(LOG, "getTool").serviceDetails("GenerativeAiAgent", "GetTool", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Tool/GetTool").method(Method.GET).requestBuilder(GetToolRequest::builder).basePath("/20240531").appendPathParam("tools").appendPathParam(request.getToolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Tool.class, GetToolResponse.Builder::tool).handleResponseHeaderString("etag", GetToolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetToolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("GenerativeAiAgent", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20240531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListAgentEndpointsResponse listAgentEndpoints(ListAgentEndpointsRequest request) {
        return (ListAgentEndpointsResponse)this.clientCall(request, ListAgentEndpointsResponse::builder).logger(LOG, "listAgentEndpoints").serviceDetails("GenerativeAiAgent", "ListAgentEndpoints", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/ListAgentEndpoints").method(Method.GET).requestBuilder(ListAgentEndpointsRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("agentId", (Object)request.getAgentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AgentEndpointCollection.class, ListAgentEndpointsResponse.Builder::agentEndpointCollection).handleResponseHeaderString("opc-request-id", ListAgentEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentEndpointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAgentsResponse listAgents(ListAgentsRequest request) {
        return (ListAgentsResponse)this.clientCall(request, ListAgentsResponse::builder).logger(LOG, "listAgents").serviceDetails("GenerativeAiAgent", "ListAgents", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/ListAgents").method(Method.GET).requestBuilder(ListAgentsRequest::builder).basePath("/20240531").appendPathParam("agents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AgentCollection.class, ListAgentsResponse.Builder::agentCollection).handleResponseHeaderString("opc-request-id", ListAgentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDataIngestionJobsResponse listDataIngestionJobs(ListDataIngestionJobsRequest request) {
        return (ListDataIngestionJobsResponse)this.clientCall(request, ListDataIngestionJobsResponse::builder).logger(LOG, "listDataIngestionJobs").serviceDetails("GenerativeAiAgent", "ListDataIngestionJobs", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataIngestionJob/ListDataIngestionJobs").method(Method.GET).requestBuilder(ListDataIngestionJobsRequest::builder).basePath("/20240531").appendPathParam("dataIngestionJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dataSourceId", (Object)request.getDataSourceId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DataIngestionJobCollection.class, ListDataIngestionJobsResponse.Builder::dataIngestionJobCollection).handleResponseHeaderString("opc-request-id", ListDataIngestionJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataIngestionJobsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest request) {
        return (ListDataSourcesResponse)this.clientCall(request, ListDataSourcesResponse::builder).logger(LOG, "listDataSources").serviceDetails("GenerativeAiAgent", "ListDataSources", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataSource/ListDataSources").method(Method.GET).requestBuilder(ListDataSourcesRequest::builder).basePath("/20240531").appendPathParam("dataSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("knowledgeBaseId", (Object)request.getKnowledgeBaseId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DataSourceCollection.class, ListDataSourcesResponse.Builder::dataSourceCollection).handleResponseHeaderString("opc-request-id", ListDataSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return (ListKnowledgeBasesResponse)this.clientCall(request, ListKnowledgeBasesResponse::builder).logger(LOG, "listKnowledgeBases").serviceDetails("GenerativeAiAgent", "ListKnowledgeBases", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/ListKnowledgeBases").method(Method.GET).requestBuilder(ListKnowledgeBasesRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(KnowledgeBaseCollection.class, ListKnowledgeBasesResponse.Builder::knowledgeBaseCollection).handleResponseHeaderString("opc-request-id", ListKnowledgeBasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListKnowledgeBasesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListToolsResponse listTools(ListToolsRequest request) {
        return (ListToolsResponse)this.clientCall(request, ListToolsResponse::builder).logger(LOG, "listTools").serviceDetails("GenerativeAiAgent", "ListTools", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Tool/ListTools").method(Method.GET).requestBuilder(ListToolsRequest::builder).basePath("/20240531").appendPathParam("tools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("agentId", (Object)request.getAgentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ToolCollection.class, ListToolsResponse.Builder::toolCollection).handleResponseHeaderString("opc-request-id", ListToolsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListToolsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("GenerativeAiAgent", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20240531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("GenerativeAiAgent", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20240531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("GenerativeAiAgent", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20240531").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateAgentResponse updateAgent(UpdateAgentRequest request) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDetails(), "updateAgentDetails is required");
        return (UpdateAgentResponse)this.clientCall(request, UpdateAgentResponse::builder).logger(LOG, "updateAgent").serviceDetails("GenerativeAiAgent", "UpdateAgent", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Agent/UpdateAgent").method(Method.PUT).requestBuilder(UpdateAgentRequest::builder).basePath("/20240531").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAgentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAgentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAgentEndpointResponse updateAgentEndpoint(UpdateAgentEndpointRequest request) {
        Validate.notBlank((String)request.getAgentEndpointId(), (String)"agentEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentEndpointDetails(), "updateAgentEndpointDetails is required");
        return (UpdateAgentEndpointResponse)this.clientCall(request, UpdateAgentEndpointResponse::builder).logger(LOG, "updateAgentEndpoint").serviceDetails("GenerativeAiAgent", "UpdateAgentEndpoint", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/AgentEndpoint/UpdateAgentEndpoint").method(Method.PUT).requestBuilder(UpdateAgentEndpointRequest::builder).basePath("/20240531").appendPathParam("agentEndpoints").appendPathParam(request.getAgentEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAgentEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAgentEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataSourceDetails(), "updateDataSourceDetails is required");
        return (UpdateDataSourceResponse)this.clientCall(request, UpdateDataSourceResponse::builder).logger(LOG, "updateDataSource").serviceDetails("GenerativeAiAgent", "UpdateDataSource", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/DataSource/UpdateDataSource").method(Method.PUT).requestBuilder(UpdateDataSourceRequest::builder).basePath("/20240531").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateKnowledgeBaseResponse updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateKnowledgeBaseDetails(), "updateKnowledgeBaseDetails is required");
        return (UpdateKnowledgeBaseResponse)this.clientCall(request, UpdateKnowledgeBaseResponse::builder).logger(LOG, "updateKnowledgeBase").serviceDetails("GenerativeAiAgent", "UpdateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/KnowledgeBase/UpdateKnowledgeBase").method(Method.PUT).requestBuilder(UpdateKnowledgeBaseRequest::builder).basePath("/20240531").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateToolResponse updateTool(UpdateToolRequest request) {
        Validate.notBlank((String)request.getToolId(), (String)"toolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateToolDetails(), "updateToolDetails is required");
        return (UpdateToolResponse)this.clientCall(request, UpdateToolResponse::builder).logger(LOG, "updateTool").serviceDetails("GenerativeAiAgent", "UpdateTool", "https://docs.oracle.com/iaas/api/#/en/generative-ai-agents/20240531/Tool/UpdateTool").method(Method.PUT).requestBuilder(UpdateToolRequest::builder).basePath("/20240531").appendPathParam("tools").appendPathParam(request.getToolId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateToolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateToolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerativeAiAgentWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public GenerativeAiAgentPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public GenerativeAiAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GenerativeAiAgentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GenerativeAiAgentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GenerativeAiAgentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenerativeAiAgentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GenerativeAiAgentClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "generativeaiagent";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"generativeaiagent");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public GenerativeAiAgentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GenerativeAiAgentClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

